/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Uuid;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.record.MemoryRecords;

public interface Readable {
    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    public double readDouble();

    public void readArray(byte[] var1);

    public int readUnsignedVarint();

    public ByteBuffer readByteBuffer(int var1);

    public int readVarint();

    public long readVarlong();

    default public String readString(int length) {
        byte[] arr = new byte[length];
        this.readArray(arr);
        return new String(arr, StandardCharsets.UTF_8);
    }

    default public List<RawTaggedField> readUnknownTaggedField(List<RawTaggedField> unknowns, int tag, int size) {
        if (unknowns == null) {
            unknowns = new ArrayList<RawTaggedField>();
        }
        byte[] data = new byte[size];
        this.readArray(data);
        unknowns.add(new RawTaggedField(tag, data));
        return unknowns;
    }

    default public MemoryRecords readRecords(int length) {
        if (length < 0) {
            return null;
        }
        ByteBuffer recordsBuffer = this.readByteBuffer(length);
        return MemoryRecords.readableRecords(recordsBuffer);
    }

    default public Uuid readUuid() {
        return new Uuid(this.readLong(), this.readLong());
    }

    default public int readUnsignedShort() {
        return Short.toUnsignedInt(this.readShort());
    }
}

