/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
class LatencyMarkerEmitter<OUT> {
    private final ScheduledFuture<?> latencyMarkTimer;

    public LatencyMarkerEmitter(final ProcessingTimeService processingTimeService, final EmitAction emitAction, long latencyTrackingInterval, final OperatorID operatorId, final int subtaskIndex) {
        this.latencyMarkTimer = processingTimeService.scheduleWithFixedDelay(new ProcessingTimeService.ProcessingTimeCallback(){

            public void onProcessingTime(long timestamp) {
                try {
                    emitAction.emitLatencyMarker(new LatencyMarker(processingTimeService.getCurrentProcessingTime(), operatorId, subtaskIndex));
                }
                catch (Throwable t) {
                    AbstractStreamOperator.LOG.warn("Error while emitting latency marker.", t);
                }
            }
        }, 0L, latencyTrackingInterval);
    }

    public void close() {
        this.latencyMarkTimer.cancel(true);
    }

    static interface EmitAction {
        public void emitLatencyMarker(LatencyMarker var1) throws Exception;
    }
}

