/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableColumn {
    private final String name;
    private final DataType type;
    @Nullable
    private final String expr;

    private TableColumn(String name, DataType type, @Nullable String expr) {
        this.name = name;
        this.type = type;
        this.expr = expr;
    }

    public static TableColumn of(String name, DataType type) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null!");
        Preconditions.checkNotNull((Object)type, (String)"Column type can not be null!");
        return new TableColumn(name, type, null);
    }

    public static TableColumn of(String name, DataType type, String expression) {
        Preconditions.checkNotNull((Object)name, (String)"Column name can not be null!");
        Preconditions.checkNotNull((Object)type, (String)"Column type can not be null!");
        Preconditions.checkNotNull((Object)expression, (String)"Column expression can not be null!");
        return new TableColumn(name, type, expression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableColumn that = (TableColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.expr, that.expr);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.expr);
    }

    public DataType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getExpr() {
        return Optional.ofNullable(this.expr);
    }

    public boolean isGenerated() {
        return this.expr != null;
    }
}

