/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.ArgumentTypeStrategy;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.Signature;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.util.Preconditions;

@Internal
public final class ExplicitArgumentTypeStrategy
implements ArgumentTypeStrategy {
    private final DataType expectedDataType;

    public ExplicitArgumentTypeStrategy(DataType expectedDataType) {
        this.expectedDataType = (DataType)Preconditions.checkNotNull((Object)expectedDataType);
    }

    @Override
    public Optional<DataType> inferArgumentType(CallContext callContext, int argumentPos, boolean throwOnFailure) {
        LogicalType actualType;
        LogicalType expectedType = this.expectedDataType.getLogicalType();
        if (expectedType.equals(actualType = callContext.getArgumentDataTypes().get(argumentPos).getLogicalType())) {
            return Optional.of(this.expectedDataType);
        }
        if (!LogicalTypeCasts.supportsImplicitCast(actualType, expectedType)) {
            if (throwOnFailure) {
                throw callContext.newValidationError("Unsupported argument type. Expected type '%s' but actual type was '%s'.", expectedType, actualType);
            }
            return Optional.empty();
        }
        return Optional.of(this.expectedDataType);
    }

    @Override
    public Signature.Argument getExpectedArgument(FunctionDefinition functionDefinition, int argumentPos) {
        return Signature.Argument.of(this.expectedDataType.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplicitArgumentTypeStrategy that = (ExplicitArgumentTypeStrategy)o;
        return Objects.equals(this.expectedDataType, that.expectedDataType);
    }

    public int hashCode() {
        return Objects.hash(this.expectedDataType);
    }
}

