/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@Internal
public class TableSchemaUtils {
    public static TableSchema getPhysicalSchema(TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)tableSchema);
        TableSchema.Builder builder = new TableSchema.Builder();
        tableSchema.getTableColumns().forEach(tableColumn -> {
            if (!tableColumn.isGenerated()) {
                builder.field(tableColumn.getName(), tableColumn.getType());
            }
        });
        tableSchema.getPrimaryKey().ifPresent(uniqueConstraint -> builder.primaryKey(uniqueConstraint.getName(), uniqueConstraint.getColumns().toArray(new String[0])));
        return builder.build();
    }

    public static TableSchema projectSchema(TableSchema tableSchema, int[][] projectedFields) {
        Preconditions.checkArgument((!TableSchemaUtils.containsGeneratedColumns(tableSchema) ? 1 : 0) != 0, (Object)"It's illegal to project on a schema contains computed columns.");
        TableSchema.Builder schemaBuilder = TableSchema.builder();
        List<TableColumn> tableColumns = tableSchema.getTableColumns();
        for (int[] fieldPath : projectedFields) {
            Preconditions.checkArgument((fieldPath.length == 1 ? 1 : 0) != 0, (Object)"Nested projection push down is not supported yet.");
            TableColumn column = tableColumns.get(fieldPath[0]);
            schemaBuilder.field(column.getName(), column.getType());
        }
        return schemaBuilder.build();
    }

    public static boolean containsGeneratedColumns(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        return schema.getTableColumns().stream().anyMatch(TableColumn::isGenerated);
    }

    public static TableSchema checkNoGeneratedColumns(TableSchema schema) {
        Preconditions.checkNotNull((Object)schema);
        if (TableSchemaUtils.containsGeneratedColumns(schema)) {
            throw new ValidationException("The given schema contains generated columns, schema: " + schema.toString());
        }
        return schema;
    }

    public static int[] getPrimaryKeyIndices(TableSchema schema) {
        if (schema.getPrimaryKey().isPresent()) {
            RowType physicalRowType = (RowType)schema.toPhysicalRowDataType().getLogicalType();
            List<String> fieldNames = physicalRowType.getFieldNames();
            return schema.getPrimaryKey().get().getColumns().stream().mapToInt(fieldNames::indexOf).toArray();
        }
        return new int[0];
    }

    public static TableSchema.Builder builderWithGivenSchema(TableSchema oriSchema) {
        TableSchema.Builder builder = TableSchemaUtils.builderWithGivenColumns(oriSchema.getTableColumns());
        for (WatermarkSpec wms : oriSchema.getWatermarkSpecs()) {
            builder.watermark(wms.getRowtimeAttribute(), wms.getWatermarkExpr(), wms.getWatermarkExprOutputType());
        }
        oriSchema.getPrimaryKey().map(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
        return builder;
    }

    public static TableSchema dropConstraint(TableSchema oriSchema, String constraintName) {
        Optional<UniqueConstraint> uniqueConstraintOpt = oriSchema.getPrimaryKey();
        if (!uniqueConstraintOpt.isPresent() || !uniqueConstraintOpt.get().getName().equals(constraintName)) {
            throw new ValidationException(String.format("Constraint %s to drop does not exist", constraintName));
        }
        TableSchema.Builder builder = TableSchemaUtils.builderWithGivenColumns(oriSchema.getTableColumns());
        for (WatermarkSpec wms : oriSchema.getWatermarkSpecs()) {
            builder.watermark(wms.getRowtimeAttribute(), wms.getWatermarkExpr(), wms.getWatermarkExprOutputType());
        }
        return builder.build();
    }

    private static TableSchema.Builder builderWithGivenColumns(List<TableColumn> oriColumns) {
        TableSchema.Builder builder = TableSchema.builder();
        for (TableColumn column : oriColumns) {
            if (column.isGenerated()) {
                builder.field(column.getName(), column.getType(), column.getExpr().get());
                continue;
            }
            builder.field(column.getName(), column.getType());
        }
        return builder;
    }
}

