/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.math.BigDecimal;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.HierarchyDescriptor;
import org.apache.flink.table.utils.TypeStringUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class LiteralValue
extends HierarchyDescriptor {
    private String typeInfo;
    private Object value;

    public LiteralValue of(TypeInformation<?> typeInfo) {
        Preconditions.checkNotNull(typeInfo, (String)"Type information must not be null.");
        this.typeInfo = TypeStringUtils.writeTypeInfo(typeInfo);
        return this;
    }

    public LiteralValue of(String typeString) {
        this.typeInfo = typeString;
        return this;
    }

    public LiteralValue value(boolean value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(int value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(double value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(float value) {
        this.value = Float.valueOf(value);
        return this;
    }

    public LiteralValue value(String value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(long value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(byte value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(short value) {
        this.value = value;
        return this;
    }

    public LiteralValue value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Override
    public Map<String, String> toProperties() {
        DescriptorProperties properties = new DescriptorProperties();
        this.addPropertiesWithPrefix("", properties);
        return properties.asMap();
    }

    @Override
    public void addPropertiesWithPrefix(String keyPrefix, DescriptorProperties properties) {
        if (this.typeInfo != null) {
            properties.putString(keyPrefix + "type", this.typeInfo);
            if (this.value != null) {
                properties.putString(keyPrefix + "value", String.valueOf(this.value));
            }
        } else {
            if (keyPrefix.equals("")) {
                throw new ValidationException("Literal values with implicit type must not exist in the top level of a hierarchy.");
            }
            if (this.value != null) {
                properties.putString(keyPrefix.substring(0, keyPrefix.length() - 1), String.valueOf(this.value));
            }
        }
    }
}

