/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql2rel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalLiteral;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlJdbcFunctionCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.fun.SqlArrayValueConstructor;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlDatetimeSubtractionOperator;
import org.apache.calcite.sql.fun.SqlExtractFunction;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlLiteralChainOperator;
import org.apache.calcite.sql.fun.SqlMapValueConstructor;
import org.apache.calcite.sql.fun.SqlMultisetQueryConstructor;
import org.apache.calcite.sql.fun.SqlMultisetValueConstructor;
import org.apache.calcite.sql.fun.SqlOverlapsOperator;
import org.apache.calcite.sql.fun.SqlRowOperator;
import org.apache.calcite.sql.fun.SqlSequenceValueOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlTrimFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.ReflectiveConvertletTable;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public class StandardConvertletTable
extends ReflectiveConvertletTable {
    public static final StandardConvertletTable INSTANCE = new StandardConvertletTable();

    private StandardConvertletTable() {
        this.addAlias(SqlStdOperatorTable.CHARACTER_LENGTH, SqlStdOperatorTable.CHAR_LENGTH);
        this.addAlias(SqlStdOperatorTable.IS_UNKNOWN, SqlStdOperatorTable.IS_NULL);
        this.addAlias(SqlStdOperatorTable.IS_NOT_UNKNOWN, SqlStdOperatorTable.IS_NOT_NULL);
        this.addAlias(SqlStdOperatorTable.PERCENT_REMAINDER, SqlStdOperatorTable.MOD);
        this.registerOp(SqlStdOperatorTable.CAST, this::convertCast);
        this.registerOp(SqlLibraryOperators.INFIX_CAST, this::convertCast);
        this.registerOp(SqlStdOperatorTable.IS_DISTINCT_FROM, (cx, call) -> this.convertIsDistinctFrom(cx, call, false));
        this.registerOp(SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, (cx, call) -> this.convertIsDistinctFrom(cx, call, true));
        this.registerOp(SqlStdOperatorTable.PLUS, this::convertPlus);
        this.registerOp(SqlStdOperatorTable.MINUS, (cx, call) -> {
            RexCall e = (RexCall)this.convertCall(cx, call.getOperator(), call.getOperandList());
            switch (e.getOperands().get(0).getType().getSqlTypeName()) {
                case DATE: 
                case TIME: 
                case TIMESTAMP: {
                    return this.convertDatetimeMinus(cx, SqlStdOperatorTable.MINUS_DATE, call);
                }
            }
            return e;
        });
        this.registerOp(SqlLibraryOperators.LTRIM, new TrimConvertlet(SqlTrimFunction.Flag.LEADING));
        this.registerOp(SqlLibraryOperators.RTRIM, new TrimConvertlet(SqlTrimFunction.Flag.TRAILING));
        this.registerOp(SqlLibraryOperators.GREATEST, new GreatestConvertlet());
        this.registerOp(SqlLibraryOperators.LEAST, new GreatestConvertlet());
        this.registerOp(SqlLibraryOperators.NVL, (cx, call) -> {
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexNode operand0 = cx.convertExpression(call.getOperandList().get(0));
            RexNode operand1 = cx.convertExpression(call.getOperandList().get(1));
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, ImmutableList.of(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand0), rexBuilder.makeCast(type, operand0), rexBuilder.makeCast(type, operand1)));
        });
        this.registerOp(SqlLibraryOperators.DECODE, (cx, call) -> {
            RexBuilder rexBuilder = cx.getRexBuilder();
            List<RexNode> operands = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), SqlOperandTypeChecker.Consistency.NONE);
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            ArrayList<RexNode> exprs = new ArrayList<RexNode>();
            for (int i = 1; i < operands.size() - 1; i += 2) {
                exprs.add(RelOptUtil.isDistinctFrom(rexBuilder, operands.get(0), operands.get(i), true));
                exprs.add(operands.get(i + 1));
            }
            if (operands.size() % 2 == 0) {
                exprs.add(Util.last(operands));
            } else {
                exprs.add(rexBuilder.makeNullLiteral(type));
            }
            return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, exprs);
        });
        this.registerOp(SqlStdOperatorTable.NOT_LIKE, (cx, call) -> cx.convertExpression(SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.LIKE.createCall(SqlParserPos.ZERO, call.getOperandList()))));
        this.registerOp(SqlStdOperatorTable.NOT_SIMILAR_TO, (cx, call) -> cx.convertExpression(SqlStdOperatorTable.NOT.createCall(SqlParserPos.ZERO, SqlStdOperatorTable.SIMILAR_TO.createCall(SqlParserPos.ZERO, call.getOperandList()))));
        this.registerOp(SqlStdOperatorTable.UNARY_PLUS, (cx, call) -> cx.convertExpression((SqlNode)call.operand(0)));
        this.registerOp(SqlStdOperatorTable.DOT, (cx, call) -> cx.getRexBuilder().makeFieldAccess(cx.convertExpression((SqlNode)call.operand(0)), ((SqlNode)call.operand(1)).toString(), false));
        this.registerOp(SqlStdOperatorTable.AS, (cx, call) -> cx.convertExpression((SqlNode)call.operand(0)));
        this.registerOp(SqlStdOperatorTable.SQRT, (cx, call) -> cx.convertExpression(SqlStdOperatorTable.POWER.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), SqlLiteral.createExactNumeric("0.5", SqlParserPos.ZERO)})));
        this.registerOp(SqlStdOperatorTable.JSON_VALUE, (cx, call) -> {
            SqlCall expanded = SqlStdOperatorTable.CAST.createCall(SqlParserPos.ZERO, new SqlNode[]{SqlStdOperatorTable.JSON_VALUE_ANY.createCall(SqlParserPos.ZERO, new SqlNode[]{call.operand(0), call.operand(1), call.operand(2), call.operand(3), call.operand(4), call.operand(5), null}), call.operand(6)});
            return cx.convertExpression(expanded);
        });
        this.registerOp(SqlStdOperatorTable.AVG, new AvgVarianceConvertlet(SqlKind.AVG));
        this.registerOp(SqlStdOperatorTable.STDDEV_POP, new AvgVarianceConvertlet(SqlKind.STDDEV_POP));
        this.registerOp(SqlStdOperatorTable.STDDEV_SAMP, new AvgVarianceConvertlet(SqlKind.STDDEV_SAMP));
        this.registerOp(SqlStdOperatorTable.STDDEV, new AvgVarianceConvertlet(SqlKind.STDDEV_SAMP));
        this.registerOp(SqlStdOperatorTable.VAR_POP, new AvgVarianceConvertlet(SqlKind.VAR_POP));
        this.registerOp(SqlStdOperatorTable.VAR_SAMP, new AvgVarianceConvertlet(SqlKind.VAR_SAMP));
        this.registerOp(SqlStdOperatorTable.VARIANCE, new AvgVarianceConvertlet(SqlKind.VAR_SAMP));
        this.registerOp(SqlStdOperatorTable.COVAR_POP, new RegrCovarianceConvertlet(SqlKind.COVAR_POP));
        this.registerOp(SqlStdOperatorTable.COVAR_SAMP, new RegrCovarianceConvertlet(SqlKind.COVAR_SAMP));
        this.registerOp(SqlStdOperatorTable.REGR_SXX, new RegrCovarianceConvertlet(SqlKind.REGR_SXX));
        this.registerOp(SqlStdOperatorTable.REGR_SYY, new RegrCovarianceConvertlet(SqlKind.REGR_SYY));
        FloorCeilConvertlet floorCeilConvertlet = new FloorCeilConvertlet();
        this.registerOp(SqlStdOperatorTable.FLOOR, floorCeilConvertlet);
        this.registerOp(SqlStdOperatorTable.CEIL, floorCeilConvertlet);
        this.registerOp(SqlStdOperatorTable.TIMESTAMP_ADD, new TimestampAddConvertlet());
        this.registerOp(SqlStdOperatorTable.TIMESTAMP_DIFF, new TimestampDiffConvertlet());
    }

    private RexNode or(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, a0, a1);
    }

    private RexNode eq(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, a0, a1);
    }

    private RexNode ge(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, a0, a1);
    }

    private RexNode le(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, a0, a1);
    }

    private RexNode and(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, a0, a1);
    }

    private static RexNode divideInt(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, a0, a1);
    }

    private RexNode plus(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.PLUS, a0, a1);
    }

    private RexNode minus(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MINUS, a0, a1);
    }

    private static RexNode multiply(RexBuilder rexBuilder, RexNode a0, RexNode a1) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MULTIPLY, a0, a1);
    }

    private RexNode case_(RexBuilder rexBuilder, RexNode ... args) {
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, args);
    }

    private SqlCall plus(SqlParserPos pos, SqlNode a0, SqlNode a1) {
        return SqlStdOperatorTable.PLUS.createCall(pos, a0, a1);
    }

    public RexNode convertCase(SqlRexContext cx, SqlCase call) {
        SqlNodeList whenList = call.getWhenOperands();
        SqlNodeList thenList = call.getThenOperands();
        assert (whenList.size() == thenList.size());
        RexBuilder rexBuilder = cx.getRexBuilder();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
        RexLiteral unknownLiteral = rexBuilder.makeNullLiteral(typeFactory.createSqlType(SqlTypeName.BOOLEAN));
        RexLiteral nullLiteral2 = rexBuilder.makeNullLiteral(typeFactory.createSqlType(SqlTypeName.NULL));
        for (int i = 0; i < whenList.size(); ++i) {
            if (SqlUtil.isNullLiteral(whenList.get(i), false)) {
                exprList.add(unknownLiteral);
            } else {
                exprList.add(cx.convertExpression(whenList.get(i)));
            }
            if (SqlUtil.isNullLiteral(thenList.get(i), false)) {
                exprList.add(nullLiteral2);
                continue;
            }
            exprList.add(cx.convertExpression(thenList.get(i)));
        }
        if (SqlUtil.isNullLiteral(call.getElseOperand(), false)) {
            exprList.add(nullLiteral2);
        } else {
            exprList.add(cx.convertExpression(call.getElseOperand()));
        }
        RelDataType type = rexBuilder.deriveReturnType(call.getOperator(), exprList);
        for (int i : this.elseArgs(exprList.size())) {
            exprList.set(i, rexBuilder.ensureType(type, (RexNode)exprList.get(i), false));
        }
        return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, exprList);
    }

    public RexNode convertMultiset(SqlRexContext cx, SqlMultisetValueConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubQueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall(originalType, SqlStdOperatorTable.SLICE, ImmutableList.of(expr));
        }
        return expr;
    }

    public RexNode convertArray(SqlRexContext cx, SqlArrayValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMap(SqlRexContext cx, SqlMapValueConstructor op, SqlCall call) {
        return this.convertCall(cx, call);
    }

    public RexNode convertMultisetQuery(SqlRexContext cx, SqlMultisetQueryConstructor op, SqlCall call) {
        RelDataType originalType = cx.getValidator().getValidatedNodeType(call);
        RexRangeRef rr = cx.getSubQueryExpr(call);
        assert (rr != null);
        RelDataType msType = rr.getType().getFieldList().get(0).getType();
        RexNode expr = cx.getRexBuilder().makeInputRef(msType, rr.getOffset());
        assert (msType.getComponentType().isStruct());
        if (!originalType.getComponentType().isStruct()) {
            expr = cx.getRexBuilder().makeCall((SqlOperator)SqlStdOperatorTable.SLICE, expr);
        }
        return expr;
    }

    public RexNode convertJdbc(SqlRexContext cx, SqlJdbcFunctionCall op, SqlCall call) {
        SqlCall convertedCall = op.getLookupCall();
        return cx.convertExpression(convertedCall);
    }

    protected RexNode convertCast(SqlRexContext cx, SqlCall call) {
        RexNode arg;
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        assert (call.getKind() == SqlKind.CAST);
        Object left = call.operand(0);
        Object right = call.operand(1);
        if (right instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier intervalQualifier = (SqlIntervalQualifier)right;
            if (left instanceof SqlIntervalLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue, intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            if (left instanceof SqlNumericLiteral) {
                RexLiteral sourceInterval = (RexLiteral)cx.convertExpression((SqlNode)left);
                BigDecimal sourceValue = (BigDecimal)sourceInterval.getValue();
                BigDecimal multiplier = intervalQualifier.getUnit().multiplier;
                sourceValue = sourceValue.multiply(multiplier);
                RexLiteral castedInterval = cx.getRexBuilder().makeIntervalLiteral(sourceValue, intervalQualifier);
                return this.castToValidatedType(cx, call, castedInterval);
            }
            return this.castToValidatedType(cx, call, cx.convertExpression((SqlNode)left));
        }
        SqlDataTypeSpec dataType2 = (SqlDataTypeSpec)right;
        RelDataType type = dataType2.deriveType(cx.getValidator());
        if (type == null) {
            type = cx.getValidator().getValidatedNodeType(dataType2.getTypeName());
        }
        if ((arg = cx.convertExpression((SqlNode)left)).getType().isNullable()) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        if (SqlUtil.isNullLiteral(left, false)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)cx.getValidator();
            validator.setValidatedNodeType((SqlNode)left, type);
            return cx.convertExpression((SqlNode)left);
        }
        if (null != dataType2.getCollectionsTypeName()) {
            RelDataType argComponentType = arg.getType().getComponentType();
            RelDataType componentType = type.getComponentType();
            if (argComponentType.isStruct() && !componentType.isStruct()) {
                RelDataType tt = typeFactory.builder().add(argComponentType.getFieldList().get(0).getName(), componentType).build();
                tt = typeFactory.createTypeWithNullability(tt, componentType.isNullable());
                boolean isn = type.isNullable();
                type = typeFactory.createMultisetType(tt, -1L);
                type = typeFactory.createTypeWithNullability(type, isn);
            }
        }
        return cx.getRexBuilder().makeCast(type, arg);
    }

    protected RexNode convertFloorCeil(SqlRexContext cx, SqlCall call) {
        boolean floor;
        boolean bl = floor = call.getKind() == SqlKind.FLOOR;
        if (call.operandCount() == 1 && call.operand(0) instanceof SqlIntervalLiteral) {
            SqlIntervalLiteral literal = (SqlIntervalLiteral)call.operand(0);
            SqlIntervalLiteral.IntervalValue interval = (SqlIntervalLiteral.IntervalValue)literal.getValue();
            BigDecimal val = interval.getIntervalQualifier().getStartUnit().multiplier;
            RexNode rexInterval = cx.convertExpression(literal);
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexLiteral zero = rexBuilder.makeExactLiteral(BigDecimal.valueOf(0L));
            RexNode cond = this.ge(rexBuilder, rexInterval, zero);
            RexLiteral pad = rexBuilder.makeExactLiteral(val.subtract(BigDecimal.ONE));
            RexNode cast = rexBuilder.makeReinterpretCast(rexInterval.getType(), pad, rexBuilder.makeLiteral(false));
            RexNode sum = floor ? this.minus(rexBuilder, rexInterval, cast) : this.plus(rexBuilder, rexInterval, cast);
            RexNode kase = floor ? this.case_(rexBuilder, rexInterval, cond, sum) : this.case_(rexBuilder, sum, cond, rexInterval);
            RexLiteral factor = rexBuilder.makeExactLiteral(val);
            RexNode div = StandardConvertletTable.divideInt(rexBuilder, kase, factor);
            return StandardConvertletTable.multiply(rexBuilder, div, factor);
        }
        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
    }

    public RexNode convertExtract(SqlRexContext cx, SqlExtractFunction op, SqlCall call) {
        return this.convertFunction(cx, (SqlFunction)call.getOperator(), call);
    }

    private RexNode mod(RexBuilder rexBuilder, RelDataType resType, RexNode res, BigDecimal val) {
        if (val.equals(BigDecimal.ONE)) {
            return res;
        }
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.MOD, res, rexBuilder.makeExactLiteral(val, resType));
    }

    private static RexNode divide(RexBuilder rexBuilder, RexNode res, BigDecimal val) {
        if (val.equals(BigDecimal.ONE)) {
            return res;
        }
        if (val.compareTo(BigDecimal.ONE) < 0 && val.signum() == 1) {
            try {
                BigDecimal reciprocal = BigDecimal.ONE.divide(val, RoundingMode.UNNECESSARY);
                return StandardConvertletTable.multiply(rexBuilder, res, rexBuilder.makeExactLiteral(reciprocal));
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return StandardConvertletTable.divideInt(rexBuilder, res, rexBuilder.makeExactLiteral(val));
    }

    public RexNode convertDatetimeMinus(SqlRexContext cx, SqlDatetimeSubtractionOperator op, SqlCall call) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        RelDataType resType = cx.getValidator().getValidatedNodeType(call);
        return rexBuilder.makeCall(resType, op, exprs.subList(0, 2));
    }

    public RexNode convertFunction(SqlRexContext cx, SqlFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        if (fun.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
            return StandardConvertletTable.makeConstructorCall(cx, fun, exprs);
        }
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown(call);
        if (returnType == null) {
            returnType = cx.getRexBuilder().deriveReturnType(fun, exprs);
        }
        return cx.getRexBuilder().makeCall(returnType, fun, exprs);
    }

    public RexNode convertSequenceValue(SqlRexContext cx, SqlSequenceValueOperator fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 1);
        assert (operands.get(0) instanceof SqlIdentifier);
        SqlIdentifier id = (SqlIdentifier)operands.get(0);
        String key = Util.listToString(id.names);
        RelDataType returnType = cx.getValidator().getValidatedNodeType(call);
        return cx.getRexBuilder().makeCall(returnType, fun, ImmutableList.of(cx.getRexBuilder().makeLiteral(key)));
    }

    public RexNode convertAggregateFunction(SqlRexContext cx, SqlAggFunction fun, SqlCall call) {
        List<SqlNode> operands = call.getOperandList();
        List<Object> exprs = call.isCountStar() ? ImmutableList.of() : StandardConvertletTable.convertExpressionList(cx, operands, SqlOperandTypeChecker.Consistency.NONE);
        RelDataType returnType = cx.getValidator().getValidatedNodeTypeIfKnown(call);
        final int groupCount = cx.getGroupCount();
        if (returnType == null) {
            RexCallBinding binding = new RexCallBinding(cx.getTypeFactory(), fun, exprs, ImmutableList.of()){

                @Override
                public int getGroupCount() {
                    return groupCount;
                }
            };
            returnType = fun.inferReturnType(binding);
        }
        return cx.getRexBuilder().makeCall(returnType, fun, exprs);
    }

    private static RexNode makeConstructorCall(SqlRexContext cx, SqlFunction constructor, List<RexNode> exprs) {
        final RexBuilder rexBuilder = cx.getRexBuilder();
        RelDataType type = rexBuilder.deriveReturnType(constructor, exprs);
        int n = type.getFieldCount();
        ImmutableList.Builder initializationExprs = ImmutableList.builder();
        InitializerContext initializerContext = new InitializerContext(){

            @Override
            public RexBuilder getRexBuilder() {
                return rexBuilder;
            }

            @Override
            public SqlNode validateExpression(RelDataType rowType, SqlNode expr) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RexNode convertExpression(SqlNode e) {
                throw new UnsupportedOperationException();
            }
        };
        for (int i = 0; i < n; ++i) {
            initializationExprs.add(cx.getInitializerExpressionFactory().newAttributeInitializer(type, constructor, i, exprs, initializerContext));
        }
        List<RexNode> defaultCasts = RexUtil.generateCastExpressions(rexBuilder, type, (List<RexNode>)((Object)initializationExprs.build()));
        return rexBuilder.makeNewInvocation(type, defaultCasts);
    }

    public RexNode convertCall(SqlRexContext cx, SqlCall call) {
        return this.convertCall(cx, call.getOperator(), call.getOperandList());
    }

    private RexNode convertCall(SqlRexContext cx, SqlOperator op, List<SqlNode> operands) {
        RexBuilder rexBuilder = cx.getRexBuilder();
        SqlOperandTypeChecker.Consistency consistency = op.getOperandTypeChecker() == null ? SqlOperandTypeChecker.Consistency.NONE : op.getOperandTypeChecker().getConsistency();
        List<RexNode> exprs = StandardConvertletTable.convertExpressionList(cx, operands, consistency);
        RelDataType type = rexBuilder.deriveReturnType(op, exprs);
        return rexBuilder.makeCall(type, op, RexUtil.flatten(exprs, op));
    }

    private List<Integer> elseArgs(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = count % 2;
        do {
            list.add(i);
        } while ((i += 2) < count);
        list.add(i - 1);
        return list;
    }

    private static List<RexNode> convertExpressionList(SqlRexContext cx, List<SqlNode> nodes, SqlOperandTypeChecker.Consistency consistency) {
        RelDataType type;
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        for (SqlNode node : nodes) {
            exprs.add(cx.convertExpression(node));
        }
        if (exprs.size() > 1 && (type = StandardConvertletTable.consistentType(cx, consistency, RexUtil.types(exprs))) != null) {
            ArrayList<RexNode> oldExprs = Lists.newArrayList(exprs);
            exprs.clear();
            for (RexNode expr : oldExprs) {
                exprs.add(cx.getRexBuilder().ensureType(type, expr, true));
            }
        }
        return exprs;
    }

    private static RelDataType consistentType(SqlRexContext cx, SqlOperandTypeChecker.Consistency consistency, List<RelDataType> types) {
        switch (consistency) {
            case COMPARE: {
                if (SqlTypeUtil.areSameFamily(types)) {
                    return null;
                }
                ArrayList<RelDataType> nonCharacterTypes = new ArrayList<RelDataType>();
                for (RelDataType type : types) {
                    if (type.getFamily() == SqlTypeFamily.CHARACTER) continue;
                    nonCharacterTypes.add(type);
                }
                if (!nonCharacterTypes.isEmpty()) {
                    RelDataTypeFamily family;
                    int typeCount = types.size();
                    types = nonCharacterTypes;
                    if (nonCharacterTypes.size() < typeCount && (family = ((RelDataType)nonCharacterTypes.get(0)).getFamily()) instanceof SqlTypeFamily) {
                        switch ((SqlTypeFamily)family) {
                            case INTEGER: 
                            case NUMERIC: {
                                nonCharacterTypes.add(cx.getTypeFactory().createSqlType(SqlTypeName.BIGINT));
                            }
                        }
                    }
                }
            }
            case LEAST_RESTRICTIVE: {
                return cx.getTypeFactory().leastRestrictive(types);
            }
        }
        return null;
    }

    private RexNode convertPlus(SqlRexContext cx, SqlCall call) {
        RexNode rex = this.convertCall(cx, call);
        switch (rex.getType().getSqlTypeName()) {
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                RexBuilder rexBuilder = cx.getRexBuilder();
                List<RexNode> operands = ((RexCall)rex).getOperands();
                if (operands.size() == 2) {
                    SqlTypeName sqlTypeName = operands.get(0).getType().getSqlTypeName();
                    switch (sqlTypeName) {
                        case INTERVAL_YEAR: 
                        case INTERVAL_YEAR_MONTH: 
                        case INTERVAL_MONTH: 
                        case INTERVAL_DAY: 
                        case INTERVAL_DAY_HOUR: 
                        case INTERVAL_DAY_MINUTE: 
                        case INTERVAL_DAY_SECOND: 
                        case INTERVAL_HOUR: 
                        case INTERVAL_HOUR_MINUTE: 
                        case INTERVAL_HOUR_SECOND: 
                        case INTERVAL_MINUTE: 
                        case INTERVAL_MINUTE_SECOND: 
                        case INTERVAL_SECOND: {
                            operands = ImmutableList.of(operands.get(1), operands.get(0));
                        }
                    }
                }
                return rexBuilder.makeCall(rex.getType(), SqlStdOperatorTable.DATETIME_PLUS, operands);
            }
        }
        return rex;
    }

    private RexNode convertIsDistinctFrom(SqlRexContext cx, SqlCall call, boolean neg) {
        RexNode op0 = cx.convertExpression((SqlNode)call.operand(0));
        RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
        return RelOptUtil.isDistinctFrom(cx.getRexBuilder(), op0, op1, neg);
    }

    public RexNode convertBetween(SqlRexContext cx, SqlBetweenOperator op, SqlCall call) {
        RexNode res;
        List<RexNode> list = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), op.getOperandTypeChecker().getConsistency());
        RexNode x = list.get(0);
        RexNode y = list.get(1);
        RexNode z = list.get(2);
        RexBuilder rexBuilder = cx.getRexBuilder();
        RexNode ge1 = this.ge(rexBuilder, x, y);
        RexNode le1 = this.le(rexBuilder, x, z);
        RexNode and1 = this.and(rexBuilder, ge1, le1);
        SqlBetweenOperator.Flag symmetric = op.flag;
        switch (symmetric) {
            case ASYMMETRIC: {
                res = and1;
                break;
            }
            case SYMMETRIC: {
                RexNode ge2 = this.ge(rexBuilder, x, z);
                RexNode le2 = this.le(rexBuilder, x, y);
                RexNode and2 = this.and(rexBuilder, ge2, le2);
                res = this.or(rexBuilder, and1, and2);
                break;
            }
            default: {
                throw Util.unexpected(symmetric);
            }
        }
        SqlBetweenOperator betweenOp = (SqlBetweenOperator)call.getOperator();
        if (betweenOp.isNegated()) {
            res = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, res);
        }
        return res;
    }

    public RexNode convertLiteralChain(SqlRexContext cx, SqlLiteralChainOperator op, SqlCall call) {
        Util.discard(cx);
        SqlLiteral sum = SqlLiteralChainOperator.concatenateOperands(call);
        return cx.convertLiteral(sum);
    }

    public RexNode convertRow(SqlRexContext cx, SqlRowOperator op, SqlCall call) {
        if (cx.getValidator().getValidatedNodeType(call).getSqlTypeName() != SqlTypeName.COLUMN_LIST) {
            return this.convertCall(cx, call);
        }
        RexBuilder rexBuilder = cx.getRexBuilder();
        ArrayList<RexNode> columns = new ArrayList<RexNode>();
        for (SqlNode operand : call.getOperandList()) {
            columns.add(rexBuilder.makeLiteral(((SqlIdentifier)operand).getSimple()));
        }
        RelDataType type = rexBuilder.deriveReturnType(SqlStdOperatorTable.COLUMN_LIST, columns);
        return rexBuilder.makeCall(type, SqlStdOperatorTable.COLUMN_LIST, columns);
    }

    public RexNode convertOverlaps(SqlRexContext cx, SqlOverlapsOperator op, SqlCall call) {
        assert (call.getOperandList().size() == 2);
        Pair<RexNode, RexNode> left = this.convertOverlapsOperand(cx, call.getParserPosition(), (SqlNode)call.operand(0));
        RexNode r0 = (RexNode)left.left;
        RexNode r1 = (RexNode)left.right;
        Pair<RexNode, RexNode> right = this.convertOverlapsOperand(cx, call.getParserPosition(), (SqlNode)call.operand(1));
        RexNode r2 = (RexNode)right.left;
        RexNode r3 = (RexNode)right.right;
        RexBuilder rexBuilder = cx.getRexBuilder();
        RexNode leftSwap = this.le(rexBuilder, r0, r1);
        RexNode s0 = this.case_(rexBuilder, leftSwap, r0, r1);
        RexNode e0 = this.case_(rexBuilder, leftSwap, r1, r0);
        RexNode rightSwap = this.le(rexBuilder, r2, r3);
        RexNode s1 = this.case_(rexBuilder, rightSwap, r2, r3);
        RexNode e1 = this.case_(rexBuilder, rightSwap, r3, r2);
        switch (op.kind) {
            case OVERLAPS: {
                return this.and(rexBuilder, this.ge(rexBuilder, e0, s1), this.ge(rexBuilder, e1, s0));
            }
            case CONTAINS: {
                return this.and(rexBuilder, this.le(rexBuilder, s0, s1), this.ge(rexBuilder, e0, e1));
            }
            case PERIOD_EQUALS: {
                return this.and(rexBuilder, this.eq(rexBuilder, s0, s1), this.eq(rexBuilder, e0, e1));
            }
            case PRECEDES: {
                return this.le(rexBuilder, e0, s1);
            }
            case IMMEDIATELY_PRECEDES: {
                return this.eq(rexBuilder, e0, s1);
            }
            case SUCCEEDS: {
                return this.ge(rexBuilder, s0, e1);
            }
            case IMMEDIATELY_SUCCEEDS: {
                return this.eq(rexBuilder, s0, e1);
            }
        }
        throw new AssertionError(op);
    }

    private Pair<RexNode, RexNode> convertOverlapsOperand(SqlRexContext cx, SqlParserPos pos, SqlNode operand) {
        SqlNode a1;
        SqlNode a0;
        switch (operand.getKind()) {
            case ROW: {
                a0 = ((SqlCall)operand).operand(0);
                Object a10 = ((SqlCall)operand).operand(1);
                RelDataType t1 = cx.getValidator().getValidatedNodeType((SqlNode)a10);
                if (SqlTypeUtil.isInterval(t1)) {
                    a1 = this.plus(pos, a0, (SqlNode)a10);
                    break;
                }
                a1 = a10;
                break;
            }
            default: {
                a0 = operand;
                a1 = operand;
            }
        }
        RexNode r0 = cx.convertExpression(a0);
        RexNode r1 = cx.convertExpression(a1);
        return Pair.of(r0, r1);
    }

    public RexNode castToValidatedType(SqlRexContext cx, SqlCall call, RexNode value) {
        return StandardConvertletTable.castToValidatedType(call, value, cx.getValidator(), cx.getRexBuilder());
    }

    public static RexNode castToValidatedType(SqlNode node, RexNode e, SqlValidator validator, RexBuilder rexBuilder) {
        RelDataType type = validator.getValidatedNodeType(node);
        if (e.getType() == type) {
            return e;
        }
        return rexBuilder.makeCast(type, e);
    }

    private static /* synthetic */ RexNode lambda$new$13(SqlRexContext cx, SqlCall call) {
        assert (call.operandCount() == 1);
        Object operand = call.operand(0);
        RexNode expr = cx.convertExpression(SqlStdOperatorTable.ELEMENT.createCall(SqlParserPos.ZERO, new SqlNode[]{operand}));
        return cx.getRexBuilder().makeFieldAccess(expr, 0);
    }

    private /* synthetic */ RexNode lambda$new$12(SqlRexContext cx, SqlCall call) {
        assert (call.operandCount() == 1);
        Object operand = call.operand(0);
        RelDataType type = cx.getValidator().getValidatedNodeType((SqlNode)operand);
        if (!type.getComponentType().isStruct()) {
            return cx.convertExpression(SqlStdOperatorTable.ELEMENT_SLICE.createCall(SqlParserPos.ZERO, new SqlNode[]{operand}));
        }
        return this.convertCall(cx, call);
    }

    private static class TimestampDiffConvertlet
    implements SqlRexConvertlet {
        private TimestampDiffConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            SqlLiteral unitLiteral = (SqlLiteral)call.operand(0);
            TimeUnit unit = unitLiteral.symbolValue(TimeUnit.class);
            BigDecimal multiplier = BigDecimal.ONE;
            BigDecimal divider = BigDecimal.ONE;
            SqlTypeName sqlTypeName = unit == TimeUnit.NANOSECOND ? SqlTypeName.BIGINT : SqlTypeName.INTEGER;
            switch (unit) {
                case MICROSECOND: 
                case NANOSECOND: 
                case MILLISECOND: 
                case WEEK: {
                    multiplier = BigDecimal.valueOf(1000L);
                    divider = unit.multiplier;
                    unit = TimeUnit.SECOND;
                    break;
                }
                case QUARTER: {
                    divider = unit.multiplier;
                    unit = TimeUnit.MONTH;
                }
            }
            SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, SqlParserPos.ZERO);
            RexNode op2 = cx.convertExpression((SqlNode)call.operand(2));
            RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
            RelDataType intervalType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlIntervalType(qualifier), op1.getType().isNullable() || op2.getType().isNullable());
            RexCall rexCall = (RexCall)rexBuilder.makeCall(intervalType, SqlStdOperatorTable.MINUS_DATE, ImmutableList.of(op2, op1));
            RelDataType intType = cx.getTypeFactory().createTypeWithNullability(cx.getTypeFactory().createSqlType(sqlTypeName), SqlTypeUtil.containsNullable(rexCall.getType()));
            RexNode e = rexBuilder.makeCast(intType, rexCall);
            return rexBuilder.multiplyDivide(e, multiplier, divider);
        }
    }

    private static class TimestampAddConvertlet
    implements SqlRexConvertlet {
        private TimestampAddConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexNode interval2Add;
            RexBuilder rexBuilder = cx.getRexBuilder();
            SqlLiteral unitLiteral = (SqlLiteral)call.operand(0);
            TimeUnit unit = unitLiteral.symbolValue(TimeUnit.class);
            SqlIntervalQualifier qualifier = new SqlIntervalQualifier(unit, null, unitLiteral.getParserPosition());
            RexNode op1 = cx.convertExpression((SqlNode)call.operand(1));
            switch (unit) {
                case MICROSECOND: 
                case NANOSECOND: {
                    interval2Add = StandardConvertletTable.divide(rexBuilder, StandardConvertletTable.multiply(rexBuilder, rexBuilder.makeIntervalLiteral(BigDecimal.ONE, qualifier), op1), BigDecimal.ONE.divide(unit.multiplier, RoundingMode.UNNECESSARY));
                    break;
                }
                default: {
                    interval2Add = StandardConvertletTable.multiply(rexBuilder, rexBuilder.makeIntervalLiteral(unit.multiplier, qualifier), op1);
                }
            }
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DATETIME_PLUS, cx.convertExpression((SqlNode)call.operand(2)), interval2Add);
        }
    }

    private class FloorCeilConvertlet
    implements SqlRexConvertlet {
        private FloorCeilConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            return StandardConvertletTable.this.convertFloorCeil(cx, call);
        }
    }

    private static class GreatestConvertlet
    implements SqlRexConvertlet {
        private GreatestConvertlet() {
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlBinaryOperator op;
            RexBuilder rexBuilder = cx.getRexBuilder();
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            switch (call.getKind()) {
                case GREATEST: {
                    op = SqlStdOperatorTable.GREATER_THAN;
                    break;
                }
                case LEAST: {
                    op = SqlStdOperatorTable.LESS_THAN;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            List exprs = StandardConvertletTable.convertExpressionList(cx, call.getOperandList(), SqlOperandTypeChecker.Consistency.NONE);
            ArrayList<RexNode> list = new ArrayList<RexNode>();
            ArrayList<RexNode> orList = new ArrayList<RexNode>();
            for (RexNode expr : exprs) {
                orList.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, expr));
            }
            list.add(RexUtil.composeDisjunction(rexBuilder, orList));
            list.add(rexBuilder.makeNullLiteral(type));
            for (int i = 0; i < exprs.size() - 1; ++i) {
                RexNode expr;
                expr = (RexNode)exprs.get(i);
                ArrayList<RexNode> andList = new ArrayList<RexNode>();
                for (int j2 = i + 1; j2 < exprs.size(); ++j2) {
                    RexNode expr2 = (RexNode)exprs.get(j2);
                    andList.add(rexBuilder.makeCall((SqlOperator)op, expr, expr2));
                }
                list.add(RexUtil.composeConjunction(rexBuilder, andList));
                list.add(expr);
            }
            list.add((RexNode)exprs.get(exprs.size() - 1));
            return rexBuilder.makeCall(type, SqlStdOperatorTable.CASE, list);
        }
    }

    private static class TrimConvertlet
    implements SqlRexConvertlet {
        private final SqlTrimFunction.Flag flag;

        TrimConvertlet(SqlTrimFunction.Flag flag) {
            this.flag = flag;
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            RexBuilder rexBuilder = cx.getRexBuilder();
            RexNode operand = cx.convertExpression(call.getOperandList().get(0));
            return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.TRIM, rexBuilder.makeFlag(this.flag), rexBuilder.makeLiteral(" "), operand);
        }
    }

    private static class AvgVarianceConvertlet
    implements SqlRexConvertlet {
        private final SqlKind kind;

        AvgVarianceConvertlet(SqlKind kind) {
            this.kind = kind;
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlNode expr;
            assert (call.operandCount() == 1);
            Object arg = call.operand(0);
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            switch (this.kind) {
                case AVG: {
                    expr = this.expandAvg((SqlNode)arg, type, cx);
                    break;
                }
                case STDDEV_POP: {
                    expr = this.expandVariance((SqlNode)arg, type, cx, true, true);
                    break;
                }
                case STDDEV_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, type, cx, false, true);
                    break;
                }
                case VAR_POP: {
                    expr = this.expandVariance((SqlNode)arg, type, cx, true, false);
                    break;
                }
                case VAR_SAMP: {
                    expr = this.expandVariance((SqlNode)arg, type, cx, false, false);
                    break;
                }
                default: {
                    throw Util.unexpected(this.kind);
                }
            }
            RexNode rex = cx.convertExpression(expr);
            return cx.getRexBuilder().ensureType(type, rex, true);
        }

        private SqlNode expandAvg(SqlNode arg, RelDataType avgType, SqlRexContext cx) {
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            RexNode sumRex = cx.convertExpression(sum);
            SqlNode sumCast = this.getCastedSqlNode(sum, avgType, pos, sumRex);
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            return SqlStdOperatorTable.DIVIDE.createCall(pos, sumCast, count);
        }

        private SqlNode expandVariance(SqlNode argInput, RelDataType varType, SqlRexContext cx, boolean biased, boolean sqrt) {
            SqlNode denominator;
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlNode arg = this.getCastedSqlNode(argInput, varType, pos, cx.convertExpression(argInput));
            SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg, arg);
            SqlNode argSquaredCasted = this.getCastedSqlNode(argSquared, varType, pos, cx.convertExpression(argSquared));
            SqlCall sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquaredCasted);
            SqlNode sumArgSquaredCasted = this.getCastedSqlNode(sumArgSquared, varType, pos, cx.convertExpression(sumArgSquared));
            SqlCall sum = SqlStdOperatorTable.SUM.createCall(pos, arg);
            SqlNode sumCasted = this.getCastedSqlNode(sum, varType, pos, cx.convertExpression(sum));
            SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sumCasted, sumCasted);
            SqlNode sumSquaredCasted = this.getCastedSqlNode(sumSquared, varType, pos, cx.convertExpression(sumSquared));
            SqlCall count = SqlStdOperatorTable.COUNT.createCall(pos, arg);
            SqlNode countCasted = this.getCastedSqlNode(count, varType, pos, cx.convertExpression(count));
            SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquaredCasted, countCasted);
            SqlNode avgSumSquaredCasted = this.getCastedSqlNode(avgSumSquared, varType, pos, cx.convertExpression(avgSumSquared));
            SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquaredCasted, avgSumSquaredCasted);
            SqlNode diffCasted = this.getCastedSqlNode(diff, varType, pos, cx.convertExpression(diff));
            if (biased) {
                denominator = countCasted;
            } else {
                SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
                SqlLiteral nullLiteral2 = SqlLiteral.createNull(SqlParserPos.ZERO);
                denominator = new SqlCase(SqlParserPos.ZERO, count, SqlNodeList.of(SqlStdOperatorTable.EQUALS.createCall(pos, count, one)), SqlNodeList.of(this.getCastedSqlNode(nullLiteral2, varType, pos, null)), SqlStdOperatorTable.MINUS.createCall(pos, count, one));
            }
            SqlCall div = SqlStdOperatorTable.DIVIDE.createCall(pos, diffCasted, denominator);
            SqlNode divCasted = this.getCastedSqlNode(div, varType, pos, cx.convertExpression(div));
            SqlCall result = div;
            if (sqrt) {
                SqlNumericLiteral half = SqlLiteral.createExactNumeric("0.5", pos);
                result = SqlStdOperatorTable.POWER.createCall(pos, divCasted, half);
            }
            return result;
        }

        private SqlNode getCastedSqlNode(SqlNode argInput, RelDataType varType, SqlParserPos pos, RexNode argRex) {
            SqlNode arg = argRex != null && !argRex.getType().equals(varType) ? SqlStdOperatorTable.CAST.createCall(pos, argInput, SqlTypeUtil.convertTypeToSpec(varType)) : argInput;
            return arg;
        }
    }

    private static class RegrCovarianceConvertlet
    implements SqlRexConvertlet {
        private final SqlKind kind;

        RegrCovarianceConvertlet(SqlKind kind) {
            this.kind = kind;
        }

        @Override
        public RexNode convertCall(SqlRexContext cx, SqlCall call) {
            SqlNode expr;
            assert (call.operandCount() == 2);
            Object arg1 = call.operand(0);
            Object arg2 = call.operand(1);
            RelDataType type = cx.getValidator().getValidatedNodeType(call);
            switch (this.kind) {
                case COVAR_POP: {
                    expr = this.expandCovariance((SqlNode)arg1, (SqlNode)arg2, null, type, cx, true);
                    break;
                }
                case COVAR_SAMP: {
                    expr = this.expandCovariance((SqlNode)arg1, (SqlNode)arg2, null, type, cx, false);
                    break;
                }
                case REGR_SXX: {
                    expr = this.expandRegrSzz((SqlNode)arg2, (SqlNode)arg1, type, cx, true);
                    break;
                }
                case REGR_SYY: {
                    expr = this.expandRegrSzz((SqlNode)arg1, (SqlNode)arg2, type, cx, true);
                    break;
                }
                default: {
                    throw Util.unexpected(this.kind);
                }
            }
            RexNode rex = cx.convertExpression(expr);
            return cx.getRexBuilder().ensureType(type, rex, true);
        }

        private SqlNode expandRegrSzz(SqlNode arg1, SqlNode arg2, RelDataType avgType, SqlRexContext cx, boolean variance) {
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlCall count = SqlStdOperatorTable.REGR_COUNT.createCall(pos, arg1, arg2);
            SqlNode varPop = this.expandCovariance(arg1, variance ? arg1 : arg2, arg2, avgType, cx, true);
            RexNode varPopRex = cx.convertExpression(varPop);
            SqlNode varPopCast = this.getCastedSqlNode(varPop, avgType, pos, varPopRex);
            return SqlStdOperatorTable.MULTIPLY.createCall(pos, varPopCast, count);
        }

        private SqlNode expandCovariance(SqlNode arg0Input, SqlNode arg1Input, SqlNode dependent, RelDataType varType, SqlRexContext cx, boolean biased) {
            SqlNode denominator;
            SqlCall count;
            SqlCall sum1;
            SqlCall sum0;
            SqlCall sumArgSquared;
            SqlParserPos pos = SqlParserPos.ZERO;
            SqlLiteral nullLiteral2 = SqlLiteral.createNull(SqlParserPos.ZERO);
            RexNode arg0Rex = cx.convertExpression(arg0Input);
            RexNode arg1Rex = cx.convertExpression(arg1Input);
            SqlNode arg0 = this.getCastedSqlNode(arg0Input, varType, pos, arg0Rex);
            SqlNode arg1 = this.getCastedSqlNode(arg1Input, varType, pos, arg1Rex);
            SqlCall argSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, arg0, arg1);
            if (dependent == null) {
                sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared);
                sum0 = SqlStdOperatorTable.SUM.createCall(pos, arg0, arg1);
                sum1 = SqlStdOperatorTable.SUM.createCall(pos, arg1, arg0);
                count = SqlStdOperatorTable.REGR_COUNT.createCall(pos, arg0, arg1);
            } else {
                sumArgSquared = SqlStdOperatorTable.SUM.createCall(pos, argSquared, dependent);
                sum0 = SqlStdOperatorTable.SUM.createCall(pos, arg0, Objects.equals(dependent, arg0Input) ? arg1 : dependent);
                sum1 = SqlStdOperatorTable.SUM.createCall(pos, arg1, Objects.equals(dependent, arg1Input) ? arg0 : dependent);
                count = SqlStdOperatorTable.REGR_COUNT.createCall(pos, arg0, Objects.equals(dependent, arg0Input) ? arg1 : dependent);
            }
            SqlCall sumSquared = SqlStdOperatorTable.MULTIPLY.createCall(pos, sum0, sum1);
            SqlNode countCasted = this.getCastedSqlNode(count, varType, pos, cx.convertExpression(count));
            SqlCall avgSumSquared = SqlStdOperatorTable.DIVIDE.createCall(pos, sumSquared, countCasted);
            SqlCall diff = SqlStdOperatorTable.MINUS.createCall(pos, sumArgSquared, avgSumSquared);
            if (biased) {
                denominator = countCasted;
            } else {
                SqlNumericLiteral one = SqlLiteral.createExactNumeric("1", pos);
                denominator = new SqlCase(SqlParserPos.ZERO, countCasted, SqlNodeList.of(SqlStdOperatorTable.EQUALS.createCall(pos, countCasted, one)), SqlNodeList.of(this.getCastedSqlNode(nullLiteral2, varType, pos, null)), SqlStdOperatorTable.MINUS.createCall(pos, countCasted, one));
            }
            return SqlStdOperatorTable.DIVIDE.createCall(pos, diff, denominator);
        }

        private SqlNode getCastedSqlNode(SqlNode argInput, RelDataType varType, SqlParserPos pos, RexNode argRex) {
            SqlNode arg = argRex != null && !argRex.getType().equals(varType) ? SqlStdOperatorTable.CAST.createCall(pos, argInput, SqlTypeUtil.convertTypeToSpec(varType)) : argInput;
            return arg;
        }
    }
}

