/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.util.FlinkRuntimeException;

public final class ListAggWsWithRetractAggFunction
extends AggregateFunction<StringData, ListAggWsWithRetractAccumulator> {
    private static final long serialVersionUID = -8627988150350160473L;

    public ListAggWsWithRetractAccumulator createAccumulator() {
        return new ListAggWsWithRetractAccumulator();
    }

    public void accumulate(ListAggWsWithRetractAccumulator acc, StringData value, StringData lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            acc.list.add((Object)value);
        }
    }

    public void retract(ListAggWsWithRetractAccumulator acc, StringData value, StringData lineDelimiter) throws Exception {
        if (value != null) {
            acc.delimiter = lineDelimiter;
            if (!acc.list.remove((Object)value)) {
                acc.retractList.add((Object)value);
            }
        }
    }

    public void merge(ListAggWsWithRetractAccumulator acc, Iterable<ListAggWsWithRetractAccumulator> its) throws Exception {
        for (ListAggWsWithRetractAccumulator otherAcc : its) {
            Object binaryString2;
            if (!otherAcc.list.get().iterator().hasNext() && !otherAcc.retractList.get().iterator().hasNext()) continue;
            acc.delimiter = otherAcc.delimiter;
            ArrayList<StringData> buffer = new ArrayList<StringData>();
            for (Object binaryString2 : acc.list.get()) {
                buffer.add((StringData)binaryString2);
            }
            for (Object binaryString2 : otherAcc.list.get()) {
                buffer.add((StringData)binaryString2);
            }
            ArrayList<StringData> retractBuffer = new ArrayList<StringData>();
            for (StringData binaryString3 : acc.retractList.get()) {
                retractBuffer.add(binaryString3);
            }
            binaryString2 = otherAcc.retractList.get().iterator();
            while (binaryString2.hasNext()) {
                StringData binaryString3;
                binaryString3 = (StringData)binaryString2.next();
                retractBuffer.add(binaryString3);
            }
            ArrayList<StringData> newRetractBuffer = new ArrayList<StringData>();
            for (StringData binaryString4 : retractBuffer) {
                if (buffer.remove(binaryString4)) continue;
                newRetractBuffer.add(binaryString4);
            }
            acc.list.clear();
            acc.list.addAll(buffer);
            acc.retractList.clear();
            acc.retractList.addAll(newRetractBuffer);
        }
    }

    public StringData getValue(ListAggWsWithRetractAccumulator acc) {
        try {
            Iterable accList = acc.list.get();
            if (accList == null || !accList.iterator().hasNext()) {
                return null;
            }
            return BinaryStringDataUtil.concatWs((BinaryStringData)((BinaryStringData)acc.delimiter), (Iterable)accList);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void resetAccumulator(ListAggWsWithRetractAccumulator acc) {
        acc.delimiter = StringData.fromString((String)",");
        acc.list.clear();
        acc.retractList.clear();
    }

    public static class ListAggWsWithRetractAccumulator {
        public ListView<StringData> list = new ListView((TypeInformation)StringDataTypeInfo.INSTANCE);
        public ListView<StringData> retractList = new ListView((TypeInformation)StringDataTypeInfo.INSTANCE);
        public StringData delimiter = StringData.fromString((String)",");

        @VisibleForTesting
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListAggWsWithRetractAccumulator that = (ListAggWsWithRetractAccumulator)o;
            return Objects.equals(this.list, that.list) && Objects.equals(this.retractList, that.retractList) && Objects.equals(this.delimiter, that.delimiter);
        }
    }
}

