/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.sql;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql.util.ReflectiveSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.sql.validate.SqlNameMatchers;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.sql.CalciteSqlFunction;
import org.apache.flink.table.planner.functions.sql.ProctimeMaterializeSqlFunction;
import org.apache.flink.table.planner.functions.sql.SqlFirstLastValueAggFunction;
import org.apache.flink.table.planner.functions.sql.SqlListAggFunction;
import org.apache.flink.table.planner.functions.sql.StreamRecordTimestampSqlFunction;
import org.apache.flink.table.planner.functions.sql.internal.SqlAuxiliaryGroupAggFunction;
import org.apache.flink.table.planner.plan.type.FlinkReturnTypes;
import org.apache.flink.table.planner.plan.type.NumericExceptFirstOperandChecker;

public class FlinkSqlOperatorTable
extends ReflectiveSqlOperatorTable {
    private static FlinkSqlOperatorTable instance;
    private static final SqlReturnTypeInference ROWTIME_TYPE_INFERENCE;
    private static final SqlReturnTypeInference PROCTIME_TYPE_INFERENCE;
    public static final SqlFunction PROCTIME;
    public static final SqlFunction MATCH_ROWTIME;
    public static final SqlFunction MATCH_PROCTIME;
    public static final SqlFunction PROCTIME_MATERIALIZE;
    public static final SqlFunction STREAMRECORD_TIMESTAMP;
    public static final SqlFunction E;
    public static final SqlFunction PI_FUNCTION;
    public static final SqlFunction CONCAT_FUNCTION;
    public static final SqlFunction CONCAT_WS;
    public static final SqlFunction LOG;
    public static final SqlFunction LOG2;
    public static final SqlFunction ROUND;
    public static final SqlFunction BIN;
    public static final SqlFunction SINH;
    public static final SqlFunction HEX;
    public static final SqlFunction STR_TO_MAP;
    public static final SqlFunction IS_DECIMAL;
    public static final SqlFunction IS_DIGIT;
    public static final SqlFunction IS_ALPHA;
    public static final SqlFunction COSH;
    public static final SqlFunction TANH;
    public static final SqlFunction CHR;
    public static final SqlFunction LPAD;
    public static final SqlFunction RPAD;
    public static final SqlFunction REPEAT;
    public static final SqlFunction REVERSE;
    public static final SqlFunction REPLACE;
    public static final SqlFunction SPLIT_INDEX;
    public static final SqlFunction REGEXP_REPLACE;
    public static final SqlFunction REGEXP_EXTRACT;
    public static final SqlFunction HASH_CODE;
    public static final SqlFunction MD5;
    public static final SqlFunction SHA1;
    public static final SqlFunction SHA224;
    public static final SqlFunction SHA256;
    public static final SqlFunction SHA384;
    public static final SqlFunction SHA512;
    public static final SqlFunction SHA2;
    public static final SqlFunction DATE_FORMAT;
    public static final SqlFunction REGEXP;
    public static final SqlFunction PARSE_URL;
    public static final SqlFunction PRINT;
    public static final SqlFunction NOW;
    public static final SqlFunction UNIX_TIMESTAMP;
    public static final SqlFunction FROM_UNIXTIME;
    public static final SqlFunction IF;
    public static final SqlFunction TO_BASE64;
    public static final SqlFunction FROM_BASE64;
    public static final SqlFunction UUID;
    public static final SqlFunction SUBSTRING;
    public static final SqlFunction SUBSTR;
    public static final SqlFunction LEFT;
    public static final SqlFunction RIGHT;
    public static final SqlFunction TO_TIMESTAMP;
    public static final SqlFunction TO_DATE;
    public static final SqlFunction CONVERT_TZ;
    public static final SqlFunction LOCATE;
    public static final SqlFunction ASCII;
    public static final SqlFunction ENCODE;
    public static final SqlFunction DECODE;
    public static final SqlFunction INSTR;
    public static final SqlFunction LTRIM;
    public static final SqlFunction RTRIM;
    public static final SqlAggFunction AUXILIARY_GROUP;
    public static final SqlFirstLastValueAggFunction FIRST_VALUE;
    public static final SqlFirstLastValueAggFunction LAST_VALUE;
    public static final SqlListAggFunction LISTAGG;
    public static final SqlGroupedWindowFunction TUMBLE;
    public static final SqlGroupedWindowFunction TUMBLE_START;
    public static final SqlGroupedWindowFunction TUMBLE_END;
    public static final SqlGroupedWindowFunction TUMBLE_ROWTIME;
    public static final SqlGroupedWindowFunction TUMBLE_PROCTIME;
    public static final SqlGroupedWindowFunction HOP;
    public static final SqlGroupedWindowFunction HOP_START;
    public static final SqlGroupedWindowFunction HOP_END;
    public static final SqlGroupedWindowFunction HOP_ROWTIME;
    public static final SqlGroupedWindowFunction HOP_PROCTIME;
    public static final SqlGroupedWindowFunction SESSION;
    public static final SqlGroupedWindowFunction SESSION_START;
    public static final SqlGroupedWindowFunction SESSION_END;
    public static final SqlGroupedWindowFunction SESSION_ROWTIME;
    public static final SqlGroupedWindowFunction SESSION_PROCTIME;
    public static final SqlOperator UNION;
    public static final SqlOperator UNION_ALL;
    public static final SqlOperator EXCEPT;
    public static final SqlOperator EXCEPT_ALL;
    public static final SqlOperator INTERSECT;
    public static final SqlOperator INTERSECT_ALL;
    public static final SqlOperator AND;
    public static final SqlOperator AS;
    public static final SqlOperator CONCAT;
    public static final SqlOperator DIVIDE;
    public static final SqlOperator DIVIDE_INTEGER;
    public static final SqlOperator DOT;
    public static final SqlOperator EQUALS;
    public static final SqlOperator GREATER_THAN;
    public static final SqlOperator IS_DISTINCT_FROM;
    public static final SqlOperator IS_NOT_DISTINCT_FROM;
    public static final SqlOperator GREATER_THAN_OR_EQUAL;
    public static final SqlOperator LESS_THAN;
    public static final SqlOperator LESS_THAN_OR_EQUAL;
    public static final SqlOperator MINUS;
    public static final SqlOperator MINUS_DATE;
    public static final SqlOperator MULTIPLY;
    public static final SqlOperator NOT_EQUALS;
    public static final SqlOperator OR;
    public static final SqlOperator PLUS;
    public static final SqlOperator DATETIME_PLUS;
    public static final SqlOperator DESC;
    public static final SqlOperator NULLS_FIRST;
    public static final SqlOperator NULLS_LAST;
    public static final SqlOperator IS_NOT_NULL;
    public static final SqlOperator IS_NULL;
    public static final SqlOperator IS_NOT_TRUE;
    public static final SqlOperator IS_TRUE;
    public static final SqlOperator IS_NOT_FALSE;
    public static final SqlOperator IS_FALSE;
    public static final SqlOperator IS_NOT_UNKNOWN;
    public static final SqlOperator IS_UNKNOWN;
    public static final SqlOperator NOT;
    public static final SqlOperator UNARY_MINUS;
    public static final SqlOperator UNARY_PLUS;
    public static final SqlFunction GROUP_ID;
    public static final SqlFunction GROUPING;
    public static final SqlFunction GROUPING_ID;
    public static final SqlAggFunction SUM;
    public static final SqlAggFunction SUM0;
    public static final SqlAggFunction COUNT;
    public static final SqlAggFunction COLLECT;
    public static final SqlAggFunction MIN;
    public static final SqlAggFunction MAX;
    public static final SqlAggFunction AVG;
    public static final SqlAggFunction STDDEV;
    public static final SqlAggFunction STDDEV_POP;
    public static final SqlAggFunction STDDEV_SAMP;
    public static final SqlAggFunction VARIANCE;
    public static final SqlAggFunction VAR_POP;
    public static final SqlAggFunction VAR_SAMP;
    public static final SqlAggFunction SINGLE_VALUE;
    public static final SqlOperator ARRAY_VALUE_CONSTRUCTOR;
    public static final SqlOperator ELEMENT;
    public static final SqlOperator MAP_VALUE_CONSTRUCTOR;
    public static final SqlOperator ITEM;
    public static final SqlOperator CARDINALITY;
    public static final SqlOperator MULTISET_VALUE;
    public static final SqlOperator ROW;
    public static final SqlOperator OVERLAPS;
    public static final SqlOperator LITERAL_CHAIN;
    public static final SqlOperator BETWEEN;
    public static final SqlOperator SYMMETRIC_BETWEEN;
    public static final SqlOperator NOT_BETWEEN;
    public static final SqlOperator SYMMETRIC_NOT_BETWEEN;
    public static final SqlOperator NOT_LIKE;
    public static final SqlOperator LIKE;
    public static final SqlOperator NOT_SIMILAR_TO;
    public static final SqlOperator SIMILAR_TO;
    public static final SqlOperator CASE;
    public static final SqlOperator REINTERPRET;
    public static final SqlOperator EXTRACT;
    public static final SqlOperator IN;
    public static final SqlOperator NOT_IN;
    public static final SqlFunction OVERLAY;
    public static final SqlFunction TRIM;
    public static final SqlFunction POSITION;
    public static final SqlFunction CHAR_LENGTH;
    public static final SqlFunction CHARACTER_LENGTH;
    public static final SqlFunction UPPER;
    public static final SqlFunction LOWER;
    public static final SqlFunction INITCAP;
    public static final SqlFunction POWER;
    public static final SqlFunction SQRT;
    public static final SqlFunction MOD;
    public static final SqlFunction LN;
    public static final SqlFunction LOG10;
    public static final SqlFunction ABS;
    public static final SqlFunction EXP;
    public static final SqlFunction NULLIF;
    public static final SqlFunction COALESCE;
    public static final SqlFunction FLOOR;
    public static final SqlFunction CEIL;
    public static final SqlFunction LOCALTIME;
    public static final SqlFunction LOCALTIMESTAMP;
    public static final SqlFunction CURRENT_TIME;
    public static final SqlFunction CURRENT_TIMESTAMP;
    public static final SqlFunction CURRENT_DATE;
    public static final SqlFunction CAST;
    public static final SqlOperator SCALAR_QUERY;
    public static final SqlOperator EXISTS;
    public static final SqlFunction SIN;
    public static final SqlFunction COS;
    public static final SqlFunction TAN;
    public static final SqlFunction COT;
    public static final SqlFunction ASIN;
    public static final SqlFunction ACOS;
    public static final SqlFunction ATAN;
    public static final SqlFunction ATAN2;
    public static final SqlFunction DEGREES;
    public static final SqlFunction RADIANS;
    public static final SqlFunction SIGN;
    public static final SqlFunction PI;
    public static final SqlFunction RAND;
    public static final SqlFunction RAND_INTEGER;
    public static final SqlFunction TRUNCATE;
    public static final SqlFunction YEAR;
    public static final SqlFunction QUARTER;
    public static final SqlFunction MONTH;
    public static final SqlFunction WEEK;
    public static final SqlFunction HOUR;
    public static final SqlFunction MINUTE;
    public static final SqlFunction SECOND;
    public static final SqlFunction DAYOFYEAR;
    public static final SqlFunction DAYOFMONTH;
    public static final SqlFunction DAYOFWEEK;
    public static final SqlFunction TIMESTAMP_ADD;
    public static final SqlFunction TIMESTAMP_DIFF;
    public static final SqlFunction FIRST;
    public static final SqlFunction LAST;
    public static final SqlFunction PREV;
    public static final SqlFunction NEXT;
    public static final SqlFunction CLASSIFIER;
    public static final SqlOperator FINAL;
    public static final SqlOperator RUNNING;
    public static final SqlAggFunction RANK;
    public static final SqlAggFunction DENSE_RANK;
    public static final SqlAggFunction ROW_NUMBER;
    public static final SqlAggFunction LEAD;
    public static final SqlAggFunction LAG;
    public static final SqlPostfixOperator IS_JSON_VALUE;
    public static final SqlPostfixOperator IS_JSON_OBJECT;
    public static final SqlPostfixOperator IS_JSON_ARRAY;
    public static final SqlPostfixOperator IS_JSON_SCALAR;
    public static final SqlPostfixOperator IS_NOT_JSON_VALUE;
    public static final SqlPostfixOperator IS_NOT_JSON_OBJECT;
    public static final SqlPostfixOperator IS_NOT_JSON_ARRAY;
    public static final SqlPostfixOperator IS_NOT_JSON_SCALAR;

    public static synchronized FlinkSqlOperatorTable instance() {
        if (instance == null) {
            instance = new FlinkSqlOperatorTable();
            instance.init();
        }
        return instance;
    }

    private static SqlReturnTypeInference createTimeIndicatorReturnType(boolean isRowTime) {
        return ReturnTypes.explicit(factory -> {
            if (isRowTime) {
                return ((FlinkTypeFactory)factory).createRowtimeIndicatorType(false);
            }
            return ((FlinkTypeFactory)factory).createProctimeIndicatorType(false);
        });
    }

    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        super.lookupOperatorOverloads(opName, category, syntax, operatorList, SqlNameMatchers.withCaseSensitive(false));
    }

    static {
        ROWTIME_TYPE_INFERENCE = FlinkSqlOperatorTable.createTimeIndicatorReturnType(true);
        PROCTIME_TYPE_INFERENCE = FlinkSqlOperatorTable.createTimeIndicatorReturnType(false);
        PROCTIME = new CalciteSqlFunction("PROCTIME", SqlKind.OTHER_FUNCTION, PROCTIME_TYPE_INFERENCE, null, OperandTypes.NILADIC, SqlFunctionCategory.TIMEDATE, false);
        MATCH_ROWTIME = new CalciteSqlFunction("MATCH_ROWTIME", SqlKind.OTHER_FUNCTION, ROWTIME_TYPE_INFERENCE, null, OperandTypes.NILADIC, SqlFunctionCategory.MATCH_RECOGNIZE, true);
        MATCH_PROCTIME = new CalciteSqlFunction("MATCH_PROCTIME", SqlKind.OTHER_FUNCTION, PROCTIME_TYPE_INFERENCE, null, OperandTypes.NILADIC, SqlFunctionCategory.MATCH_RECOGNIZE, false);
        PROCTIME_MATERIALIZE = new ProctimeMaterializeSqlFunction();
        STREAMRECORD_TIMESTAMP = new StreamRecordTimestampSqlFunction();
        E = new SqlFunction("E", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE, null, OperandTypes.NILADIC, SqlFunctionCategory.NUMERIC);
        PI_FUNCTION = new SqlFunction("PI", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE, null, OperandTypes.NILADIC, SqlFunctionCategory.NUMERIC);
        CONCAT_FUNCTION = new SqlFunction("CONCAT", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.STRING), SqlFunctionCategory.STRING);
        CONCAT_WS = new SqlFunction("CONCAT_WS", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.repeat(SqlOperandCountRanges.from(1), OperandTypes.STRING), SqlFunctionCategory.STRING);
        LOG = new SqlFunction("LOG", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.or(OperandTypes.NUMERIC, OperandTypes.family(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC)), SqlFunctionCategory.NUMERIC);
        LOG2 = new SqlFunction("LOG2", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
        ROUND = new SqlFunction("ROUND", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.ROUND_FUNCTION_NULLABLE, null, OperandTypes.or(OperandTypes.NUMERIC_INTEGER, OperandTypes.NUMERIC), SqlFunctionCategory.NUMERIC);
        BIN = new SqlFunction("BIN", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), InferTypes.RETURN_TYPE, OperandTypes.family(SqlTypeFamily.INTEGER), SqlFunctionCategory.NUMERIC);
        SINH = new SqlFunction("SINH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
        HEX = new SqlFunction("HEX", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), InferTypes.RETURN_TYPE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING)), SqlFunctionCategory.NUMERIC);
        STR_TO_MAP = new SqlFunction("STR_TO_MAP", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.STR_MAP_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.STRING);
        IS_DECIMAL = new SqlFunction("IS_DECIMAL", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.NUMERIC), SqlFunctionCategory.NUMERIC);
        IS_DIGIT = new SqlFunction("IS_DIGIT", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.NUMERIC), SqlFunctionCategory.NUMERIC);
        IS_ALPHA = new SqlFunction("IS_ALPHA", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN, null, OperandTypes.or(OperandTypes.CHARACTER, OperandTypes.NUMERIC), SqlFunctionCategory.NUMERIC);
        COSH = new SqlFunction("COSH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
        TANH = new SqlFunction("TANH", SqlKind.OTHER_FUNCTION, ReturnTypes.DOUBLE_NULLABLE, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
        CHR = new SqlFunction("CHR", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.INTEGER), SqlFunctionCategory.STRING);
        LPAD = new SqlFunction("LPAD", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        RPAD = new SqlFunction("RPAD", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        REPEAT = new SqlFunction("REPEAT", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), SqlFunctionCategory.STRING);
        REVERSE = new SqlFunction("REVERSE", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        REPLACE = new SqlFunction("REPLACE", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SPLIT_INDEX = new SqlFunction("SPLIT_INDEX", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER)), SqlFunctionCategory.STRING);
        REGEXP_REPLACE = new SqlFunction("REGEXP_REPLACE", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        REGEXP_EXTRACT = new SqlFunction("REGEXP_EXTRACT", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.or(OperandTypes.STRING_STRING_INTEGER, OperandTypes.STRING_STRING), SqlFunctionCategory.STRING);
        HASH_CODE = new SqlFunction("HASH_CODE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.BOOLEAN), OperandTypes.family(SqlTypeFamily.NUMERIC), OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.TIMESTAMP), OperandTypes.family(SqlTypeFamily.TIME), OperandTypes.family(SqlTypeFamily.DATE)), SqlFunctionCategory.STRING);
        MD5 = new SqlFunction("MD5", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA1 = new SqlFunction("SHA1", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA224 = new SqlFunction("SHA224", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA256 = new SqlFunction("SHA256", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA384 = new SqlFunction("SHA384", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA512 = new SqlFunction("SHA512", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        SHA2 = new SqlFunction("SHA2", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.sequence("'SHA2(DATA, HASH_LENGTH)'", OperandTypes.STRING, OperandTypes.NUMERIC_INTEGER), SqlFunctionCategory.STRING);
        DATE_FORMAT = new SqlFunction("DATE_FORMAT", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.FORCE_NULLABLE), InferTypes.RETURN_TYPE, OperandTypes.or(OperandTypes.family(SqlTypeFamily.TIMESTAMP, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.TIMEDATE);
        REGEXP = new SqlFunction("REGEXP", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        PARSE_URL = new SqlFunction("PARSE_URL", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.STRING);
        PRINT = new SqlFunction("PRINT", SqlKind.OTHER_FUNCTION, ReturnTypes.ARG1_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.ANY), SqlFunctionCategory.STRING);
        NOW = new SqlFunction("NOW", SqlKind.OTHER_FUNCTION, ReturnTypes.explicit(SqlTypeName.TIMESTAMP, 0), null, OperandTypes.NILADIC, SqlFunctionCategory.TIMEDATE){

            @Override
            public boolean isDeterministic() {
                return false;
            }

            @Override
            public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
                return SqlMonotonicity.INCREASING;
            }
        };
        UNIX_TIMESTAMP = new SqlFunction("UNIX_TIMESTAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT_NULLABLE, null, OperandTypes.or(OperandTypes.NILADIC, OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.TIMEDATE){

            @Override
            public boolean isDeterministic() {
                return false;
            }

            @Override
            public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
                return SqlMonotonicity.INCREASING;
            }
        };
        FROM_UNIXTIME = new SqlFunction("FROM_UNIXTIME", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.INTEGER, SqlTypeFamily.STRING)), SqlFunctionCategory.TIMEDATE);
        IF = new SqlFunction("IF", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.NUMERIC_FROM_ARG1_DEFAULT1_NULLABLE, null, OperandTypes.or(OperandTypes.and(new NumericExceptFirstOperandChecker(3), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC)), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.STRING, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN, SqlTypeFamily.BOOLEAN), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.BINARY, SqlTypeFamily.BINARY), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.DATE, SqlTypeFamily.DATE), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.TIMESTAMP, SqlTypeFamily.TIMESTAMP), OperandTypes.family(SqlTypeFamily.BOOLEAN, SqlTypeFamily.TIME, SqlTypeFamily.TIME)), SqlFunctionCategory.NUMERIC);
        TO_BASE64 = new SqlFunction("TO_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        FROM_BASE64 = new SqlFunction("FROM_BASE64", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.TO_NULLABLE), null, OperandTypes.family(SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        UUID = new SqlFunction("UUID", SqlKind.OTHER_FUNCTION, ReturnTypes.VARCHAR_2000, null, OperandTypes.NILADIC, SqlFunctionCategory.STRING){

            @Override
            public boolean isDeterministic() {
                return false;
            }

            @Override
            public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
                return SqlMonotonicity.INCREASING;
            }
        };
        SUBSTRING = new SqlFunction("SUBSTRING", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.ARG0_VARCHAR_FORCE_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER)), SqlFunctionCategory.STRING);
        SUBSTR = new SqlFunction("SUBSTR", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.ARG0_VARCHAR_FORCE_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER)), SqlFunctionCategory.STRING);
        LEFT = new SqlFunction("LEFT", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.ARG0_VARCHAR_FORCE_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), SqlFunctionCategory.STRING);
        RIGHT = new SqlFunction("RIGHT", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.ARG0_VARCHAR_FORCE_NULLABLE, null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), SqlFunctionCategory.STRING);
        TO_TIMESTAMP = new SqlFunction("TO_TIMESTAMP", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.TIMESTAMP, 3), SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.CHARACTER), OperandTypes.family(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER)), SqlFunctionCategory.TIMEDATE);
        TO_DATE = new SqlFunction("TO_DATE", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.DATE), SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.TIMEDATE);
        CONVERT_TZ = new SqlFunction("CONVERT_TZ", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.VARCHAR), SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.STRING), SqlFunctionCategory.TIMEDATE);
        LOCATE = new SqlFunction("LOCATE", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER)), SqlFunctionCategory.NUMERIC);
        ASCII = new SqlFunction("ASCII", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.family(SqlTypeFamily.CHARACTER), SqlFunctionCategory.NUMERIC);
        ENCODE = new SqlFunction("ENCODE", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.explicit(SqlTypeName.BINARY), SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        DECODE = new SqlFunction("DECODE", SqlKind.OTHER_FUNCTION, FlinkReturnTypes.VARCHAR_2000_NULLABLE, null, OperandTypes.family(SqlTypeFamily.BINARY, SqlTypeFamily.STRING), SqlFunctionCategory.STRING);
        INSTR = new SqlFunction("INSTR", SqlKind.OTHER_FUNCTION, ReturnTypes.INTEGER_NULLABLE, null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING, SqlTypeFamily.INTEGER, SqlTypeFamily.INTEGER)), SqlFunctionCategory.NUMERIC);
        LTRIM = new SqlFunction("LTRIM", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.STRING);
        RTRIM = new SqlFunction("RTRIM", SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(ReturnTypes.ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING), null, OperandTypes.or(OperandTypes.family(SqlTypeFamily.STRING), OperandTypes.family(SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.STRING);
        AUXILIARY_GROUP = new SqlAuxiliaryGroupAggFunction();
        FIRST_VALUE = new SqlFirstLastValueAggFunction(SqlKind.FIRST_VALUE);
        LAST_VALUE = new SqlFirstLastValueAggFunction(SqlKind.LAST_VALUE);
        LISTAGG = new SqlListAggFunction();
        TUMBLE = new SqlGroupedWindowFunction("$TUMBLE", SqlKind.TUMBLE, null, OperandTypes.or(OperandTypes.DATETIME_INTERVAL, OperandTypes.DATETIME_INTERVAL_TIME)){

            @Override
            public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
                return Arrays.asList(TUMBLE_START, TUMBLE_END, TUMBLE_ROWTIME, TUMBLE_PROCTIME);
            }
        };
        TUMBLE_START = TUMBLE.auxiliary(SqlKind.TUMBLE_START);
        TUMBLE_END = TUMBLE.auxiliary(SqlKind.TUMBLE_END);
        TUMBLE_ROWTIME = TUMBLE.auxiliary("TUMBLE_ROWTIME", SqlKind.OTHER_FUNCTION);
        TUMBLE_PROCTIME = TUMBLE.auxiliary("TUMBLE_PROCTIME", SqlKind.OTHER_FUNCTION);
        HOP = new SqlGroupedWindowFunction(SqlKind.HOP, null, OperandTypes.or(OperandTypes.DATETIME_INTERVAL_INTERVAL, OperandTypes.DATETIME_INTERVAL_INTERVAL_TIME)){

            @Override
            public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
                return Arrays.asList(HOP_START, HOP_END, HOP_ROWTIME, HOP_PROCTIME);
            }
        };
        HOP_START = HOP.auxiliary(SqlKind.HOP_START);
        HOP_END = HOP.auxiliary(SqlKind.HOP_END);
        HOP_ROWTIME = HOP.auxiliary("HOP_ROWTIME", SqlKind.OTHER_FUNCTION);
        HOP_PROCTIME = HOP.auxiliary("HOP_PROCTIME", SqlKind.OTHER_FUNCTION);
        SESSION = new SqlGroupedWindowFunction(SqlKind.SESSION, null, OperandTypes.or(OperandTypes.DATETIME_INTERVAL, OperandTypes.DATETIME_INTERVAL_TIME)){

            @Override
            public List<SqlGroupedWindowFunction> getAuxiliaryFunctions() {
                return Arrays.asList(SESSION_START, SESSION_END, SESSION_ROWTIME, SESSION_PROCTIME);
            }
        };
        SESSION_START = SESSION.auxiliary(SqlKind.SESSION_START);
        SESSION_END = SESSION.auxiliary(SqlKind.SESSION_END);
        SESSION_ROWTIME = SESSION.auxiliary("SESSION_ROWTIME", SqlKind.OTHER_FUNCTION);
        SESSION_PROCTIME = SESSION.auxiliary("SESSION_PROCTIME", SqlKind.OTHER_FUNCTION);
        UNION = SqlStdOperatorTable.UNION;
        UNION_ALL = SqlStdOperatorTable.UNION_ALL;
        EXCEPT = SqlStdOperatorTable.EXCEPT;
        EXCEPT_ALL = SqlStdOperatorTable.EXCEPT_ALL;
        INTERSECT = SqlStdOperatorTable.INTERSECT;
        INTERSECT_ALL = SqlStdOperatorTable.INTERSECT_ALL;
        AND = SqlStdOperatorTable.AND;
        AS = SqlStdOperatorTable.AS;
        CONCAT = SqlStdOperatorTable.CONCAT;
        DIVIDE = SqlStdOperatorTable.DIVIDE;
        DIVIDE_INTEGER = SqlStdOperatorTable.DIVIDE_INTEGER;
        DOT = SqlStdOperatorTable.DOT;
        EQUALS = SqlStdOperatorTable.EQUALS;
        GREATER_THAN = SqlStdOperatorTable.GREATER_THAN;
        IS_DISTINCT_FROM = SqlStdOperatorTable.IS_DISTINCT_FROM;
        IS_NOT_DISTINCT_FROM = SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
        GREATER_THAN_OR_EQUAL = SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
        LESS_THAN = SqlStdOperatorTable.LESS_THAN;
        LESS_THAN_OR_EQUAL = SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
        MINUS = SqlStdOperatorTable.MINUS;
        MINUS_DATE = SqlStdOperatorTable.MINUS_DATE;
        MULTIPLY = SqlStdOperatorTable.MULTIPLY;
        NOT_EQUALS = SqlStdOperatorTable.NOT_EQUALS;
        OR = SqlStdOperatorTable.OR;
        PLUS = SqlStdOperatorTable.PLUS;
        DATETIME_PLUS = SqlStdOperatorTable.DATETIME_PLUS;
        DESC = SqlStdOperatorTable.DESC;
        NULLS_FIRST = SqlStdOperatorTable.NULLS_FIRST;
        NULLS_LAST = SqlStdOperatorTable.NULLS_LAST;
        IS_NOT_NULL = SqlStdOperatorTable.IS_NOT_NULL;
        IS_NULL = SqlStdOperatorTable.IS_NULL;
        IS_NOT_TRUE = SqlStdOperatorTable.IS_NOT_TRUE;
        IS_TRUE = SqlStdOperatorTable.IS_TRUE;
        IS_NOT_FALSE = SqlStdOperatorTable.IS_NOT_FALSE;
        IS_FALSE = SqlStdOperatorTable.IS_FALSE;
        IS_NOT_UNKNOWN = SqlStdOperatorTable.IS_NOT_UNKNOWN;
        IS_UNKNOWN = SqlStdOperatorTable.IS_UNKNOWN;
        NOT = SqlStdOperatorTable.NOT;
        UNARY_MINUS = SqlStdOperatorTable.UNARY_MINUS;
        UNARY_PLUS = SqlStdOperatorTable.UNARY_PLUS;
        GROUP_ID = SqlStdOperatorTable.GROUP_ID;
        GROUPING = SqlStdOperatorTable.GROUPING;
        GROUPING_ID = SqlStdOperatorTable.GROUPING_ID;
        SUM = SqlStdOperatorTable.SUM;
        SUM0 = SqlStdOperatorTable.SUM0;
        COUNT = SqlStdOperatorTable.COUNT;
        COLLECT = SqlStdOperatorTable.COLLECT;
        MIN = SqlStdOperatorTable.MIN;
        MAX = SqlStdOperatorTable.MAX;
        AVG = SqlStdOperatorTable.AVG;
        STDDEV = SqlStdOperatorTable.STDDEV;
        STDDEV_POP = SqlStdOperatorTable.STDDEV_POP;
        STDDEV_SAMP = SqlStdOperatorTable.STDDEV_SAMP;
        VARIANCE = SqlStdOperatorTable.VARIANCE;
        VAR_POP = SqlStdOperatorTable.VAR_POP;
        VAR_SAMP = SqlStdOperatorTable.VAR_SAMP;
        SINGLE_VALUE = SqlStdOperatorTable.SINGLE_VALUE;
        ARRAY_VALUE_CONSTRUCTOR = SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR;
        ELEMENT = SqlStdOperatorTable.ELEMENT;
        MAP_VALUE_CONSTRUCTOR = SqlStdOperatorTable.MAP_VALUE_CONSTRUCTOR;
        ITEM = SqlStdOperatorTable.ITEM;
        CARDINALITY = SqlStdOperatorTable.CARDINALITY;
        MULTISET_VALUE = SqlStdOperatorTable.MULTISET_VALUE;
        ROW = SqlStdOperatorTable.ROW;
        OVERLAPS = SqlStdOperatorTable.OVERLAPS;
        LITERAL_CHAIN = SqlStdOperatorTable.LITERAL_CHAIN;
        BETWEEN = SqlStdOperatorTable.BETWEEN;
        SYMMETRIC_BETWEEN = SqlStdOperatorTable.SYMMETRIC_BETWEEN;
        NOT_BETWEEN = SqlStdOperatorTable.NOT_BETWEEN;
        SYMMETRIC_NOT_BETWEEN = SqlStdOperatorTable.SYMMETRIC_NOT_BETWEEN;
        NOT_LIKE = SqlStdOperatorTable.NOT_LIKE;
        LIKE = SqlStdOperatorTable.LIKE;
        NOT_SIMILAR_TO = SqlStdOperatorTable.NOT_SIMILAR_TO;
        SIMILAR_TO = SqlStdOperatorTable.SIMILAR_TO;
        CASE = SqlStdOperatorTable.CASE;
        REINTERPRET = SqlStdOperatorTable.REINTERPRET;
        EXTRACT = SqlStdOperatorTable.EXTRACT;
        IN = SqlStdOperatorTable.IN;
        NOT_IN = SqlStdOperatorTable.NOT_IN;
        OVERLAY = SqlStdOperatorTable.OVERLAY;
        TRIM = SqlStdOperatorTable.TRIM;
        POSITION = SqlStdOperatorTable.POSITION;
        CHAR_LENGTH = SqlStdOperatorTable.CHAR_LENGTH;
        CHARACTER_LENGTH = SqlStdOperatorTable.CHARACTER_LENGTH;
        UPPER = SqlStdOperatorTable.UPPER;
        LOWER = SqlStdOperatorTable.LOWER;
        INITCAP = SqlStdOperatorTable.INITCAP;
        POWER = SqlStdOperatorTable.POWER;
        SQRT = SqlStdOperatorTable.SQRT;
        MOD = SqlStdOperatorTable.MOD;
        LN = SqlStdOperatorTable.LN;
        LOG10 = SqlStdOperatorTable.LOG10;
        ABS = SqlStdOperatorTable.ABS;
        EXP = SqlStdOperatorTable.EXP;
        NULLIF = SqlStdOperatorTable.NULLIF;
        COALESCE = SqlStdOperatorTable.COALESCE;
        FLOOR = SqlStdOperatorTable.FLOOR;
        CEIL = SqlStdOperatorTable.CEIL;
        LOCALTIME = SqlStdOperatorTable.LOCALTIME;
        LOCALTIMESTAMP = SqlStdOperatorTable.LOCALTIMESTAMP;
        CURRENT_TIME = SqlStdOperatorTable.CURRENT_TIME;
        CURRENT_TIMESTAMP = SqlStdOperatorTable.CURRENT_TIMESTAMP;
        CURRENT_DATE = SqlStdOperatorTable.CURRENT_DATE;
        CAST = SqlStdOperatorTable.CAST;
        SCALAR_QUERY = SqlStdOperatorTable.SCALAR_QUERY;
        EXISTS = SqlStdOperatorTable.EXISTS;
        SIN = SqlStdOperatorTable.SIN;
        COS = SqlStdOperatorTable.COS;
        TAN = SqlStdOperatorTable.TAN;
        COT = SqlStdOperatorTable.COT;
        ASIN = SqlStdOperatorTable.ASIN;
        ACOS = SqlStdOperatorTable.ACOS;
        ATAN = SqlStdOperatorTable.ATAN;
        ATAN2 = SqlStdOperatorTable.ATAN2;
        DEGREES = SqlStdOperatorTable.DEGREES;
        RADIANS = SqlStdOperatorTable.RADIANS;
        SIGN = SqlStdOperatorTable.SIGN;
        PI = SqlStdOperatorTable.PI;
        RAND = SqlStdOperatorTable.RAND;
        RAND_INTEGER = SqlStdOperatorTable.RAND_INTEGER;
        TRUNCATE = SqlStdOperatorTable.TRUNCATE;
        YEAR = SqlStdOperatorTable.YEAR;
        QUARTER = SqlStdOperatorTable.QUARTER;
        MONTH = SqlStdOperatorTable.MONTH;
        WEEK = SqlStdOperatorTable.WEEK;
        HOUR = SqlStdOperatorTable.HOUR;
        MINUTE = SqlStdOperatorTable.MINUTE;
        SECOND = SqlStdOperatorTable.SECOND;
        DAYOFYEAR = SqlStdOperatorTable.DAYOFYEAR;
        DAYOFMONTH = SqlStdOperatorTable.DAYOFMONTH;
        DAYOFWEEK = SqlStdOperatorTable.DAYOFWEEK;
        TIMESTAMP_ADD = SqlStdOperatorTable.TIMESTAMP_ADD;
        TIMESTAMP_DIFF = SqlStdOperatorTable.TIMESTAMP_DIFF;
        FIRST = SqlStdOperatorTable.FIRST;
        LAST = SqlStdOperatorTable.LAST;
        PREV = SqlStdOperatorTable.PREV;
        NEXT = SqlStdOperatorTable.NEXT;
        CLASSIFIER = SqlStdOperatorTable.CLASSIFIER;
        FINAL = SqlStdOperatorTable.FINAL;
        RUNNING = SqlStdOperatorTable.RUNNING;
        RANK = SqlStdOperatorTable.RANK;
        DENSE_RANK = SqlStdOperatorTable.DENSE_RANK;
        ROW_NUMBER = SqlStdOperatorTable.ROW_NUMBER;
        LEAD = SqlStdOperatorTable.LEAD;
        LAG = SqlStdOperatorTable.LAG;
        IS_JSON_VALUE = SqlStdOperatorTable.IS_JSON_VALUE;
        IS_JSON_OBJECT = SqlStdOperatorTable.IS_JSON_OBJECT;
        IS_JSON_ARRAY = SqlStdOperatorTable.IS_JSON_ARRAY;
        IS_JSON_SCALAR = SqlStdOperatorTable.IS_JSON_SCALAR;
        IS_NOT_JSON_VALUE = SqlStdOperatorTable.IS_NOT_JSON_VALUE;
        IS_NOT_JSON_OBJECT = SqlStdOperatorTable.IS_NOT_JSON_OBJECT;
        IS_NOT_JSON_ARRAY = SqlStdOperatorTable.IS_NOT_JSON_ARRAY;
        IS_NOT_JSON_SCALAR = SqlStdOperatorTable.IS_NOT_JSON_SCALAR;
    }
}

