/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.table.api.TableException;

public final class ExecNode$ {
    public static final ExecNode$ MODULE$;

    static {
        new ExecNode$();
    }

    public <T> Transformation<T> setManagedMemoryWeight(Transformation<T> transformation, long memoryBytes) {
        if (transformation.getManagedMemoryWeight() != 1) {
            throw new TableException("Managed memory weight has been set, this should not happen.");
        }
        int memoryKibiBytes = memoryBytes == 0L ? 0 : Math.max(1, (int)(memoryBytes >> 10));
        transformation.setManagedMemoryWeight(memoryKibiBytes);
        return transformation;
    }

    public <T> long setManagedMemoryWeight$default$2() {
        return 0L;
    }

    public <T> OneInputTransformation<T, T> createOneInputTransformation(Transformation<T> input, String name, StreamOperatorFactory<T> operatorFactory, TypeInformation<T> outputType, int parallelism, long memoryBytes) {
        OneInputTransformation ret = new OneInputTransformation(input, name, operatorFactory, outputType, parallelism);
        this.setManagedMemoryWeight((Transformation<T>)ret, memoryBytes);
        return ret;
    }

    public <T> long createOneInputTransformation$default$6() {
        return 0L;
    }

    public <T> TwoInputTransformation<T, T, T> createTwoInputTransformation(Transformation<T> input1, Transformation<T> input2, String name, StreamOperatorFactory<T> operatorFactory, TypeInformation<T> outputType, int parallelism, long memoryBytes) {
        TwoInputTransformation ret = new TwoInputTransformation(input1, input2, name, operatorFactory, outputType, parallelism);
        this.setManagedMemoryWeight((Transformation<T>)ret, memoryBytes);
        return ret;
    }

    public <T> long createTwoInputTransformation$default$7() {
        return 0L;
    }

    private ExecNode$() {
        MODULE$ = this;
    }
}

