/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor;
import org.apache.flink.table.planner.plan.utils.RexNodeRewriter;

public class PushProjectIntoTableSourceScanRule
extends RelOptRule {
    public static final PushProjectIntoTableSourceScanRule INSTANCE = new PushProjectIntoTableSourceScanRule();

    public PushProjectIntoTableSourceScanRule() {
        super(PushProjectIntoTableSourceScanRule.operand(LogicalProject.class, PushProjectIntoTableSourceScanRule.operand(LogicalTableScan.class, PushProjectIntoTableSourceScanRule.none()), new RelOptRuleOperand[0]), "PushProjectIntoTableSourceScanRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        if (tableSourceTable == null || !(tableSourceTable.tableSource() instanceof SupportsProjectionPushDown)) {
            return false;
        }
        SupportsProjectionPushDown pushDownSource = (SupportsProjectionPushDown)tableSourceTable.tableSource();
        if (pushDownSource.supportsNestedProjection()) {
            throw new TableException("Nested projection push down is unsupported now. \nPlease disable nested projection (SupportsProjectionPushDown#supportsNestedProjection returns false), planner will push down the top-level columns.");
        }
        return true;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        int[] usedFields = RexNodeExtractor.extractRefInputFields(project.getProjects());
        if (scan.getRowType().getFieldCount() == usedFields.length) {
            return;
        }
        TableSourceTable oldTableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource newTableSource = oldTableSourceTable.tableSource().copy();
        int[][] projectedFields = new int[usedFields.length][];
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < usedFields.length; ++i) {
            int usedField = usedFields[i];
            projectedFields[i] = new int[]{usedField};
            fieldNames.add(scan.getRowType().getFieldNames().get(usedField));
        }
        ((SupportsProjectionPushDown)newTableSource).applyProjection((int[][])projectedFields);
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)oldTableSourceTable.getRelOptSchema().getTypeFactory();
        RelDataType newRowType = flinkTypeFactory.projectStructType(oldTableSourceTable.getRowType(), usedFields);
        TableSourceTable newTableSourceTable = oldTableSourceTable.copy(newTableSource, newRowType, new String[]{"project=[" + String.join((CharSequence)", ", fieldNames) + "]"});
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), scan.getHints(), newTableSourceTable);
        List<RexNode> newProjects = RexNodeRewriter.rewriteWithNewFieldInput(project.getProjects(), usedFields);
        Project newProject = project.copy(project.getTraitSet(), (RelNode)newScan, (List)newProjects, project.getRowType());
        if (ProjectRemoveRule.isTrivial(newProject)) {
            call.transformTo(newScan);
        } else {
            call.transformTo(newProject);
        }
    }
}

