/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.util.UUID;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.SelectTableSink;
import org.apache.flink.table.planner.sinks.SelectTableSinkSchemaConverter;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class SelectTableSinkBase
implements SelectTableSink {
    private final TableSchema tableSchema;
    private final CollectSinkOperatorFactory<Row> factory;
    private final CollectResultIterator<Row> iterator;

    public SelectTableSinkBase(TableSchema tableSchema) {
        this.tableSchema = SelectTableSinkSchemaConverter.convertTimeAttributeToRegularTimestamp(SelectTableSinkSchemaConverter.changeDefaultConversionClass(tableSchema));
        TypeSerializer typeSerializer = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)this.tableSchema.toRowDataType()).createSerializer(new ExecutionConfig());
        String accumulatorName = "tableResultCollect_" + UUID.randomUUID();
        this.factory = new CollectSinkOperatorFactory(typeSerializer, accumulatorName);
        CollectSinkOperator operator = (CollectSinkOperator)this.factory.getOperator();
        this.iterator = new CollectResultIterator(operator.getOperatorIdFuture(), typeSerializer, accumulatorName);
    }

    public DataType getConsumedDataType() {
        return this.tableSchema.toRowDataType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    protected DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        CollectStreamSink sink = new CollectStreamSink(dataStream, this.factory);
        dataStream.getExecutionEnvironment().addOperator((Transformation)sink.getTransformation());
        return sink.name("Select table sink");
    }

    public void setJobClient(JobClient jobClient) {
        this.iterator.setJobClient(jobClient);
    }

    public CloseableIterator<Row> getResultIterator() {
        return this.iterator;
    }
}

