/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.sinks;

import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsOverwrite;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.runtime.types.TypeInfoDataTypeConverter;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeTransformation;
import org.apache.flink.table.types.inference.TypeTransformations;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeCasts;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.TypeMappingUtils;
import org.apache.flink.types.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class TableSinkUtils$ {
    public static final TableSinkUtils$ MODULE$;

    static {
        new TableSinkUtils$();
    }

    public RelNode validateSchemaAndApplyImplicitCast(RelNode query, TableSchema sinkSchema, FlinkTypeFactory typeFactory, Option<String> sinkIdentifier) {
        RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(query.getRowType());
        DataType sinkDataType = sinkSchema.toRowDataType();
        RowType sinkLogicalType = (RowType)DataTypeUtils.transform((DataType)sinkDataType, (TypeTransformation[])new TypeTransformation[]{TypeTransformations.legacyDecimalToDefaultDecimal(), TypeTransformations.legacyRawToTypeInfoRaw(), TypeTransformations.toNullable()}).getLogicalType();
        if (LogicalTypeCasts.supportsImplicitCast((LogicalType)queryLogicalType, (LogicalType)sinkLogicalType)) {
            RelNode relNode;
            if (LogicalTypeCasts.supportsAvoidingCast((LogicalType)queryLogicalType, (LogicalType)sinkLogicalType)) {
                relNode = query;
            } else {
                RelDataType castedDataType = typeFactory.buildRelNodeRowType((Seq<String>)JavaConversions$.MODULE$.asScalaBuffer(sinkLogicalType.getFieldNames()), (Seq<LogicalType>)((Seq)JavaConversions$.MODULE$.asScalaBuffer(sinkLogicalType.getFields()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final LogicalType apply(RowType.RowField x$1) {
                        return x$1.getType();
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                relNode = RelOptUtil.createCastRel(query, castedDataType, true);
            }
            return relNode;
        }
        String srcSchema = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(queryLogicalType.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RowType.RowField f) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getName(), f.getType().asSerializableString()}));
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        String sinkSchema2 = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(sinkLogicalType.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(RowType.RowField f) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.getName(), f.getType().asSerializableString()}));
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        String sinkDesc = (String)sinkIdentifier.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Field types of query result and registered TableSink ", " do not match.\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkDesc}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query schema: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{srcSchema}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkSchema2}))).toString());
    }

    public Option<String> validateSchemaAndApplyImplicitCast$default$4() {
        return None$.MODULE$;
    }

    public void validateTableSink(CatalogSinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, TableSink<?> sink, Seq<String> partitionKeys) {
        TableSink<?> tableSink;
        Map staticPartitions;
        if (partitionKeys.nonEmpty()) {
            TableSink<?> tableSink2 = sink;
            if (tableSink2 instanceof PartitionableTableSink) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new ValidationException(new StringBuilder().append((Object)"We need PartitionableTableSink to write data to").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" partitioned table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkIdentifier}))).toString());
            }
        }
        if ((staticPartitions = sinkOperation.getStaticPartitions()) != null && !staticPartitions.isEmpty()) {
            ((IterableLike)JavaConversions$.MODULE$.mapAsScalaMap(staticPartitions).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(scala.Tuple2<String, String> x$2) {
                    return (String)x$2._1();
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(sinkIdentifier, partitionKeys){
                public static final long serialVersionUID = 0L;
                private final ObjectIdentifier sinkIdentifier$2;
                private final Seq partitionKeys$2;

                public final void apply(String p) {
                    if (this.partitionKeys$2.contains((Object)p)) {
                        return;
                    }
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Static partition column ", " should be in the partition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" fields list ", " for Table(", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionKeys$2, this.sinkIdentifier$2}))).toString());
                }
                {
                    this.sinkIdentifier$2 = sinkIdentifier$2;
                    this.partitionKeys$2 = partitionKeys$2;
                }
            });
        }
        if ((tableSink = sink) instanceof OverwritableTableSink) {
            OverwritableTableSink overwritableTableSink = (OverwritableTableSink)tableSink;
            overwritableTableSink.setOverwrite(sinkOperation.isOverwrite());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Predef$.MODULE$.assert(!sinkOperation.isOverwrite(), (Function0)new Serializable(sink){
                public static final long serialVersionUID = 0L;
                private final TableSink sink$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"INSERT OVERWRITE requires ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " but actually got "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OverwritableTableSink.class.getSimpleName()}))).append((Object)this.sink$1.getClass().getName()).toString();
                }
                {
                    this.sink$1 = sink$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void validateTableSink(CatalogSinkModifyOperation sinkOperation, ObjectIdentifier sinkIdentifier, DynamicTableSink sink, Seq<String> partitionKeys) {
        DynamicTableSink dynamicTableSink;
        Map staticPartitions;
        if (partitionKeys.nonEmpty()) {
            DynamicTableSink dynamicTableSink2 = sink;
            if (dynamicTableSink2 instanceof SupportsPartitioning) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is a partitioned table, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sinkIdentifier.asSummaryString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but the underlying [", "] DynamicTableSink "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink.asSummaryString()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"doesn't implement SupportsPartitioning interface."})).s((Seq)Nil$.MODULE$)).toString());
            }
        }
        if ((staticPartitions = sinkOperation.getStaticPartitions()) != null && !staticPartitions.isEmpty()) {
            ((IterableLike)JavaConversions$.MODULE$.mapAsScalaMap(staticPartitions).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(scala.Tuple2<String, String> x$3) {
                    return (String)x$3._1();
                }
            }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(sinkIdentifier, partitionKeys){
                public static final long serialVersionUID = 0L;
                private final ObjectIdentifier sinkIdentifier$1;
                private final Seq partitionKeys$1;

                public final void apply(String p) {
                    if (this.partitionKeys$1.contains((Object)p)) {
                        return;
                    }
                    throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Static partition column ", " should be in the partition"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" fields list ", " for table '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionKeys$1, this.sinkIdentifier$1}))).toString());
                }
                {
                    this.sinkIdentifier$1 = sinkIdentifier$1;
                    this.partitionKeys$1 = partitionKeys$1;
                }
            });
        }
        if ((dynamicTableSink = sink) instanceof SupportsOverwrite) {
            DynamicTableSink dynamicTableSink3 = dynamicTableSink;
            ((SupportsOverwrite)dynamicTableSink3).applyOverwrite(sinkOperation.isOverwrite());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (sinkOperation.isOverwrite()) {
                throw new ValidationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"INSERT OVERWRITE requires ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sink.asSummaryString()}))).append((Object)"DynamicTableSink to implement SupportsOverwrite interface.").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public TableSchema inferSinkPhysicalSchema(RowType queryLogicalType, TableSink<?> sink) {
        TableSink<?> tableSink;
        block5: {
            boolean bl;
            block3: {
                block4: {
                    block2: {
                        tableSink = sink;
                        boolean bl2 = tableSink instanceof RetractStreamTableSink ? true : tableSink instanceof UpsertStreamTableSink;
                        if (!bl2) break block2;
                        bl = true;
                        break block3;
                    }
                    if (!(tableSink instanceof StreamTableSink)) break block4;
                    bl = false;
                    break block3;
                }
                if (!(tableSink instanceof DataStreamTableSink)) break block5;
                DataStreamTableSink dataStreamTableSink = (DataStreamTableSink)tableSink;
                bl = dataStreamTableSink.withChangeFlag();
            }
            boolean withChangeFlag = bl;
            return this.inferSinkPhysicalSchema(sink.getConsumedDataType(), queryLogicalType, withChangeFlag);
        }
        throw new MatchError(tableSink);
    }

    public TableSchema inferSinkPhysicalSchema(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        TableSchema tableSchema;
        DataType requestedOutputType = this.inferSinkPhysicalDataType(consumedDataType, queryLogicalType, withChangeFlag);
        if (LogicalTypeChecks.isCompositeType((LogicalType)requestedOutputType.getLogicalType())) {
            TableSchema tableSchema2;
            TypeInformation typeInformation = TypeInfoDataTypeConverter.fromDataTypeToTypeInfo((DataType)requestedOutputType);
            if (typeInformation instanceof PojoTypeInfo) {
                PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                tableSchema2 = this.org$apache$flink$table$planner$sinks$TableSinkUtils$$expandPojoTypeToSchema(pojoTypeInfo, queryLogicalType);
            } else {
                tableSchema2 = DataTypeUtils.expandCompositeTypeToSchema((DataType)requestedOutputType);
            }
            tableSchema = tableSchema2;
        } else {
            tableSchema = TableSchema.builder().field("f0", requestedOutputType).build();
        }
        return tableSchema;
    }

    public TableSchema org$apache$flink$table$planner$sinks$TableSinkUtils$$expandPojoTypeToSchema(PojoTypeInfo<?> pojo, RowType queryLogicalType) {
        List fieldNames = queryLogicalType.getFieldNames();
        Buffer reorderedFields = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(fieldNames).map((Function1)new Serializable(pojo, queryLogicalType){
            public static final long serialVersionUID = 0L;
            private final PojoTypeInfo pojo$1;
            private final RowType queryLogicalType$1;

            public final DataTypes.Field apply(String name) {
                DataType dataType2;
                int index = this.pojo$1.getFieldIndex(name);
                if (index < 0) {
                    throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, this.pojo$1.toString()})));
                }
                TypeInformation fieldTypeInfo = this.pojo$1.getPojoFieldAt(index).getTypeInformation();
                TypeInformation typeInformation = fieldTypeInfo;
                if (typeInformation instanceof PojoTypeInfo) {
                    PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
                    RowType nestedLogicalType = (RowType)((RowType.RowField)JavaConversions$.MODULE$.asScalaBuffer(this.queryLogicalType$1.getFields()).apply(index)).getType();
                    dataType2 = TableSinkUtils$.MODULE$.org$apache$flink$table$planner$sinks$TableSinkUtils$$expandPojoTypeToSchema(pojoTypeInfo, nestedLogicalType).toRowDataType();
                } else {
                    dataType2 = TypeConversions.fromLegacyInfoToDataType((TypeInformation)fieldTypeInfo);
                }
                DataType fieldDataType = dataType2;
                return DataTypes.FIELD((String)name, (DataType)fieldDataType);
            }
            {
                this.pojo$1 = pojo$1;
                this.queryLogicalType$1 = queryLogicalType$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        return DataTypeUtils.expandCompositeTypeToSchema((DataType)DataTypes.ROW((DataTypes.Field[])((DataTypes.Field[])reorderedFields.toArray(ClassTag$.MODULE$.apply(DataTypes.Field.class)))));
    }

    /*
     * Unable to fully structure code
     */
    public DataType inferSinkPhysicalDataType(DataType consumedDataType, RowType queryLogicalType, boolean withChangeFlag) {
        block11: {
            block10: {
                block9: {
                    var5_4 = consumedDataType.getLogicalType();
                    if (var5_4 instanceof LegacyTypeInformationType) {
                        var6_5 = (LegacyTypeInformationType)var5_4;
                        var7_6 = new Some((Object)var6_5.getTypeInformation());
                    } else {
                        var7_6 = None$.MODULE$;
                    }
                    consumedTypeInfo = var7_6;
                    if (consumedTypeInfo.isEmpty()) {
                        return consumedDataType;
                    }
                    if (!withChangeFlag) ** GOTO lbl35
                    var9_8 = (TypeInformation)consumedTypeInfo.get();
                    if (!(var9_8 instanceof TypeInformation) || !(var9_8 instanceof CaseClassTypeInfo)) break block9;
                    var10_9 = (CaseClassTypeInfo)var9_8;
                    v0 = var10_9.getTypeClass();
                    var11_10 = scala.Tuple2.class;
                    if (v0 != null ? v0.equals(var11_10) == false : var11_10 != null) break block9;
                    v1 = var10_9.getTypeAt(0);
                    var12_11 = Types.BOOLEAN();
                    if (v1 != null ? v1.equals(var12_11) == false : var12_11 != null) break block9;
                    var13_12 = var10_9.getTypeAt(1);
                    ** GOTO lbl32
                }
                if (!(var9_8 instanceof TypeInformation) || !(var9_8 instanceof TupleTypeInfo)) ** GOTO lbl-1000
                var14_13 = (TupleTypeInfo)var9_8;
                v2 = var14_13.getTypeClass();
                var15_14 = Tuple2.class;
                if (v2 != null ? v2.equals(var15_14) == false : var15_14 != null) ** GOTO lbl-1000
                v3 = var14_13.getTypeAt(0);
                var16_15 = Types.BOOLEAN();
                if (!(v3 != null ? v3.equals(var16_15) == false : var16_15 != null)) {
                    var13_12 = var14_13.getTypeAt(1);
lbl32:
                    // 2 sources

                    v4 = var13_12;
                } else lbl-1000:
                // 3 sources

                {
                    throw new TableException(new StringBuilder().append((Object)"Don't support ").append((Object)consumedDataType).append((Object)" conversion for the retract sink").toString());
lbl35:
                    // 1 sources

                    v4 = (TypeInformation)consumedTypeInfo.get();
                }
                requestedTypeInfo = v4;
                var17_17 = false;
                var18_18 = null;
                var19_19 = requestedTypeInfo;
                if (!(var19_19 instanceof GenericTypeInfo)) break block10;
                var17_17 = true;
                var18_18 = (GenericTypeInfo)var19_19;
                v5 = var18_18.getTypeClass();
                var20_20 = Row.class;
                if (v5 != null ? v5.equals(var20_20) == false : var20_20 != null) break block10;
                var21_21 = (DataType)TypeConversions.fromLogicalToDataType((LogicalType)queryLogicalType).bridgedTo(Row.class);
                break block11;
            }
            if (!var17_17) ** GOTO lbl-1000
            v6 = var18_18.getTypeClass();
            var22_22 = RowData.class;
            if (!(v6 != null ? v6.equals(var22_22) == false : var22_22 != null)) {
                var21_21 = (DataType)TypeConversions.fromLogicalToDataType((LogicalType)queryLogicalType).bridgedTo(RowData.class);
            } else if (var19_19 instanceof RowDataTypeInfo) {
                var23_23 = (RowDataTypeInfo)var19_19;
                fields = (DataTypes.Field[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])var23_23.getFieldNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])var23_23.getLogicalTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class)))).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataTypes.Field apply(scala.Tuple2<String, LogicalType> x0$1) {
                        scala.Tuple2<String, LogicalType> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String n = (String)tuple2._1();
                            LogicalType t = (LogicalType)tuple2._2();
                            DataTypes.Field field = DataTypes.FIELD((String)n, (DataType)TypeConversions.fromLogicalToDataType((LogicalType)t));
                            return field;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataTypes.Field.class)));
                var21_21 = (DataType)DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(RowData.class);
            } else {
                var21_21 = TypeConversions.fromLegacyInfoToDataType((TypeInformation)requestedTypeInfo);
            }
        }
        return var21_21;
    }

    public void validateLogicalPhysicalTypesCompatible(CatalogTable catalogTable, TableSink<?> sink, RowType queryLogicalType) {
        TableSchema logicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)catalogTable.getSchema());
        TableSchema physicalSchema = this.inferSinkPhysicalSchema(queryLogicalType, sink);
        if (logicalSchema.getFieldCount() != physicalSchema.getFieldCount()) {
            throw new ValidationException(new StringBuilder().append((Object)"The field count of logical schema of the table does not match with the field count of physical schema\n. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The logical schema: [", "]\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])logicalSchema.getFieldDataTypes()).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The physical schema: [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])physicalSchema.getFieldDataTypes()).mkString(",")}))).toString());
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logicalSchema.getFieldCount()).foreach$mVc$sp((Function1)new Serializable(logicalSchema, physicalSchema){
            public static final long serialVersionUID = 0L;
            private final TableSchema logicalSchema$1;
            private final TableSchema physicalSchema$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                DataType logicalFieldType = DataTypeUtils.transform((DataType)this.logicalSchema$1.getFieldDataTypes()[i], (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()});
                String logicalFieldName = this.logicalSchema$1.getFieldNames()[i];
                DataType physicalFieldType = DataTypeUtils.transform((DataType)this.physicalSchema$1.getFieldDataTypes()[i], (TypeTransformation[])new TypeTransformation[]{TypeTransformations.toNullable()});
                String physicalFieldName = this.physicalSchema$1.getFieldNames()[i];
                TypeMappingUtils.checkPhysicalLogicalTypeCompatible((LogicalType)physicalFieldType.getLogicalType(), (LogicalType)logicalFieldType.getLogicalType(), (String)physicalFieldName, (String)logicalFieldName, (boolean)false);
            }
            {
                this.logicalSchema$1 = logicalSchema$1;
                this.physicalSchema$1 = physicalSchema$1;
            }
        });
    }

    public int[] getNotNullFieldIndices(CatalogTable catalogTable) {
        RowType rowType = (RowType)catalogTable.getSchema().toPhysicalRowDataType().getLogicalType();
        LogicalType[] fieldTypes = (LogicalType[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(rowType.getFields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(RowType.RowField x$4) {
                return x$4.getType();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class));
        return (int[])((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])fieldTypes).indices().filter((Function1)new Serializable(fieldTypes){
            public static final long serialVersionUID = 0L;
            private final LogicalType[] fieldTypes$1;

            public final boolean apply(int index) {
                return this.apply$mcZI$sp(index);
            }

            public boolean apply$mcZI$sp(int index) {
                return !this.fieldTypes$1[index].isNullable();
            }
            {
                this.fieldTypes$1 = fieldTypes$1;
            }
        })).toArray(ClassTag$.MODULE$.Int());
    }

    private TableSinkUtils$() {
        MODULE$ = this;
    }
}

