/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecOverAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.spec.OverSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.PartitionSpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.CommonPythonUtil;
import org.apache.flink.table.planner.plan.utils.OverAggregateUtil;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecPythonOverAggregate
extends BatchExecOverAggregateBase {
    private static final String ARROW_PYTHON_OVER_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME = "org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.BatchArrowPythonOverWindowAggregateFunctionOperator";
    private final List<Long> lowerBoundary = new ArrayList<Long>();
    private final List<Long> upperBoundary = new ArrayList<Long>();
    private final List<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
    private final List<Integer> aggWindowIndex = new ArrayList<Integer>();

    public BatchExecPythonOverAggregate(OverSpec overSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(overSpec, inputProperty, outputType, description);
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        List<OverSpec.GroupSpec> groups = this.overSpec.getGroups();
        boolean[] isRangeWindows = new boolean[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            OverSpec.GroupSpec group = groups.get(i);
            List<AggregateCall> groupAggCalls = group.getAggCalls();
            this.aggCalls.addAll(groupAggCalls);
            for (int j = 0; j < groupAggCalls.size(); ++j) {
                this.aggWindowIndex.add(i);
            }
            BatchExecOverAggregateBase.OverWindowMode mode = this.inferGroupMode(group);
            if (mode == BatchExecOverAggregateBase.OverWindowMode.ROW) {
                isRangeWindows[i] = false;
                if (this.isUnboundedWindow(group)) {
                    this.lowerBoundary.add(Long.MIN_VALUE);
                    this.upperBoundary.add(Long.MAX_VALUE);
                    continue;
                }
                if (this.isUnboundedPrecedingWindow(group)) {
                    this.lowerBoundary.add(Long.MIN_VALUE);
                    this.upperBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getUpperBound()));
                    continue;
                }
                if (this.isUnboundedFollowingWindow(group)) {
                    this.lowerBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getLowerBound()));
                    this.upperBoundary.add(Long.MAX_VALUE);
                    continue;
                }
                if (this.isSlidingWindow(group)) {
                    this.lowerBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getLowerBound()));
                    this.upperBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getUpperBound()));
                    continue;
                }
                throw new TableException("Unsupported row window group spec " + group);
            }
            isRangeWindows[i] = true;
            if (this.isUnboundedWindow(group)) {
                this.lowerBoundary.add(Long.MIN_VALUE);
                this.upperBoundary.add(Long.MAX_VALUE);
                continue;
            }
            if (this.isUnboundedPrecedingWindow(group)) {
                this.lowerBoundary.add(Long.MIN_VALUE);
                this.upperBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getUpperBound()));
                continue;
            }
            if (this.isUnboundedFollowingWindow(group)) {
                this.lowerBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getLowerBound()));
                this.upperBoundary.add(Long.MAX_VALUE);
                continue;
            }
            if (this.isSlidingWindow(group)) {
                this.lowerBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getLowerBound()));
                this.upperBoundary.add(OverAggregateUtil.getLongBoundary(this.overSpec, group.getUpperBound()));
                continue;
            }
            throw new TableException("Unsupported range window group spec " + group);
        }
        Configuration config = CommonPythonUtil.getMergedConfig(planner.getExecEnv(), planner.getTableConfig());
        OneInputTransformation<RowData, RowData> transform = this.createPythonOneInputTransformation(inputTransform, inputType, InternalTypeInfo.of((LogicalType)this.getOutputType()).toRowType(), isRangeWindows, config);
        if (CommonPythonUtil.isPythonWorkerUsingManagedMemory(config)) {
            transform.declareManagedMemoryUseCaseAtSlotScope(ManagedMemoryUseCase.PYTHON);
        }
        return transform;
    }

    private OneInputTransformation<RowData, RowData> createPythonOneInputTransformation(Transformation<RowData> inputTransform, RowType inputRowType, RowType outputRowType, boolean[] isRangeWindows, Configuration config) {
        Tuple2<int[], PythonFunctionInfo[]> aggCallInfos = CommonPythonUtil.extractPythonAggregateFunctionInfosFromAggregateCall(this.aggCalls.toArray(new AggregateCall[0]));
        int[] pythonUdafInputOffsets = (int[])aggCallInfos.f0;
        PythonFunctionInfo[] pythonFunctionInfos = (PythonFunctionInfo[])aggCallInfos.f1;
        OneInputStreamOperator<RowData, RowData> pythonOperator = this.getPythonOverWindowAggregateFunctionOperator(config, inputRowType, outputRowType, isRangeWindows, pythonUdafInputOffsets, pythonFunctionInfos);
        return new OneInputTransformation(inputTransform, this.getDescription(), pythonOperator, (TypeInformation)InternalTypeInfo.of((RowType)outputRowType), inputTransform.getParallelism());
    }

    private OneInputStreamOperator<RowData, RowData> getPythonOverWindowAggregateFunctionOperator(Configuration config, RowType inputRowType, RowType outputRowType, boolean[] isRangeWindows, int[] udafInputOffsets, PythonFunctionInfo[] pythonFunctionInfos) {
        Class clazz = CommonPythonUtil.loadClass(ARROW_PYTHON_OVER_WINDOW_AGGREGATE_FUNCTION_OPERATOR_NAME);
        try {
            Constructor ctor = clazz.getConstructor(Configuration.class, PythonFunctionInfo[].class, RowType.class, RowType.class, long[].class, long[].class, boolean[].class, int[].class, int[].class, int[].class, int[].class, Integer.TYPE, Boolean.TYPE);
            PartitionSpec partitionSpec = this.overSpec.getPartition();
            List<OverSpec.GroupSpec> groups = this.overSpec.getGroups();
            SortSpec sortSpec = groups.get(groups.size() - 1).getSort();
            return (OneInputStreamOperator)ctor.newInstance(config, pythonFunctionInfos, inputRowType, outputRowType, this.lowerBoundary.stream().mapToLong(i -> i).toArray(), this.upperBoundary.stream().mapToLong(i -> i).toArray(), isRangeWindows, this.aggWindowIndex.stream().mapToInt(i -> i).toArray(), partitionSpec.getFieldIndices(), partitionSpec.getFieldIndices(), udafInputOffsets, sortSpec.getFieldIndices()[0], sortSpec.getAscendingOrders()[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TableException("Python BatchArrowPythonOverWindowAggregateFunctionOperator constructed failed.", (Throwable)e);
        }
    }
}

