/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class FirstValueAggFunction<T>
extends BuiltInAggregateFunction<T, RowData> {
    private transient DataType valueDataType;

    public FirstValueAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType((LogicalType)valueType);
    }

    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    public DataType getAccumulatorDataType() {
        return (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"firstValue", (DataType)((DataType)this.valueDataType.nullable())), DataTypes.FIELD((String)"firstOrder", (DataType)DataTypes.BIGINT())}).bridgedTo(RowData.class);
    }

    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    public boolean isDeterministic() {
        return false;
    }

    public RowData createAccumulator() {
        GenericRowData acc = new GenericRowData(2);
        acc.setField(0, null);
        acc.setField(1, (Object)Long.MAX_VALUE);
        return acc;
    }

    public void accumulate(RowData rowData, Object value2) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value2 != null && acc.getLong(1) == Long.MAX_VALUE) {
            acc.setField(0, value2);
            acc.setField(1, (Object)System.currentTimeMillis());
        }
    }

    public void accumulate(RowData rowData, Object value2, Long order) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value2 != null && acc.getLong(1) > order) {
            acc.setField(0, value2);
            acc.setField(1, (Object)order);
        }
    }

    public void accumulate(RowData rowData, StringData value2) {
        if (value2 != null) {
            this.accumulate(rowData, ((BinaryStringData)value2).copy());
        }
    }

    public void accumulate(RowData rowData, StringData value2, Long order) {
        if (value2 != null) {
            this.accumulate(rowData, ((BinaryStringData)value2).copy(), order);
        }
    }

    public void resetAccumulator(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        acc.setField(0, null);
        acc.setField(1, (Object)Long.MAX_VALUE);
    }

    public T getValue(RowData acc) {
        GenericRowData genericAcc = (GenericRowData)acc;
        return (T)genericAcc.getField(0);
    }
}

