/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.expressions.PlannerNamedWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerProctimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerRowtimeAttribute;
import org.apache.flink.table.planner.expressions.PlannerWindowEnd;
import org.apache.flink.table.planner.expressions.PlannerWindowProperty;
import org.apache.flink.table.planner.expressions.PlannerWindowStart;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.functions.sql.SqlWindowTableFunction;
import org.apache.flink.table.planner.plan.logical.CumulativeWindowSpec;
import org.apache.flink.table.planner.plan.logical.HoppingWindowSpec;
import org.apache.flink.table.planner.plan.logical.TimeAttributeWindowingStrategy;
import org.apache.flink.table.planner.plan.logical.TumblingWindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowSpec;
import org.apache.flink.table.planner.plan.logical.WindowingStrategy;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.trait.RelWindowProperties;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil$;
import org.apache.flink.table.planner.plan.utils.WindowEmitStrategy$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class WindowUtil$ {
    public static final WindowUtil$ MODULE$;

    static {
        new WindowUtil$();
    }

    public boolean groupingContainsWindowStartEnd(ImmutableBitSet grouping, RelWindowProperties windowProperties) {
        boolean bl;
        if (windowProperties == null) {
            bl = false;
        } else {
            ImmutableBitSet windowStarts = windowProperties.getWindowStartColumns();
            ImmutableBitSet windowEnds = windowProperties.getWindowEndColumns();
            boolean hasWindowStart = !windowStarts.intersect(grouping).isEmpty();
            boolean hasWindowEnd = !windowEnds.intersect(grouping).isEmpty();
            bl = hasWindowStart && hasWindowEnd;
        }
        return bl;
    }

    public boolean isWindowTableFunctionCall(RexNode node) {
        boolean bl;
        RexNode rexNode = node;
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = rexCall.getOperator() instanceof SqlWindowTableFunction;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean calcContainsCallsOnWindowColumns(Calc calc, FlinkRelMetadataQuery fmq) {
        RexNode predicate;
        RelNode calcInput = calc.getInput();
        ImmutableBitSet calcInputWindowColumns = fmq.getRelWindowProperties(calcInput).getWindowColumns();
        RexProgram calcProgram = calc.getProgram();
        RexLocalRef condition = calcProgram.getCondition();
        if (condition != null && FlinkRexUtil$.MODULE$.containsExpectedInputRef(predicate = calcProgram.expandLocalRef(condition), calcInputWindowColumns)) {
            return true;
        }
        boolean callsContainProps = ((IterableLike)JavaConversions$.MODULE$.asScalaBuffer(calcProgram.getProjectList()).map((Function1)new Serializable(calcProgram){
            public static final long serialVersionUID = 0L;
            private final RexProgram calcProgram$1;

            public final RexNode apply(RexLocalRef x$1) {
                return this.calcProgram$1.expandLocalRef(x$1);
            }
            {
                this.calcProgram$1 = calcProgram$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(calcInputWindowColumns){
            public static final long serialVersionUID = 0L;
            private final ImmutableBitSet calcInputWindowColumns$1;

            public final boolean apply(RexNode x0$1) {
                boolean bl;
                RexNode rexNode = x0$1;
                if (rexNode instanceof RexCall) {
                    RexCall rexCall = (RexCall)rexNode;
                    bl = FlinkRexUtil$.MODULE$.containsExpectedInputRef(rexCall, this.calcInputWindowColumns$1);
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.calcInputWindowColumns$1 = calcInputWindowColumns$1;
            }
        });
        return callsContainProps;
    }

    public Tuple4<RexProgram, int[], Object, Object> buildNewProgramWithoutWindowColumns(RexBuilder rexBuilder, RexProgram oldProgram, RelDataType inputRowType, int inputTimeAttributeIndex, int[] windowColumns) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        BooleanRef containsTimeAttribute = BooleanRef.create((boolean)false);
        IntRef newTimeAttributeIndex = IntRef.create((int)-1);
        ArrayBuffer calcFieldShifting = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        JavaConversions$.MODULE$.asScalaBuffer(oldProgram.getNamedProjects()).foreach((Function1)new Serializable(oldProgram, inputTimeAttributeIndex, windowColumns, programBuilder, containsTimeAttribute, newTimeAttributeIndex, calcFieldShifting){
            public static final long serialVersionUID = 0L;
            private final RexProgram oldProgram$1;
            private final int inputTimeAttributeIndex$1;
            private final int[] windowColumns$1;
            private final RexProgramBuilder programBuilder$1;
            private final BooleanRef containsTimeAttribute$1;
            private final IntRef newTimeAttributeIndex$1;
            private final ArrayBuffer calcFieldShifting$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Pair<RexLocalRef, String> namedProject) {
                RexInputRef rexInputRef;
                RexLocalRef rexLocalRef;
                RexNode expr = this.oldProgram$1.expandLocalRef((RexLocalRef)namedProject.left);
                String name = (String)namedProject.right;
                RexNode rexNode = expr;
                if (rexNode instanceof RexInputRef) {
                    RexInputRef rexInputRef2 = (RexInputRef)rexNode;
                    if (Predef$.MODULE$.intArrayOps(this.windowColumns$1).contains((Object)BoxesRunTime.boxToInteger((int)rexInputRef2.getIndex()))) {
                        return this.calcFieldShifting$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)-1));
                    }
                }
                try {
                    rexLocalRef = this.programBuilder$1.addProject(expr, name);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    rexLocalRef = BoxedUnit.UNIT;
                }
                int fieldIndex = this.programBuilder$1.getProjectList().size() - 1;
                this.calcFieldShifting$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)fieldIndex));
                RexNode rexNode2 = expr;
                if (rexNode2 instanceof RexInputRef && (rexInputRef = (RexInputRef)rexNode2).getIndex() == this.inputTimeAttributeIndex$1) {
                    this.containsTimeAttribute$1.elem = true;
                    this.newTimeAttributeIndex$1.elem = fieldIndex;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }
            {
                this.oldProgram$1 = oldProgram$1;
                this.inputTimeAttributeIndex$1 = inputTimeAttributeIndex$1;
                this.windowColumns$1 = windowColumns$1;
                this.programBuilder$1 = programBuilder$1;
                this.containsTimeAttribute$1 = containsTimeAttribute$1;
                this.newTimeAttributeIndex$1 = newTimeAttributeIndex$1;
                this.calcFieldShifting$1 = calcFieldShifting$1;
            }
        });
        if (!containsTimeAttribute.elem) {
            programBuilder.addProject(inputTimeAttributeIndex, inputRowType.getFieldNames().get(inputTimeAttributeIndex));
            newTimeAttributeIndex.elem = programBuilder.getProjectList().size() - 1;
        }
        if (oldProgram.getCondition() != null) {
            RexNode condition = oldProgram.expandLocalRef(oldProgram.getCondition());
            programBuilder.addCondition(condition);
        }
        RexProgram program = programBuilder.getProgram();
        return new Tuple4((Object)program, calcFieldShifting.toArray(ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToInteger((int)newTimeAttributeIndex.elem), (Object)BoxesRunTime.boxToBoolean((!containsTimeAttribute.elem ? 1 : 0) != 0));
    }

    /*
     * WARNING - void declaration
     */
    public TimeAttributeWindowingStrategy convertToWindowingStrategy(RexCall windowCall, RelDataType inputRowType) {
        block2: {
            void var4_4;
            block3: {
                block4: {
                    SqlWindowTableFunction sqlWindowTableFunction;
                    block8: {
                        WindowSpec windowSpec;
                        LogicalType timeAttributeType;
                        int timeIndex;
                        block6: {
                            block7: {
                                block5: {
                                    SqlWindowTableFunction windowFunction;
                                    if (!this.isWindowTableFunctionCall(windowCall)) break block2;
                                    timeIndex = this.getTimeAttributeIndex((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(1));
                                    RelDataType fieldType = inputRowType.getFieldList().get(timeIndex).getType();
                                    if (!FlinkTypeFactory$.MODULE$.isTimeIndicatorType(fieldType)) break block3;
                                    timeAttributeType = FlinkTypeFactory$.MODULE$.toLogicalType(fieldType);
                                    if (!LogicalTypeChecks.canBeTimeAttributeType((LogicalType)timeAttributeType)) break block4;
                                    sqlWindowTableFunction = windowFunction = (SqlWindowTableFunction)windowCall.getOperator();
                                    SqlFunction sqlFunction = FlinkSqlOperatorTable.TUMBLE;
                                    SqlWindowTableFunction sqlWindowTableFunction2 = sqlWindowTableFunction;
                                    if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlWindowTableFunction2) : sqlWindowTableFunction2 != null) break block5;
                                    Duration offset = windowCall.operands.size() == 4 ? Duration.ofMillis(this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(3))) : null;
                                    long interval = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(2));
                                    windowSpec = new TumblingWindowSpec(Duration.ofMillis(interval), offset);
                                    break block6;
                                }
                                SqlFunction sqlFunction = FlinkSqlOperatorTable.HOP;
                                SqlWindowTableFunction sqlWindowTableFunction3 = sqlWindowTableFunction;
                                if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlWindowTableFunction3) : sqlWindowTableFunction3 != null) break block7;
                                Duration offset = windowCall.operands.size() == 5 ? Duration.ofMillis(this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(4))) : null;
                                long slide = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(2));
                                long size = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(3));
                                windowSpec = new HoppingWindowSpec(Duration.ofMillis(size), Duration.ofMillis(slide), offset);
                                break block6;
                            }
                            SqlFunction sqlFunction = FlinkSqlOperatorTable.CUMULATE;
                            SqlWindowTableFunction sqlWindowTableFunction4 = sqlWindowTableFunction;
                            if (sqlFunction != null ? !((Object)sqlFunction).equals(sqlWindowTableFunction4) : sqlWindowTableFunction4 != null) break block8;
                            Duration offset = windowCall.operands.size() == 5 ? Duration.ofMillis(this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(4))) : null;
                            long step = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(2));
                            long maxSize = this.getOperandAsLong((RexNode)JavaConversions$.MODULE$.asScalaBuffer(windowCall.operands).apply(3));
                            windowSpec = new CumulativeWindowSpec(Duration.ofMillis(maxSize), Duration.ofMillis(step), offset);
                        }
                        TumblingWindowSpec windowSpec2 = windowSpec;
                        return new TimeAttributeWindowingStrategy((WindowSpec)windowSpec2, timeAttributeType, timeIndex);
                    }
                    throw new MatchError((Object)sqlWindowTableFunction);
                }
                throw new ValidationException(new StringBuilder().append((Object)"The supported time indicator type are TIMESTAMP and TIMESTAMP_LTZ, but is ").append((Object)FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)var4_4)).append((Object)"").toString());
            }
            throw new ValidationException(new StringBuilder().append((Object)"Window can only be defined on a time attribute column, but is type of ").append((Object)var4_4).toString());
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RexCall ", " is not a window table-valued "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{windowCall}))).append((Object)"function, can't convert it into WindowingStrategy").toString());
    }

    public void checkEmitConfiguration(TableConfig tableConfig) {
        Configuration conf = tableConfig.getConfiguration();
        if (conf.getBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED()) || conf.getBoolean(WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED())) {
            throw new TableException(new StringBuilder().append((Object)"Currently, window table function based aggregate doesn't ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"support early-fire and late-fire configuration "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_EARLY_FIRE_ENABLED().key()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{WindowEmitStrategy$.MODULE$.TABLE_EXEC_EMIT_LATE_FIRE_ENABLED().key()}))).toString());
        }
    }

    public RelDataType deriveWindowAggregateRowType(int[] grouping, Seq<AggregateCall> aggCalls, WindowingStrategy windowing, Seq<PlannerNamedWindowProperty> namedWindowProperties, RelDataType inputRowType, FlinkTypeFactory typeFactory) {
        ImmutableBitSet groupSet = ImmutableBitSet.of(grouping);
        RelDataType baseType = Aggregate.deriveRowType(typeFactory, inputRowType, false, groupSet, Collections.singletonList(groupSet), JavaConversions$.MODULE$.seqAsJavaList(aggCalls));
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        builder.addAll(baseType.getFieldList());
        namedWindowProperties.foreach((Function1)new Serializable(windowing, typeFactory, builder){
            public static final long serialVersionUID = 0L;
            private final WindowingStrategy windowing$1;
            private final FlinkTypeFactory typeFactory$1;
            private final RelDataTypeFactory.FieldInfoBuilder builder$1;

            public final RelDataTypeFactory.FieldInfoBuilder apply(PlannerNamedWindowProperty namedProp) {
                PlannerWindowProperty plannerWindowProperty;
                block4: {
                    TimestampType timestampType;
                    block3: {
                        block2: {
                            plannerWindowProperty = namedProp.getProperty();
                            boolean bl = plannerWindowProperty instanceof PlannerWindowStart ? true : plannerWindowProperty instanceof PlannerWindowEnd;
                            if (!bl) break block2;
                            timestampType = new TimestampType(false, 3);
                            break block3;
                        }
                        boolean bl = plannerWindowProperty instanceof PlannerRowtimeAttribute ? true : plannerWindowProperty instanceof PlannerProctimeAttribute;
                        if (!bl) break block4;
                        timestampType = this.windowing$1.getTimeAttributeType().copy(false);
                    }
                    TimestampType timeType = timestampType;
                    return this.builder$1.add(namedProp.getName(), this.typeFactory$1.createFieldTypeFromLogicalType((LogicalType)timeType));
                }
                throw new MatchError((Object)plannerWindowProperty);
            }
            {
                this.windowing$1 = windowing$1;
                this.typeFactory$1 = typeFactory$1;
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public RelDataType deriveLocalWindowAggregateRowType(AggregateInfoList aggInfoList, int[] grouping, String endPropertyName, RelDataType inputRowType, FlinkTypeFactory typeFactory) {
        DataType[] accTypes = aggInfoList.getAccTypes();
        LogicalType[] groupingTypes = (LogicalType[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(grouping).map((Function1)new Serializable(inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final RelDataType apply(int x$1) {
                return this.inputRowType$1.getFieldList().get(x$1).getType();
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(RelDataType relDataType) {
                return FlinkTypeFactory$.MODULE$.toLogicalType(relDataType);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        LogicalType[] sliceEndType = (LogicalType[])((Object[])new LogicalType[]{DataTypes.BIGINT().getLogicalType()});
        String[] groupingNames = (String[])Predef$.MODULE$.intArrayOps(grouping).map((Function1)new Serializable(inputRowType){
            public static final long serialVersionUID = 0L;
            private final RelDataType inputRowType$1;

            public final String apply(int x$2) {
                return this.inputRowType$1.getFieldNames().get(x$2);
            }
            {
                this.inputRowType$1 = inputRowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] accFieldNames = AggregateUtil$.MODULE$.inferAggAccumulatorNames(aggInfoList);
        String[] sliceEndName = (String[])((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"$", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{endPropertyName}))});
        return typeFactory.buildRelNodeRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupingNames).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])accFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])sliceEndName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), (Seq<LogicalType>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])groupingTypes).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])accTypes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LogicalType apply(DataType x$1) {
                return LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])sliceEndType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)))));
    }

    /*
     * Unable to fully structure code
     */
    private int getTimeAttributeIndex(RexNode operand) {
        var3_2 = operand;
        if (!(var3_2 instanceof RexCall)) ** GOTO lbl-1000
        var4_3 = (RexCall)var3_2;
        v0 = var4_3.getKind();
        var5_4 = SqlKind.DESCRIPTOR;
        if (!(v0 != null ? v0.equals((Object)var5_4) == false : var5_4 != null)) {
            var7_5 = (RexNode)JavaConversions$.MODULE$.asScalaBuffer(var4_3.operands).apply(0);
            if (var7_5 instanceof RexInputRef) {
                var8_6 = (RexInputRef)var7_5;
                var9_7 = var8_6.getIndex();
            } else {
                var9_7 = -1;
            }
            var6_8 = var9_7;
        } else lbl-1000:
        // 2 sources

        {
            var6_8 = -1;
        }
        timeAttributeIndex = var6_8;
        if (timeAttributeIndex == -1) {
            throw new TableException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to get time attribute index from ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operand}))).append((Object)"This is a bug, please file a JIRA issue.").toString());
        }
        return (int)var2_9;
    }

    private long getOperandAsLong(RexNode operand) {
        boolean bl = false;
        RexLiteral rexLiteral = null;
        RexNode rexNode = operand;
        if (rexNode instanceof RexLiteral) {
            bl = true;
            rexLiteral = (RexLiteral)rexNode;
            SqlTypeFamily sqlTypeFamily = rexLiteral.getTypeName().getFamily();
            SqlTypeFamily sqlTypeFamily2 = SqlTypeFamily.INTERVAL_DAY_TIME;
            if (!(sqlTypeFamily != null ? !sqlTypeFamily.equals(sqlTypeFamily2) : sqlTypeFamily2 != null)) {
                long l = ((BigDecimal)rexLiteral.getValue()).longValue();
                return l;
            }
        }
        if (bl) {
            throw new TableException("Window aggregate only support SECOND, MINUTE, HOUR, DAY as the time unit. MONTH and YEAR time unit are not supported yet.");
        }
        throw new TableException("Only constant window descriptors are supported.");
    }

    private WindowUtil$() {
        MODULE$ = this;
    }
}

