/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.List;
import org.apache.flink.table.api.CatalogAlreadyExistException;
import org.apache.flink.table.api.CatalogNotExistException;
import org.apache.flink.table.api.TableAlreadyExistException;
import org.apache.flink.table.api.TableNotExistException;
import org.apache.flink.table.catalog.CrudExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalog;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u0001\u0003\u00015\u0011q#\u00138NK6|'/_#yi\u0016\u0014h.\u00197DCR\fGn\\4\u000b\u0005\r!\u0011aB2bi\u0006dwn\u001a\u0006\u0003\u000b\u0019\tQ\u0001^1cY\u0016T!a\u0002\u0005\u0002\u000b\u0019d\u0017N\\6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005U1R\"\u0001\u0002\n\u0005]\u0011!aE\"sk\u0012,\u0005\u0010^3s]\u0006d7)\u0019;bY><\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\t9\fW.\u001a\t\u00037yq!a\u0004\u000f\n\u0005u\u0001\u0012A\u0002)sK\u0012,g-\u0003\u0002 A\t11\u000b\u001e:j]\u001eT!!\b\t\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!S\u0005\u0005\u0002\u0016\u0001!)\u0011$\ta\u00015!9q\u0005\u0001b\u0001\n\u0013A\u0013!\u00033bi\u0006\u0014\u0017m]3t+\u0005I\u0003\u0003\u0002\u001605Ej\u0011a\u000b\u0006\u0003Y5\nq!\\;uC\ndWM\u0003\u0002/!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005AZ#a\u0002%bg\"l\u0015\r\u001d\t\u0003+IJ!a\r\u0002\u0003\u001f\u0015CH/\u001a:oC2\u001c\u0015\r^1m_\u001eDa!\u000e\u0001!\u0002\u0013I\u0013A\u00033bi\u0006\u0014\u0017m]3tA!9q\u0007\u0001b\u0001\n\u0013A\u0014A\u0002;bE2,7/F\u0001:!\u0011QsF\u0007\u001e\u0011\u0005UY\u0014B\u0001\u001f\u0003\u0005Q)\u0005\u0010^3s]\u0006d7)\u0019;bY><G+\u00192mK\"1a\b\u0001Q\u0001\ne\nq\u0001^1cY\u0016\u001c\b\u0005C\u0003A\u0001\u0011\u0005\u0013)A\u0006de\u0016\fG/\u001a+bE2,G\u0003\u0002\"F\u000f\"\u0003\"aD\"\n\u0005\u0011\u0003\"\u0001B+oSRDQAR A\u0002i\t\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000b\u0015y\u0004\u0019\u0001\u001e\t\u000b%{\u0004\u0019\u0001&\u0002\u001d%<gn\u001c:f\u0013\u001a,\u00050[:ugB\u0011qbS\u0005\u0003\u0019B\u0011qAQ8pY\u0016\fg\u000eK\u0002@\u001d^\u00032aD(R\u0013\t\u0001\u0006C\u0001\u0004uQJ|wo\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u0012\t1!\u00199j\u0013\t16K\u0001\u000eUC\ndW-\u00117sK\u0006$\u00170\u0012=jgR,\u0005pY3qi&|g.\r\u0003\u001f5a\u000b\u0018'B\u0012Z;2tVC\u0001.\\+\u0005QB!\u0002/\r\u0005\u0004\t'!\u0001+\n\u0005y{\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002a!\u00051A\u000f\u001b:poN\f\"AY3\u0011\u0005=\u0019\u0017B\u00013\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AZ5\u000f\u0005=9\u0017B\u00015\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!A[6\u0003\u0013QC'o\\<bE2,'B\u00015\u0011c\u0015\u0019SN\\8a\u001d\tya.\u0003\u0002a!E\"!e\u0004\tq\u0005\u0015\u00198-\u00197bc\t1\u0013\u000bC\u0003t\u0001\u0011\u0005C/A\u0005ee>\u0004H+\u00192mKR\u0019!)\u001e<\t\u000b\u0019\u0013\b\u0019\u0001\u000e\t\u000b]\u0014\b\u0019\u0001&\u0002#%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8\u000fK\u0002ssv\u00042aD({!\t\u001160\u0003\u0002}'\n1B+\u00192mK:{G/\u0012=jgR,\u0005pY3qi&|g.M\u0003\u001f5y\f\u0019!M\u0003$3v{h,\r\u0004$[:\f\t\u0001Y\u0019\u0005E=\u0001\u0002/\r\u0002'u\"9\u0011q\u0001\u0001\u0005B\u0005%\u0011AC1mi\u0016\u0014H+\u00192mKR9!)a\u0003\u0002\u000e\u0005=\u0001B\u0002$\u0002\u0006\u0001\u0007!\u0004\u0003\u0004\u0006\u0003\u000b\u0001\rA\u000f\u0005\u0007o\u0006\u0015\u0001\u0019\u0001&)\u000b\u0005\u0015\u00110a\u00052\ryQ\u0012QCA\u000ec\u0019\u0019\u0013,XA\f=F21%\u001c8\u0002\u001a\u0001\fDAI\b\u0011aF\u0012aE\u001f\u0005\b\u0003?\u0001A\u0011IA\u0011\u0003A\u0019'/Z1uKN+(mQ1uC2|w\rF\u0004C\u0003G\t9#!\u000b\t\u000f\u0005\u0015\u0012Q\u0004a\u00015\u0005Y1-\u0019;bY><g*Y7f\u0011\u0019\u0019\u0011Q\u0004a\u0001c!1\u0011*!\bA\u0002)Cc!!\b\u0002.\u0005U\u0002\u0003B\bP\u0003_\u00012AUA\u0019\u0013\r\t\u0019d\u0015\u0002\u001d\u0007\u0006$\u0018\r\\8h\u00032\u0014X-\u00193z\u000bbL7\u000f^#yG\u0016\u0004H/[8oc\u0019q\"$a\u000e\u0002>E21%W/\u0002:y\u000bdaI7o\u0003w\u0001\u0017\u0007\u0002\u0012\u0010!A\f4AJA\u0018\u0011\u001d\t\t\u0005\u0001C!\u0003\u0007\na\u0002\u001a:paN+(mQ1uC2|w\rF\u0003C\u0003\u000b\n9\u0005C\u0004\u0002&\u0005}\u0002\u0019\u0001\u000e\t\r]\fy\u00041\u0001KQ\u0019\ty$a\u0013\u0002TA!qbTA'!\r\u0011\u0016qJ\u0005\u0004\u0003#\u001a&\u0001G\"bi\u0006dwn\u001a(pi\u0016C\u0018n\u001d;Fq\u000e,\u0007\u000f^5p]F2aDGA+\u00037\ndaI-^\u0003/r\u0016GB\u0012n]\u0006e\u0003-\r\u0003#\u001fA\u0001\u0018g\u0001\u0014\u0002N!9\u0011q\f\u0001\u0005B\u0005\u0005\u0014aD1mi\u0016\u00148+\u001e2DCR\fGn\\4\u0015\u000f\t\u000b\u0019'!\u001a\u0002h!9\u0011QEA/\u0001\u0004Q\u0002BB\u0002\u0002^\u0001\u0007\u0011\u0007\u0003\u0004x\u0003;\u0002\rA\u0013\u0005\b\u0003W\u0002A\u0011IA7\u0003!9W\r\u001e+bE2,Gc\u0001\u001e\u0002p!1a)!\u001bA\u0002iAq!a\u001d\u0001\t\u0003\n)(\u0001\u0006mSN$H+\u00192mKN$\"!a\u001e\u0011\u000b\u0005e\u00141\u0011\u000e\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA!\u001e;jY*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006m$\u0001\u0002'jgRDq!!#\u0001\t\u0003\nY)A\u0007hKR\u001cVOY\"bi\u0006dwn\u001a\u000b\u0004c\u00055\u0005bBA\u0013\u0003\u000f\u0003\rA\u0007\u0015\u0007\u0003\u000f\u000bY%!%2\ryQ\u00121SAMc\u0019\u0019\u0013,XAK=F21%\u001c8\u0002\u0018\u0002\fDAI\b\u0011aF\u001aa%!\u0014\t\u000f\u0005u\u0005\u0001\"\u0011\u0002v\u0005yA.[:u'V\u00147)\u0019;bY><7\u000f")
public class InMemoryExternalCatalog
implements CrudExternalCatalog {
    private final String name;
    private final HashMap<String, ExternalCatalog> databases;
    private final HashMap<String, ExternalCatalogTable> tables;

    private HashMap<String, ExternalCatalog> databases() {
        return this.databases;
    }

    private HashMap<String, ExternalCatalogTable> tables() {
        return this.tables;
    }

    @Override
    public void createTable(String tableName, ExternalCatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.tables().get((Object)tableName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new TableAlreadyExistException(this.name, tableName);
            }
            Option option2 = this.tables().put((Object)tableName, (Object)table);
            return;
        }
    }

    @Override
    public synchronized void dropTable(String tableName, boolean ignoreIfNotExists) throws TableNotExistException {
        if (this.tables().remove((Object)tableName).isEmpty() && !ignoreIfNotExists) {
            throw new TableNotExistException(this.name, tableName);
        }
    }

    @Override
    public void alterTable(String tableName, ExternalCatalogTable table, boolean ignoreIfNotExists) throws TableNotExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        if (!this.tables().contains((Object)tableName)) break block5;
                        boxedUnit = this.tables().put((Object)tableName, (Object)table);
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new TableNotExistException(this.name, tableName);
        }
    }

    @Override
    public void createSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfExists) throws CatalogAlreadyExistException {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            Option option = this.databases().get((Object)catalogName);
            if (option instanceof Some && !ignoreIfExists) {
                throw new CatalogAlreadyExistException(catalogName, null);
            }
            Option option2 = this.databases().put((Object)catalogName, (Object)catalog);
            return;
        }
    }

    @Override
    public synchronized void dropSubCatalog(String catalogName, boolean ignoreIfNotExists) throws CatalogNotExistException {
        if (this.databases().remove((Object)catalogName).isEmpty() && !ignoreIfNotExists) {
            throw new CatalogNotExistException(catalogName, null);
        }
    }

    @Override
    public void alterSubCatalog(String catalogName, ExternalCatalog catalog, boolean ignoreIfNotExists) {
        InMemoryExternalCatalog inMemoryExternalCatalog = this;
        synchronized (inMemoryExternalCatalog) {
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        if (!this.databases().contains((Object)catalogName)) break block5;
                        boxedUnit = this.databases().put((Object)catalogName, (Object)catalog);
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block7;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new CatalogNotExistException(catalogName);
        }
    }

    @Override
    public synchronized ExternalCatalogTable getTable(String tableName) {
        Option option = this.tables().get((Object)tableName);
        if (option instanceof Some) {
            ExternalCatalogTable t;
            Some some = (Some)option;
            ExternalCatalogTable externalCatalogTable = t = (ExternalCatalogTable)((Object)some.x());
            return externalCatalogTable;
        }
        throw new TableNotExistException(this.name, tableName, null);
    }

    @Override
    public synchronized List<String> listTables() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.tables().keys().toList()).asJava();
    }

    @Override
    public synchronized ExternalCatalog getSubCatalog(String catalogName) throws CatalogNotExistException {
        Option option = this.databases().get((Object)catalogName);
        if (option instanceof Some) {
            ExternalCatalog d;
            Some some = (Some)option;
            ExternalCatalog externalCatalog = d = (ExternalCatalog)some.x();
            return externalCatalog;
        }
        throw new CatalogNotExistException(catalogName, null);
    }

    @Override
    public synchronized List<String> listSubCatalogs() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.databases().keys().toList()).asJava();
    }

    public InMemoryExternalCatalog(String name) {
        this.name = name;
        this.databases = new HashMap();
        this.tables = new HashMap();
    }
}

