/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.flink.table.api.AmbiguousTableFactoryException;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.MetadataValidator$;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.descriptors.StatisticsValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.factories.TableFormatFactory;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class TableFactoryService$
implements Logging {
    public static final TableFactoryService$ MODULE$;
    private ServiceLoader<TableFactory> defaultLoader;
    private final transient Logger LOG;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TableFactoryService$();
    }

    private ServiceLoader defaultLoader$lzycompute() {
        TableFactoryService$ tableFactoryService$ = this;
        synchronized (tableFactoryService$) {
            if (!this.bitmap$0) {
                this.defaultLoader = ServiceLoader.load(TableFactory.class);
                this.bitmap$0 = true;
            }
            return this.defaultLoader;
        }
    }

    private Logger LOG$lzycompute() {
        TableFactoryService$ tableFactoryService$ = this;
        synchronized (tableFactoryService$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    private ServiceLoader<TableFactory> defaultLoader() {
        return this.bitmap$0 ? this.defaultLoader : this.defaultLoader$lzycompute();
    }

    public <T> T find(Class<T> factoryClass, Descriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor);
        return this.findInternal(factoryClass, descriptor.toProperties(), (Option<ClassLoader>)None$.MODULE$);
    }

    public <T> T find(Class<T> factoryClass, Descriptor descriptor, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)descriptor);
        Preconditions.checkNotNull((Object)classLoader);
        return this.findInternal(factoryClass, descriptor.toProperties(), (Option<ClassLoader>)new Some((Object)classLoader));
    }

    public <T> T find(Class<T> factoryClass, Map<String, String> propertyMap) {
        return this.findInternal(factoryClass, propertyMap, (Option<ClassLoader>)None$.MODULE$);
    }

    public <T> T find(Class<T> factoryClass, Map<String, String> propertyMap, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader);
        return this.findInternal(factoryClass, propertyMap, (Option<ClassLoader>)new Some((Object)classLoader));
    }

    private <T> T findInternal(Class<T> factoryClass, Map<String, String> propertyMap, Option<ClassLoader> classLoader) {
        Preconditions.checkNotNull(factoryClass);
        Preconditions.checkNotNull(propertyMap);
        scala.collection.immutable.Map properties = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(propertyMap).asScala()).toMap(Predef$.MODULE$.$conforms());
        Seq<TableFactory> foundFactories = this.discoverFactories(classLoader);
        Seq<TableFactory> classFactories = this.filterByFactoryClass(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories);
        Seq<TableFactory> contextFactories = this.filterByContext(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories, classFactories);
        return this.filterBySupportedProperties(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories, contextFactories);
    }

    private <T> Seq<TableFactory> discoverFactories(Option<ClassLoader> classLoader) {
        try {
            Option<ClassLoader> option;
            block6: {
                Iterator<TableFactory> iterator;
                block5: {
                    block4: {
                        option = classLoader;
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        ClassLoader customClassLoader = (ClassLoader)some.x();
                        ServiceLoader<TableFactory> customLoader = ServiceLoader.load(TableFactory.class, customClassLoader);
                        iterator = customLoader.iterator();
                        break block5;
                    }
                    if (!None$.MODULE$.equals(option)) break block6;
                    iterator = this.defaultLoader().iterator();
                }
                Iterator<TableFactory> iterator2 = iterator;
                return ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(iterator2).asScala()).toSeq();
            }
            throw new MatchError(option);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            this.LOG().error("Could not load service provider for table factories.", (Throwable)serviceConfigurationError);
            throw new TableException("Could not load service provider for table factories.", (Throwable)serviceConfigurationError);
        }
    }

    private <T> Seq<TableFactory> filterByFactoryClass(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories) {
        Seq classFactories = (Seq)foundFactories.filter((Function1)new Serializable(factoryClass){
            public static final long serialVersionUID = 0L;
            private final Class factoryClass$1;

            public final boolean apply(TableFactory f) {
                return this.factoryClass$1.isAssignableFrom(f.getClass());
            }
            {
                this.factoryClass$1 = factoryClass$1;
            }
        });
        if (classFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No factory implements '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factoryClass.getCanonicalName()})), factoryClass, foundFactories, properties);
        }
        return classFactories;
    }

    private <T> Seq<TableFactory> filterByContext(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories, Seq<TableFactory> classFactories) {
        Seq matchingFactories = (Seq)classFactories.filter((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map properties$1;

            public final boolean apply(TableFactory factory) {
                scala.collection.immutable.Map<String, String> requestedContext = TableFactoryService$.MODULE$.org$apache$flink$table$factories$TableFactoryService$$normalizeContext(factory);
                scala.collection.mutable.Map plainContext = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                plainContext.$plus$plus$eq(requestedContext);
                plainContext.remove((Object)"connector.property-version");
                plainContext.remove((Object)"format.property-version");
                plainContext.remove((Object)MetadataValidator$.MODULE$.METADATA_PROPERTY_VERSION());
                plainContext.remove((Object)StatisticsValidator$.MODULE$.STATISTICS_PROPERTY_VERSION());
                return plainContext.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;

                    public final boolean apply(Tuple2<String, String> e2) {
                        return this.$outer.properties$1.contains(e2._1()) && BoxesRunTime.equals((Object)this.$outer.properties$1.apply(e2._1()), (Object)e2._2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.properties$1 = properties$1;
            }
        });
        if (matchingFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException("No context matches.", factoryClass, foundFactories, properties);
        }
        return matchingFactories;
    }

    public scala.collection.immutable.Map<String, String> org$apache$flink$table$factories$TableFactoryService$$normalizeContext(TableFactory factory) {
        Map requiredContextJava = factory.requiredContext();
        if (requiredContextJava == null) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Required context of factory '", "' must not be null."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory.getClass().getName()})));
        }
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requiredContextJava).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> e2) {
                return new Tuple2((Object)((String)e2._1()).toLowerCase(), e2._2());
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private <T> T filterBySupportedProperties(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories, Seq<TableFactory> classFactories) {
        ArrayBuffer plainGivenKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        properties.keys().foreach((Function1)new Serializable(plainGivenKeys){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer plainGivenKeys$1;

            public final Object apply(String k) {
                String key = k.replaceAll(".\\d+", ".#");
                return this.plainGivenKeys$1.contains((Object)key) ? BoxedUnit.UNIT : this.plainGivenKeys$1.$plus$eq((Object)key);
            }
            {
                this.plainGivenKeys$1 = plainGivenKeys$1;
            }
        });
        ObjectRef lastKey = ObjectRef.create((Object)None$.MODULE$);
        Seq supportedFactories = (Seq)classFactories.filter((Function1)new Serializable(plainGivenKeys, lastKey){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer plainGivenKeys$1;
            public final ObjectRef lastKey$1;

            public final boolean apply(TableFactory factory) {
                Set requiredContextKeys = TableFactoryService$.MODULE$.org$apache$flink$table$factories$TableFactoryService$$normalizeContext(factory).keySet();
                Tuple2<Seq<String>, Seq<String>> tuple2 = TableFactoryService$.MODULE$.org$apache$flink$table$factories$TableFactoryService$$normalizeSupportedProperties(factory);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Seq supportedKeys = (Seq)tuple2._1();
                    Seq wildcards = (Seq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)supportedKeys, (Object)wildcards);
                    Seq supportedKeys2 = (Seq)tuple23._1();
                    Seq wildcards2 = (Seq)tuple23._2();
                    ArrayBuffer givenContextFreeKeys = (ArrayBuffer)this.plainGivenKeys$1.filter((Function1)new Serializable(this, requiredContextKeys){
                        public static final long serialVersionUID = 0L;
                        private final Set requiredContextKeys$1;

                        public final boolean apply(String x$2) {
                            return !this.requiredContextKeys$1.contains((Object)x$2);
                        }
                        {
                            this.requiredContextKeys$1 = requiredContextKeys$1;
                        }
                    });
                    Seq<String> givenFilteredKeys = TableFactoryService$.MODULE$.org$apache$flink$table$factories$TableFactoryService$$filterSupportedPropertiesFactorySpecific(factory, (Seq<String>)givenContextFreeKeys);
                    return givenFilteredKeys.forall((Function1)new Serializable(this, supportedKeys2, wildcards2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.3 $outer;
                        private final Seq supportedKeys$1;
                        private final Seq wildcards$1;

                        public final boolean apply(String k) {
                            this.$outer.lastKey$1.elem = Option$.MODULE$.apply((Object)k);
                            return this.supportedKeys$1.contains((Object)k) || this.wildcards$1.exists((Function1)new Serializable(this, k){
                                public static final long serialVersionUID = 0L;
                                private final String k$1;

                                public final boolean apply(String x$1) {
                                    return this.k$1.startsWith(x$1);
                                }
                                {
                                    this.k$1 = k$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.supportedKeys$1 = supportedKeys$1;
                            this.wildcards$1 = wildcards$1;
                        }
                    });
                }
                throw new MatchError(tuple2);
            }
            {
                this.plainGivenKeys$1 = plainGivenKeys$1;
                this.lastKey$1 = lastKey$1;
            }
        });
        if (supportedFactories.isEmpty() && classFactories.length() == 1 && ((Option)lastKey.elem).isDefined()) {
            TableFactory factory = (TableFactory)classFactories.head();
            Tuple2<Seq<String>, Seq<String>> tuple2 = this.org$apache$flink$table$factories$TableFactoryService$$normalizeSupportedProperties(factory);
            if (tuple2 != null) {
                Seq supportedKeys;
                Seq seq;
                Seq supportedKeys2 = seq = (supportedKeys = (Seq)tuple2._1());
                throw new NoMatchingTableFactoryException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |The matching factory '", "' doesn't support '", "'.\n          |\n          |Supported properties of this factory are:\n          |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory.getClass().getName(), ((Option)lastKey.elem).get(), ((TraversableOnce)supportedKeys2.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")})))).stripMargin(), factoryClass, foundFactories, properties);
            }
            throw new MatchError(tuple2);
        }
        if (supportedFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No factory supports all properties."})).s((Seq)Nil$.MODULE$), factoryClass, foundFactories, properties);
        }
        if (supportedFactories.length() > 1) {
            throw new AmbiguousTableFactoryException((Seq<TableFactory>)supportedFactories, factoryClass, foundFactories, properties);
        }
        return (T)supportedFactories.head();
    }

    public Tuple2<Seq<String>, Seq<String>> org$apache$flink$table$factories$TableFactoryService$$normalizeSupportedProperties(TableFactory factory) {
        List supportedPropertiesJava = factory.supportedProperties();
        if (supportedPropertiesJava == null) {
            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported properties of factory '", "' must not be null."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{factory.getClass().getName()})));
        }
        Buffer supportedKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(supportedPropertiesJava).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.toLowerCase();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<String> wildcards = this.extractWildcardPrefixes((Seq<String>)supportedKeys);
        return new Tuple2((Object)supportedKeys, wildcards);
    }

    private Seq<String> extractWildcardPrefixes(Seq<String> propertyKeys) {
        return (Seq)((TraversableLike)propertyKeys.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return x$4.endsWith("*");
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s) {
                return s.substring(0, s.length() - 1);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> org$apache$flink$table$factories$TableFactoryService$$filterSupportedPropertiesFactorySpecific(TableFactory factory, Seq<String> keys) {
        Seq seq;
        TableFactory tableFactory = factory;
        if (tableFactory instanceof TableFormatFactory) {
            TableFormatFactory tableFormatFactory = (TableFormatFactory)tableFactory;
            boolean includeSchema = tableFormatFactory.supportsSchemaDerivation();
            seq = (Seq)keys.filter((Function1)new Serializable(includeSchema){
                public static final long serialVersionUID = 0L;
                private final boolean includeSchema$1;

                public final boolean apply(String k) {
                    return this.includeSchema$1 ? k.startsWith(new StringBuilder().append((Object)SchemaValidator$.MODULE$.SCHEMA()).append((Object)".").toString()) || k.startsWith("format.") : k.startsWith("format.");
                }
                {
                    this.includeSchema$1 = includeSchema$1;
                }
            });
        } else {
            seq = keys;
        }
        return seq;
    }

    private TableFactoryService$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

