/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.runtime.CRowWrappingCollector;
import org.apache.flink.table.runtime.join.BaseTwoInputStreamOperatorWithStateRetention;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001BC\u000b\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011AFQ1tKR;x.\u00138qkR\u001cFO]3b[>\u0003XM]1u_J<\u0016\u000e\u001e5Ti\u0006$XMU3uK:$\u0018n\u001c8\u0011\u0007UA\"$D\u0001\u0017\u0015\t9b!A\u0004d_\u0012,w-\u001a8\n\u0005e1\"\u0001C\"p[BLG.\u001a:\u0011\u000bm\u0011C\u0005\n\u0013\u000e\u0003qQ!!\b\u0010\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u0010!\u0003\u0019\u0019w.\\7p]*\u0011\u0011\u0005C\u0001\u0004CBL\u0017BA\u0012\u001d\u0005A1E.\u0019;K_&tg)\u001e8di&|g\u000e\u0005\u0002&Q5\taE\u0003\u0002(\u0011\u0005)A/\u001f9fg&\u0011\u0011F\n\u0002\u0004%><\bCA\u0016/\u001b\u0005a#BA\u0017\u0007\u0003\u0011)H/\u001b7\n\u0005=b#a\u0002'pO\u001eLgn\u001a\u0005\tc\u0001\u0011\t\u0011)A\u0005e\u0005AA.\u001a4u)f\u0004X\rE\u00024m\u0011j\u0011\u0001\u000e\u0006\u0003ky\t\u0001\u0002^=qK&tgm\\\u0005\u0003oQ\u0012q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\ts\u0001\u0011\t\u0011)A\u0005e\u0005I!/[4iiRK\b/\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u0005yq-\u001a8K_&tg)\u001e8d\u001d\u0006lW\r\u0005\u0002>\u0007:\u0011a(Q\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\u00051\u0001K]3eK\u001aL!\u0001R#\u0003\rM#(/\u001b8h\u0015\t\u0011u\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003=\u0003=9WM\u001c&pS:4UO\\2D_\u0012,\u0007\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0003\u00176k\u0011\u0001\u0014\u0006\u0003C\u0019I!A\u0014'\u0003#M#(/Z1n#V,'/_\"p]\u001aLw\r\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0003EaWM\u001a;US6,\u0017\t\u001e;sS\n,H/\u001a\t\u0003}IK!aU \u0003\u0007%sG\u000f\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003R\u0003I\u0011\u0018n\u001a5u)&lW-\u0011;ue&\u0014W\u000f^3\t\u000b]\u0003A\u0011\u0001-\u0002\rqJg.\u001b;?)!I&l\u0017/^=~\u0003\u0007CA\t\u0001\u0011\u0015\td\u000b1\u00013\u0011\u0015Id\u000b1\u00013\u0011\u0015Yd\u000b1\u0001=\u0011\u00159e\u000b1\u0001=\u0011\u0015Ie\u000b1\u0001K\u0011\u0015\u0001f\u000b1\u0001R\u0011\u0015)f\u000b1\u0001R\u0011\u001d\u0011\u0007A1A\u0005\n\r\f!DT#Y)~cUI\u0012+`\u0013:#U\tW0T)\u0006#Vi\u0018(B\u001b\u0016+\u0012\u0001\u001a\t\u0003K*l\u0011A\u001a\u0006\u0003O\"\fA\u0001\\1oO*\t\u0011.\u0001\u0003kCZ\f\u0017B\u0001#g\u0011\u0019a\u0007\u0001)A\u0005I\u0006Yb*\u0012-U?2+e\tV0J\u001d\u0012+\u0005lX*U\u0003R+uLT!N\u000b\u0002BqA\u001c\u0001C\u0002\u0013%1-A\bM\u000b\u001a#vl\u0015+B)\u0016{f*Q'F\u0011\u0019\u0001\b\u0001)A\u0005I\u0006\u0001B*\u0012$U?N#\u0016\tV#`\u001d\u0006kU\t\t\u0005\be\u0002\u0011\r\u0011\"\u0003d\u0003A\u0011\u0016j\u0012%U?N#\u0016\tV#`\u001d\u0006kU\t\u0003\u0004u\u0001\u0001\u0006I\u0001Z\u0001\u0012%&;\u0005\nV0T)\u0006#Vi\u0018(B\u001b\u0016\u0003\u0003b\u0002<\u0001\u0005\u0004%IaY\u0001\u001c%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#\t\ra\u0004\u0001\u0015!\u0003e\u0003q\u0011ViR%T)\u0016\u0013V\tR0U\u00136+%kX*U\u0003R+uLT!N\u000b\u0002BqA\u001f\u0001C\u0002\u0013%1-A\tU\u00136+%kU0T)\u0006#Vi\u0018(B\u001b\u0016Ca\u0001 \u0001!\u0002\u0013!\u0017A\u0005+J\u001b\u0016\u00136kX*U\u0003R+uLT!N\u000b\u0002BqA \u0001C\u0002\u0013%q0\u0001\fsS\u001eDGOU8xi&lWmQ8na\u0006\u0014\u0018\r^8s+\t\t\t\u0001E\u0002\u0012\u0003\u0007I1!!\u0002\u0003\u0005E\u0011vn\u001e;j[\u0016\u001cu.\u001c9be\u0006$xN\u001d\u0005\t\u0003\u0013\u0001\u0001\u0015!\u0003\u0002\u0002\u00059\"/[4iiJ{w\u000f^5nK\u000e{W\u000e]1sCR|'\u000f\t\u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty!A\u0007oKb$H*\u001a4u\u0013:$W\r_\u000b\u0003\u0003#\u0001b!a\u0005\u0002\u001a\u0005uQBAA\u000b\u0015\r\t9BH\u0001\u0006gR\fG/Z\u0005\u0005\u00037\t)B\u0001\u0006WC2,Xm\u0015;bi\u0016\u00042!ZA\u0010\u0013\r\t\tC\u001a\u0002\u0005\u0019>tw\rC\u0006\u0002&\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0012!\u00058fqRdUM\u001a;J]\u0012,\u0007p\u0018\u0013fcR!\u0011\u0011FA\u0018!\rq\u00141F\u0005\u0004\u0003[y$\u0001B+oSRD!\"!\r\u0002$\u0005\u0005\t\u0019AA\t\u0003\rAH%\r\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002\u0012\u0005qa.\u001a=u\u0019\u00164G/\u00138eKb\u0004\u0003bCA\u001d\u0001\u0001\u0007\t\u0019!C\u0005\u0003w\t\u0011\u0002\\3giN#\u0018\r^3\u0016\u0005\u0005u\u0002cBA\n\u0003\u007f\ti\u0002J\u0005\u0005\u0003\u0003\n)B\u0001\u0005NCB\u001cF/\u0019;f\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\u0002\u001b1,g\r^*uCR,w\fJ3r)\u0011\tI#!\u0013\t\u0015\u0005E\u00121IA\u0001\u0002\u0004\ti\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0015BA\u001f\u0003)aWM\u001a;Ti\u0006$X\r\t\u0005\f\u0003#\u0002\u0001\u0019!a\u0001\n\u0013\tY$\u0001\u0006sS\u001eDGo\u0015;bi\u0016D1\"!\u0016\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002X\u0005q!/[4iiN#\u0018\r^3`I\u0015\fH\u0003BA\u0015\u00033B!\"!\r\u0002T\u0005\u0005\t\u0019AA\u001f\u0011!\ti\u0006\u0001Q!\n\u0005u\u0012a\u0003:jO\"$8\u000b^1uK\u0002B1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010\u0005y!/Z4jgR,'/\u001a3US6,'\u000fC\u0006\u0002f\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0014a\u0005:fO&\u001cH/\u001a:fIRKW.\u001a:`I\u0015\fH\u0003BA\u0015\u0003SB!\"!\r\u0002d\u0005\u0005\t\u0019AA\t\u0011!\ti\u0007\u0001Q!\n\u0005E\u0011\u0001\u0005:fO&\u001cH/\u001a:fIRKW.\u001a:!\u0011-\t\t\b\u0001a\u0001\u0002\u0004%I!a\u001d\u0002\u0017\r\u0014vn^,sCB\u0004XM]\u000b\u0003\u0003k\u0002B!a\u001e\u0002z5\tA!C\u0002\u0002|\u0011\u0011Qc\u0011*po^\u0013\u0018\r\u001d9j]\u001e\u001cu\u000e\u001c7fGR|'\u000fC\u0006\u0002\u0000\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0015aD2S_^<&/\u00199qKJ|F%Z9\u0015\t\u0005%\u00121\u0011\u0005\u000b\u0003c\ti(!AA\u0002\u0005U\u0004\u0002CAD\u0001\u0001\u0006K!!\u001e\u0002\u0019\r\u0014vn^,sCB\u0004XM\u001d\u0011\t\u0017\u0005-\u0005\u00011AA\u0002\u0013%\u0011QR\u0001\nG>dG.Z2u_J,\"!a$\u0011\r\u0005E\u0015QTAQ\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006]\u0015!C8qKJ\fGo\u001c:t\u0015\r\t\u0013\u0011\u0014\u0006\u0004\u00037C\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\ty*a%\u0003)QKW.Z:uC6\u0004X\rZ\"pY2,7\r^8s!\u0011\t\u0019+a*\u000e\u0005\u0005\u0015&BA\u0014\u0005\u0013\u0011\tI+!*\u0003\t\r\u0013vn\u001e\u0005\f\u0003[\u0003\u0001\u0019!a\u0001\n\u0013\ty+A\u0007d_2dWm\u0019;pe~#S-\u001d\u000b\u0005\u0003S\t\t\f\u0003\u0006\u00022\u0005-\u0016\u0011!a\u0001\u0003\u001fC\u0001\"!.\u0001A\u0003&\u0011qR\u0001\u000bG>dG.Z2u_J\u0004\u0003bCA]\u0001\u0001\u0007\t\u0019!C\u0005\u0003w\u000bAB[8j]\u001a+hn\u0019;j_:,\u0012A\u0007\u0005\f\u0003\u007f\u0003\u0001\u0019!a\u0001\n\u0013\t\t-\u0001\tk_&tg)\u001e8di&|gn\u0018\u0013fcR!\u0011\u0011FAb\u0011%\t\t$!0\u0002\u0002\u0003\u0007!\u0004C\u0004\u0002H\u0002\u0001\u000b\u0015\u0002\u000e\u0002\u001b)|\u0017N\u001c$v]\u000e$\u0018n\u001c8!\u0011\u001d\tY\r\u0001C!\u0003\u001b\fAa\u001c9f]R\u0011\u0011\u0011\u0006\u0005\b\u0003#\u0004A\u0011IAj\u0003=\u0001(o\\2fgN,E.Z7f]R\fD\u0003BA\u0015\u0003+D\u0001\"a6\u0002P\u0002\u0007\u0011\u0011\\\u0001\bK2,W.\u001a8u!\u0019\tY.a9\u0002\"6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/\u0001\u0007tiJ,\u0017-\u001c:fG>\u0014HMC\u0002\u0006\u00033KA!!:\u0002^\na1\u000b\u001e:fC6\u0014VmY8sI\"9\u0011\u0011\u001e\u0001\u0005B\u0005-\u0018a\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u001a\u0015\t\u0005%\u0012Q\u001e\u0005\t\u0003/\f9\u000f1\u0001\u0002Z\"9\u0011\u0011\u001f\u0001\u0005B\u0005M\u0018aC8o\u000bZ,g\u000e\u001e+j[\u0016$B!!\u000b\u0002v\"A\u0011q_Ax\u0001\u0004\tI0A\u0003uS6,'\u000f\u0005\u0005\u0002\u0012\u0006m\u0018q B\u0003\u0013\u0011\ti0a%\u0003\u001b%sG/\u001a:oC2$\u0016.\\3s!\rq$\u0011A\u0005\u0004\u0005\u0007y$aA!osB!!q\u0001B\u0007\u001b\t\u0011IA\u0003\u0003\u0002\u0018\t-!BA\u0003\t\u0013\u0011\u0011yA!\u0003\u0003\u001bY{\u0017\u000e\u001a(b[\u0016\u001c\b/Y2f\u0011\u001d\u0011\u0019\u0002\u0001C!\u0003\u001b\fQa\u00197pg\u0016DqAa\u0006\u0001\t\u0013\u0011I\"A\u000bsK\u001eL7\u000f^3s'6\fG\u000e\\3tiRKW.\u001a:\u0015\t\u0005%\"1\u0004\u0005\t\u0005;\u0011)\u00021\u0001\u0003 \u0005IA/[7fgR\fW\u000e\u001d\t\u0004}\t\u0005\u0012bAA\u0011\u007f!9!Q\u0005\u0001\u0005\n\t\u001d\u0012!\u0004:fO&\u001cH/\u001a:US6,'\u000f\u0006\u0003\u0002*\t%\u0002\u0002\u0003B\u000f\u0005G\u0001\rAa\b\t\u000f\t5\u0002\u0001\"\u0003\u00030\u0005IR-\\5u%\u0016\u001cX\u000f\u001c;B]\u0012\u001cE.Z1o+B\u001cF/\u0019;f)\u0011\u0011yB!\r\t\u0011\tM\"1\u0006a\u0001\u0005?\ta\u0002^5nKJ$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u00038\u0001!IA!\u000f\u0002\u0019\rdW-\u00198VaN#\u0018\r^3\u0015\r\u0005%\"1\bB\u001f\u0011!\u0011\u0019D!\u000eA\u0002\t}\u0001\u0002\u0003B \u0005k\u0001\rA!\u0011\u0002\u001fILw\r\u001b;S_^\u001c8k\u001c:uK\u0012\u0004RAa\u0011\u0003H\u0011j!A!\u0012\u000b\u00055B\u0017\u0002\u0002B%\u0005\u000b\u0012A\u0001T5ti\"9!q\u0007\u0001\u0005B\t5C\u0003BA\u0015\u0005\u001fB\u0001B!\u0015\u0003L\u0001\u0007!qD\u0001\u0005i&lW\rC\u0004\u0003V\u0001!IAa\u0016\u0002!\u0019L'o\u001d;J]\u0012,\u0007\u0010V8LK\u0016\u0004H#B)\u0003Z\tm\u0003\u0002\u0003B\u001a\u0005'\u0002\rAa\b\t\u0011\t}\"1\u000ba\u0001\u0005\u0003BqAa\u0018\u0001\t\u0013\u0011\t'A\u0011j]\u0012,\u0007p\u00144GSJ\u001cH/\u00127f[\u0016tGOT3xKJ$\u0006.\u00198US6,'\u000fF\u0003R\u0005G\u0012)\u0007\u0003\u0005\u00034\tu\u0003\u0019\u0001B\u0010\u0011!\u00119G!\u0018A\u0002\t\u0005\u0013\u0001\u00027jgRDqAa\u001b\u0001\t\u0013\u0011i'\u0001\u000bmCR,7\u000f\u001e*jO\"$(k\\<U_*{\u0017N\u001c\u000b\u0007\u0005_\u0012)Ha\u001e\u0011\u000b\t\r#\u0011\u000f\u0013\n\t\tM$Q\t\u0002\t\u001fB$\u0018n\u001c8bY\"A!q\bB5\u0001\u0004\u0011\t\u0005\u0003\u0005\u0003z\t%\u0004\u0019\u0001B\u0010\u0003!aWM\u001a;US6,\u0007b\u0002B6\u0001\u0011%!Q\u0010\u000b\u000b\u0005_\u0012yH!!\u0003\u0006\n%\u0005\u0002\u0003B \u0005w\u0002\rA!\u0011\t\u000f\t\r%1\u0010a\u0001#\u0006\u0019An\\<\t\u000f\t\u001d%1\u0010a\u0001#\u0006!\u0001.[4i\u0011!\u0011IHa\u001fA\u0002\t}\u0001b\u0002BG\u0001\u0011%!qR\u0001\u0013O\u0016$(+[4iiJ{wo]*peR,G\r\u0006\u0003\u0003B\tE\u0005\u0002\u0003BJ\u0005\u0017\u0003\r!!\u0001\u0002#I|w\u000f^5nK\u000e{W\u000e]1sCR|'\u000fC\u0004\u0003\u0018\u0002!IA!'\u0002!\u001d,GOT3yi2+g\r^%oI\u0016DXCAA\u000f\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u000b1bZ3u\u0019\u00164G\u000fV5nKR!!q\u0004BQ\u0011\u001d\u0011\u0019Ka'A\u0002\u0011\nq\u0001\\3giJ{w\u000fC\u0004\u0003(\u0002!IA!+\u0002\u0019\u001d,GOU5hQR$\u0016.\\3\u0015\t\t}!1\u0016\u0005\b\u0005[\u0013)\u000b1\u0001%\u0003!\u0011\u0018n\u001a5u%><\bb\u0002BY\u0001\u0011%!1W\u0001\u0013G\",7m\u001b(piJ+GO]1di&|g\u000e\u0006\u0003\u0002*\tU\u0006\u0002CAl\u0005_\u0003\r!!7")
public class TemporalRowtimeJoin
extends BaseTwoInputStreamOperatorWithStateRetention
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, Row> leftState;
    private MapState<Long, Row> rightState;
    private ValueState<Long> registeredTimer;
    private CRowWrappingCollector cRowWrapper;
    private TimestampedCollector<CRow> collector;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, Row> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, Row> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, Row> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, Row> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    private CRowWrappingCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    private void cRowWrapper_$eq(CRowWrappingCollector x$1) {
        this.cRowWrapper = x$1;
    }

    private TimestampedCollector<CRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<CRow> x$1) {
        this.collector = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    @Override
    public void open() {
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling FlatJoinFunction: ", " \\n\\n Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genJoinFuncName, this.genJoinFuncCode})));
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating FlatJoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)new Configuration());
        this.nextLeftIndex_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.NEXT_LEFT_INDEX_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.LEFT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.RIGHT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.REGISTERED_TIMER_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<CRow>)new TimestampedCollector(this.output));
        this.cRowWrapper_$eq(new CRowWrappingCollector());
        this.cRowWrapper().out_$eq((Collector<CRow>)this.collector());
        this.cRowWrapper().setChange(true);
        super.open();
    }

    public void processElement1(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        this.leftState().put((Object)this.getNextLeftIndex(), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(this.getLeftTime(((CRow)element.getValue()).row()));
        this.registerProcessingCleanUpTimer();
    }

    public void processElement2(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        long rowTime = this.getRightTime(((CRow)element.getValue()).row());
        this.rightState().put((Object)Predef$.MODULE$.long2Long(rowTime), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(rowTime);
        this.registerProcessingCleanUpTimer();
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        this.registeredTimer().clear();
        long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
        if (lastUnprocessedTime < Long.MAX_VALUE) {
            this.registerTimer(lastUnprocessedTime);
        }
        if (this.stateCleaningEnabled()) {
            if (lastUnprocessedTime < Long.MAX_VALUE || this.rightState().iterator().hasNext()) {
                this.registerProcessingCleanUpTimer();
            } else {
                this.cleanUpLastTimer();
            }
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private void registerSmallestTimer(long timestamp) {
        Long currentRegisteredTimer = (Long)this.registeredTimer().value();
        if (currentRegisteredTimer == null) {
            this.registerTimer(timestamp);
        } else if (currentRegisteredTimer != null && Predef$.MODULE$.Long2long(currentRegisteredTimer) > timestamp) {
            this.timerService().deleteEventTimeTimer(Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update((Object)Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer(timestamp);
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<Row> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry leftEntry = (Map.Entry)leftIterator.next();
            Row leftRow = (Row)leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<Row> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join((Object)leftRow, (Object)rightRow.get(), (Collector)this.cRowWrapper());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<Row> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove((Object)Predef$.MODULE$.long2Long(rightTime));
        }
    }

    @Override
    public void cleanUpState(long time) {
        this.leftState().clear();
        this.rightState().clear();
    }

    private int firstIndexToKeep(long timerTimestamp, List<Row> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<Row> list) {
        ListIterator<Row> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, int low, int high, long leftTime) {
        Optional<Row> optional;
        block3: {
            Row midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<Row> rightRows = new ArrayList<Row>();
        JavaConversions$.MODULE$.iterableAsScalaIterable(this.rightState().values()).foreach((Function1)new Serializable(this, rightRows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rightRows$1;

            public final boolean apply(Row row2) {
                return this.rightRows$1.add(row2);
            }
            {
                this.rightRows$1 = rightRows$1;
            }
        });
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = (Long)this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update((Object)Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(Row leftRow) {
        return BoxesRunTime.unboxToLong((Object)leftRow.getField(this.leftTimeAttribute));
    }

    private long getRightTime(Row rightRow) {
        return BoxesRunTime.unboxToLong((Object)rightRow.getField(this.rightTimeAttribute));
    }

    private void checkNotRetraction(StreamRecord<CRow> element) {
        if (((CRow)element.getValue()).change()) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retractions are not supported by [", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TemporalRowtimeJoin.class.getSimpleName()}))).append((Object)"If this can happen it should be validated during planning!").toString());
    }

    public TemporalRowtimeJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

