/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001rc\u0005\u0003\u0001#%\u0012\u0004#\u0002\n\u0014+\r\u001aS\"\u0001\u0002\n\u0005Q\u0011!a\b)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8XSRD7\t\\3b]V\u00048\u000b^1uKB\u0011ac\u0006\u0007\u0001\t\u0015A\u0002A1\u0001\u001a\u0005\u0005Y\u0015C\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0011\n\u0005\tb\"aA!osB\u0011AeJ\u0007\u0002K)\u0011a\u0005B\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0015\u0012Aa\u0011*poB\u0019!&L\u0018\u000e\u0003-R!\u0001\f\u0004\u0002\u000f\r|G-Z4f]&\u0011af\u000b\u0002\t\u0007>l\u0007/\u001b7feB\u0011!\u0003M\u0005\u0003c\t\u0011QcR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7\u000f\u0005\u00024m5\tAG\u0003\u00026\r\u0005!Q\u000f^5m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0002!\u0011!Q\u0001\ni\nqbZ3o\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003UmJ!\u0001P\u0016\u0003;\u001d+g.\u001a:bi\u0016$\u0017iZ4sK\u001e\fG/[8og\u001a+hn\u0019;j_:D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\u0015C\u001e<'/Z4bi&|gn\u0015;bi\u0016$\u0016\u0010]3\u0011\u0005\u0001;U\"A!\u000b\u0005\t\u001b\u0015!\u0003;za\u0016,H/\u001b7t\u0015\t!U)\u0001\u0003kCZ\f'B\u0001$\t\u0003\r\t\u0007/[\u0005\u0003\u0011\u0006\u00131BU8x)f\u0004X-\u00138g_\"A!\n\u0001B\u0001B\u0003%1*\u0001\u0007j]B,HOU8x)f\u0004X\r\u0005\u0002%\u0019&\u0011Q*\n\u0002\r\u0007J{w\u000fV=qK&sgm\u001c\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\u0006y\u0001O]3dK\u0012LgnZ(gMN,G\u000f\u0005\u0002\u001c#&\u0011!\u000b\b\u0002\u0005\u0019>tw\r\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0003)\u0011xn\u001e+j[\u0016LE\r\u001f\t\u00037YK!a\u0016\u000f\u0003\u0007%sG\u000f\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003Q\u0003Ai\u0017N\u001c*fi\u0016tG/[8o)&lW\r\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003Q\u0003Ai\u0017\r\u001f*fi\u0016tG/[8o)&lW\rC\u0003^\u0001\u0011\u0005a,\u0001\u0004=S:LGO\u0010\u000b\t?\u0002\f'm\u00193fMB\u0019!\u0003A\u000b\t\u000beb\u0006\u0019\u0001\u001e\t\u000byb\u0006\u0019A \t\u000b)c\u0006\u0019A&\t\u000b=c\u0006\u0019\u0001)\t\u000bQc\u0006\u0019A+\t\u000bec\u0006\u0019\u0001)\t\u000bmc\u0006\u0019\u0001)\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0013I\u0017AB8viB,H/F\u0001$\u0011%Y\u0007\u00011AA\u0002\u0013%A.\u0001\u0006pkR\u0004X\u000f^0%KF$\"!\u001c9\u0011\u0005mq\u0017BA8\u001d\u0005\u0011)f.\u001b;\t\u000fET\u0017\u0011!a\u0001G\u0005\u0019\u0001\u0010J\u0019\t\u0013M\u0004\u0001\u0019!A!B\u0013\u0019\u0013aB8viB,H\u000f\t\u0005\nk\u0002\u0001\r\u00111A\u0005\nY\fQ\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X-F\u0001x!\rAX\u0010U\u0007\u0002s*\u0011!p_\u0001\u0006gR\fG/\u001a\u0006\u0003y\u0016\u000baaY8n[>t\u0017B\u0001@z\u0005)1\u0016\r\\;f'R\fG/\u001a\u0005\f\u0003\u0003\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019!A\rmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3`I\u0015\fHcA7\u0002\u0006!9\u0011o`A\u0001\u0002\u00049\bBCA\u0005\u0001\u0001\u0007\t\u0011)Q\u0005o\u00061B.Y:u)JLwmZ3sS:<Gk]*uCR,\u0007\u0005\u0003\u0006\u0002\u000e\u0001\u0001\r\u00111A\u0005\nY\fa\u0002Z1uC\u000e{WO\u001c;Ti\u0006$X\rC\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0011A\u00053bi\u0006\u001cu.\u001e8u'R\fG/Z0%KF$2!\\A\u000b\u0011!\t\u0018qBA\u0001\u0002\u00049\bBCA\r\u0001\u0001\u0007\t\u0011)Q\u0005o\u0006yA-\u0019;b\u0007>,h\u000e^*uCR,\u0007\u0005C\u0006\u0002\u001e\u0001\u0001\r\u00111A\u0005\n\u0005}\u0011\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\t\t\t\u0003\u0005\u0003y{\u0006\r\u0002\u0003BA\u0013\u0003Si!!a\n\u000b\u0005\u0019B\u0011\u0002BA\u0016\u0003O\u00111AU8x\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\u0002)\u0005\u001c7-^7vY\u0006$xN]*uCR,w\fJ3r)\ri\u00171\u0007\u0005\nc\u00065\u0012\u0011!a\u0001\u0003CA1\"a\u000e\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\"\u0005\t\u0012mY2v[Vd\u0017\r^8s'R\fG/\u001a\u0011\t\u0017\u0005m\u0002\u00011AA\u0002\u0013%\u0011QH\u0001\nI\u0006$\u0018m\u0015;bi\u0016,\"!a\u0010\u0011\ra\f\t\u0005UA#\u0013\r\t\u0019%\u001f\u0002\t\u001b\u0006\u00048\u000b^1uKB1\u0011qIA'\u0003Gi!!!\u0013\u000b\u0007U\nYEC\u0001E\u0013\u0011\ty%!\u0013\u0003\t1K7\u000f\u001e\u0005\f\u0003'\u0002\u0001\u0019!a\u0001\n\u0013\t)&A\u0007eCR\f7\u000b^1uK~#S-\u001d\u000b\u0004[\u0006]\u0003\"C9\u0002R\u0005\u0005\t\u0019AA \u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!a\u0010\u0002\u0015\u0011\fG/Y*uCR,\u0007\u0005C\u0006\u0002`\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0014\u0001\u00034v]\u000e$\u0018n\u001c8\u0016\u0003=B1\"!\u001a\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002h\u0005aa-\u001e8di&|gn\u0018\u0013fcR\u0019Q.!\u001b\t\u0011E\f\u0019'!AA\u0002=B!\"!\u001c\u0001\u0001\u0004\u0005\t\u0015)\u00030\u0003%1WO\\2uS>t\u0007\u0005C\u0004\u0002r\u0001!\t%a\u001d\u0002\t=\u0004XM\u001c\u000b\u0004[\u0006U\u0004\u0002CA<\u0003_\u0002\r!!\u001f\u0002\r\r|gNZ5h!\u0011\tY(!!\u000e\u0005\u0005u$bAA@\u0011\u0005i1m\u001c8gS\u001e,(/\u0019;j_:LA!a!\u0002~\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\"\u0001\t\u0003\nI)\u0001\bqe>\u001cWm]:FY\u0016lWM\u001c;\u0015\u000f5\fY)a$\u0002,\"9\u0011QRAC\u0001\u0004\u0019\u0013AB5oaV$8\t\u0003\u0005\u0002\u0012\u0006\u0015\u0005\u0019AAJ\u0003\r\u0019G\u000f\u001f\t\u0005\u0003+\u000b9\u000bE\u0004\u0002\u0018\u0006\rVcI\u0012\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b\u0011BZ;oGRLwN\\:\u000b\u0007\u0019\u000byJC\u0002\u0002\"\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005\u0015\u0016\u0011\u0014\u0002\u0015\u0017\u0016LX\r\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005%\u00161\u0015\u0002\b\u0007>tG/\u001a=u\u0011!\ti+!\"A\u0002\u0005=\u0016aA8viB)\u0011\u0011WA[G5\u0011\u00111\u0017\u0006\u0003k!IA!a.\u00024\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003w\u0003A\u0011IA_\u0003\u001dyg\u000eV5nKJ$r!\\A`\u0003\u0007\fY\rC\u0004\u0002B\u0006e\u0006\u0019\u0001)\u0002\u0013QLW.Z:uC6\u0004\b\u0002CAI\u0003s\u0003\r!!2\u0011\t\u0005U\u0015qY\u0005\u0005\u0003\u0013\f\u0019K\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u00055\u0016\u0011\u0018a\u0001\u0003_Cq!a4\u0001\t\u0003\n\t.A\u0003dY>\u001cX\rF\u0001n\u0001")
public class RowTimeBoundedRowsOver<K>
extends ProcessFunctionWithCleanupState<K, CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, KeyedProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.processCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.stateCleaningEnabled()) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.processCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        block0: {
            if (this.function() == null) break block0;
            this.function().close();
        }
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, long minRetentionTime, long maxRetentionTime) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(minRetentionTime, maxRetentionTime);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

