/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.util.SegmentsUtil;

public interface BinaryFormat {
    public static final int MAX_FIX_PART_DATA_SIZE = 7;
    public static final long HIGHEST_FIRST_BIT = Long.MIN_VALUE;
    public static final long HIGHEST_SECOND_TO_EIGHTH_BIT = 0x7F00000000000000L;

    public MemorySegment[] getSegments();

    public int getOffset();

    public int getSizeInBytes();

    public static byte[] readBinaryFieldFromSegments(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return SegmentsUtil.copyToBytes(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (SegmentsUtil.LITTLE_ENDIAN) {
            return SegmentsUtil.copyToBytes(segments, fieldOffset, len);
        }
        return SegmentsUtil.copyToBytes(segments, fieldOffset + 1, len);
    }

    public static BinaryString readBinaryStringFieldFromSegments(MemorySegment[] segments, int baseOffset, int fieldOffset, long variablePartOffsetAndLen) {
        long mark = variablePartOffsetAndLen & Long.MIN_VALUE;
        if (mark == 0L) {
            int subOffset = (int)(variablePartOffsetAndLen >> 32);
            int len = (int)variablePartOffsetAndLen;
            return BinaryString.fromAddress(segments, baseOffset + subOffset, len);
        }
        int len = (int)((variablePartOffsetAndLen & 0x7F00000000000000L) >>> 56);
        if (SegmentsUtil.LITTLE_ENDIAN) {
            return BinaryString.fromAddress(segments, fieldOffset, len);
        }
        return BinaryString.fromAddress(segments, fieldOffset + 1, len);
    }
}

