/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.Preconditions;

public class SqlTimestamp
implements Comparable<SqlTimestamp> {
    private static final long MILLIS_PER_DAY = 86400000L;
    private final long millisecond;
    private final int nanoOfMillisecond;

    private SqlTimestamp(long millisecond, int nanoOfMillisecond) {
        Preconditions.checkArgument((nanoOfMillisecond >= 0 && nanoOfMillisecond <= 999999 ? 1 : 0) != 0);
        this.millisecond = millisecond;
        this.nanoOfMillisecond = nanoOfMillisecond;
    }

    @Override
    public int compareTo(SqlTimestamp that) {
        int cmp = Long.compare(this.millisecond, that.millisecond);
        if (cmp == 0) {
            cmp = this.nanoOfMillisecond - that.nanoOfMillisecond;
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SqlTimestamp)) {
            return false;
        }
        SqlTimestamp that = (SqlTimestamp)obj;
        return this.millisecond == that.millisecond && this.nanoOfMillisecond == that.nanoOfMillisecond;
    }

    public String toString() {
        return this.toLocalDateTime().toString();
    }

    public int hashCode() {
        int ret = (int)this.millisecond ^ (int)(this.millisecond >> 32);
        return 31 * ret + this.nanoOfMillisecond;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public int getNanoOfMillisecond() {
        return this.nanoOfMillisecond;
    }

    public static SqlTimestamp fromEpochMillis(long millisecond) {
        return new SqlTimestamp(millisecond, 0);
    }

    public static SqlTimestamp fromEpochMillis(long millisecond, int nanoOfMillisecond) {
        return new SqlTimestamp(millisecond, nanoOfMillisecond);
    }

    public Timestamp toTimestamp() {
        return Timestamp.valueOf(this.toLocalDateTime());
    }

    public static SqlTimestamp fromTimestamp(Timestamp ts) {
        return SqlTimestamp.fromLocalDateTime(ts.toLocalDateTime());
    }

    public LocalDateTime toLocalDateTime() {
        int date = (int)(this.millisecond / 86400000L);
        int time = (int)(this.millisecond % 86400000L);
        if (time < 0) {
            --date;
            time = (int)((long)time + 86400000L);
        }
        long nanoOfDay = (long)time * 1000000L + (long)this.nanoOfMillisecond;
        LocalDate localDate = LocalDate.ofEpochDay(date);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    public static SqlTimestamp fromLocalDateTime(LocalDateTime dateTime) {
        long epochDay = dateTime.toLocalDate().toEpochDay();
        long nanoOfDay = dateTime.toLocalTime().toNanoOfDay();
        long millisecond = epochDay * 86400000L + nanoOfDay / 1000000L;
        int nanoOfMillisecond = (int)(nanoOfDay % 1000000L);
        return new SqlTimestamp(millisecond, nanoOfMillisecond);
    }

    public Instant toInstant() {
        long epochSecond = this.millisecond / 1000L;
        int milliOfSecond = (int)(this.millisecond % 1000L);
        if (milliOfSecond < 0) {
            --epochSecond;
            milliOfSecond += 1000;
        }
        long nanoAdjustment = milliOfSecond * 1000000 + this.nanoOfMillisecond;
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }

    public static SqlTimestamp fromInstant(Instant instant) {
        long epochSecond = instant.getEpochSecond();
        int nanoSecond = instant.getNano();
        long millisecond = epochSecond * 1000L + (long)(nanoSecond / 1000000);
        int nanoOfMillisecond = nanoSecond % 1000000;
        return new SqlTimestamp(millisecond, nanoOfMillisecond);
    }

    public static boolean isCompact(int precision) {
        return precision <= 3;
    }

    public static SqlTimestamp readTimestampFieldFromSegments(MemorySegment[] segments, int baseOffset, long offsetAndNanos) {
        int nanoOfMillisecond = (int)offsetAndNanos;
        int subOffset = (int)(offsetAndNanos >> 32);
        long millisecond = SegmentsUtil.getLong(segments, baseOffset + subOffset);
        return SqlTimestamp.fromEpochMillis(millisecond, nanoOfMillisecond);
    }
}

