/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.keyselector;

import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.keyselector.BaseRowKeySelector;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;

public class BinaryRowKeySelector
implements BaseRowKeySelector {
    private static final long serialVersionUID = 5375355285015381919L;
    private final BaseRowTypeInfo keyRowType;
    private final GeneratedProjection generatedProjection;
    private transient Projection<BaseRow, BinaryRow> projection;

    public BinaryRowKeySelector(BaseRowTypeInfo keyRowType, GeneratedProjection generatedProjection) {
        this.keyRowType = keyRowType;
        this.generatedProjection = generatedProjection;
    }

    public BaseRow getKey(BaseRow value) throws Exception {
        if (this.projection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.projection = (Projection)this.generatedProjection.newInstance(cl);
        }
        return this.projection.apply(value).copy();
    }

    @Override
    public BaseRowTypeInfo getProducedType() {
        return this.keyRowType;
    }
}

