/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.util.Collector;

public class MiniBatchIncrementalGroupAggFunction
extends MapBundleFunction<BaseRow, BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = 1L;
    private final GeneratedAggsHandleFunction genPartialAggsHandler;
    private final GeneratedAggsHandleFunction genFinalAggsHandler;
    private final KeySelector<BaseRow, BaseRow> finalKeySelector;
    private transient JoinedRow resultRow = new JoinedRow();
    private transient AggsHandleFunction partialAgg = null;
    private transient AggsHandleFunction finalAgg = null;

    public MiniBatchIncrementalGroupAggFunction(GeneratedAggsHandleFunction genPartialAggsHandler, GeneratedAggsHandleFunction genFinalAggsHandler, KeySelector<BaseRow, BaseRow> finalKeySelector) {
        this.genPartialAggsHandler = genPartialAggsHandler;
        this.genFinalAggsHandler = genFinalAggsHandler;
        this.finalKeySelector = finalKeySelector;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ClassLoader classLoader = ctx.getRuntimeContext().getUserCodeClassLoader();
        this.partialAgg = (AggsHandleFunction)this.genPartialAggsHandler.newInstance(classLoader);
        this.partialAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.finalAgg = (AggsHandleFunction)this.genFinalAggsHandler.newInstance(classLoader);
        this.finalAgg.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.resultRow = new JoinedRow();
    }

    @Override
    public BaseRow addInput(@Nullable BaseRow previousAcc, BaseRow input) throws Exception {
        BaseRow currentAcc = previousAcc == null ? this.partialAgg.createAccumulators() : previousAcc;
        this.partialAgg.setAccumulators(currentAcc);
        this.partialAgg.merge(input);
        return this.partialAgg.getAccumulators();
    }

    @Override
    public void finishBundle(Map<BaseRow, BaseRow> buffer, Collector<BaseRow> out) throws Exception {
        HashMap<BaseRow, Map> finalAggBuffer = new HashMap<BaseRow, Map>();
        for (Map.Entry<BaseRow, BaseRow> entry : buffer.entrySet()) {
            BaseRow partialKey = entry.getKey();
            BaseRow finalKey = (BaseRow)this.finalKeySelector.getKey((Object)partialKey);
            BaseRow partialAcc = entry.getValue();
            Map map = finalAggBuffer.computeIfAbsent(finalKey, r -> new HashMap());
            map.put(partialKey, partialAcc);
        }
        for (Map.Entry<BaseRow, BaseRow> entry : finalAggBuffer.entrySet()) {
            BaseRow finalKey = entry.getKey();
            Map accMap = (Map)((Object)entry.getValue());
            this.finalAgg.resetAccumulators();
            for (Map.Entry entry2 : accMap.entrySet()) {
                BaseRow partialKey = (BaseRow)entry2.getKey();
                BaseRow partialAcc = (BaseRow)entry2.getValue();
                this.ctx.setCurrentKey(partialKey);
                this.finalAgg.merge(partialAcc);
            }
            BaseRow finalAcc = this.finalAgg.getAccumulators();
            this.resultRow.replace(finalKey, finalAcc);
            out.collect((Object)this.resultRow);
        }
        finalAggBuffer.clear();
    }

    @Override
    public void close() throws Exception {
        if (this.partialAgg != null) {
            this.partialAgg.close();
        }
        if (this.finalAgg != null) {
            this.finalAgg.close();
        }
    }
}

