/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.util.Collector;

public class DeduplicateKeepFirstRowFunction
extends KeyedProcessFunctionWithCleanupState<BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = 5865777137707602549L;
    private ValueState<Boolean> state;

    public DeduplicateKeepFirstRowFunction(long minRetentionTime, long maxRetentionTime) {
        super(minRetentionTime, maxRetentionTime);
    }

    public void open(Configuration configure) throws Exception {
        super.open(configure);
        this.initCleanupTimeState("DeduplicateFunctionKeepFirstRow");
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("existsState", Types.BOOLEAN);
        this.state = this.getRuntimeContext().getState(stateDesc);
    }

    public void processElement(BaseRow input, KeyedProcessFunction.Context ctx, Collector<BaseRow> out) throws Exception {
        long currentTime = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime);
        DeduplicateFunctionHelper.processFirstRow(input, this.state, out);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<BaseRow> out) throws Exception {
        if (this.stateCleaningEnabled) {
            this.cleanupState(new State[]{this.state});
        }
    }
}

