/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;

public class OuterJoinPaddingUtil
implements Serializable {
    private static final long serialVersionUID = -2295909099427806938L;
    private final int leftArity;
    private final int rightArity;
    private transient JoinedRow joinedRow = new JoinedRow();
    private transient GenericRow leftNullPaddingRow;
    private transient GenericRow rightNullPaddingRow;

    public OuterJoinPaddingUtil(int leftArity, int rightArity) {
        this.leftArity = leftArity;
        this.rightArity = rightArity;
        this.initLeftNullPaddingRow();
        this.initRightNullPaddingRow();
    }

    private void initLeftNullPaddingRow() {
        this.leftNullPaddingRow = new GenericRow(this.leftArity);
        for (int idx = 0; idx < this.leftArity; ++idx) {
            this.leftNullPaddingRow.setNullAt(idx);
        }
    }

    private void initRightNullPaddingRow() {
        this.rightNullPaddingRow = new GenericRow(this.rightArity);
        for (int idx = 0; idx < this.rightArity; ++idx) {
            this.rightNullPaddingRow.setNullAt(idx);
        }
    }

    public final BaseRow padRight(BaseRow rightRow) {
        return this.joinedRow.replace(this.leftNullPaddingRow, rightRow);
    }

    public final BaseRow padLeft(BaseRow leftRow) {
        return this.joinedRow.replace(leftRow, this.rightNullPaddingRow);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.joinedRow = new JoinedRow();
        this.initLeftNullPaddingRow();
        this.initRightNullPaddingRow();
    }
}

