/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream;

import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.operators.join.stream.AbstractStreamingJoinOperator;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateViews;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;

public class StreamingJoinOperator
extends AbstractStreamingJoinOperator {
    private static final long serialVersionUID = -376944622236540545L;
    private final boolean leftIsOuter;
    private final boolean rightIsOuter;
    private transient JoinedRow outRow;
    private transient BaseRow leftNullRow;
    private transient BaseRow rightNullRow;
    private transient JoinRecordStateView leftRecordStateView;
    private transient JoinRecordStateView rightRecordStateView;

    public StreamingJoinOperator(BaseRowTypeInfo leftType, BaseRowTypeInfo rightType, GeneratedJoinCondition generatedJoinCondition, JoinInputSideSpec leftInputSideSpec, JoinInputSideSpec rightInputSideSpec, boolean leftIsOuter, boolean rightIsOuter, boolean[] filterNullKeys, long minRetentionTime) {
        super(leftType, rightType, generatedJoinCondition, leftInputSideSpec, rightInputSideSpec, filterNullKeys, minRetentionTime);
        this.leftIsOuter = leftIsOuter;
        this.rightIsOuter = rightIsOuter;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.outRow = new JoinedRow();
        this.leftNullRow = new GenericRow(this.leftType.getArity());
        this.rightNullRow = new GenericRow(this.rightType.getArity());
        this.leftRecordStateView = this.leftIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.minRetentionTime, this.stateCleaningEnabled) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "left-records", this.leftInputSideSpec, this.leftType, this.minRetentionTime, this.stateCleaningEnabled);
        this.rightRecordStateView = this.rightIsOuter ? OuterJoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.minRetentionTime, this.stateCleaningEnabled) : JoinRecordStateViews.create((RuntimeContext)this.getRuntimeContext(), "right-records", this.rightInputSideSpec, this.rightType, this.minRetentionTime, this.stateCleaningEnabled);
    }

    public void processElement1(StreamRecord<BaseRow> element) throws Exception {
        this.processElement((BaseRow)element.getValue(), this.leftRecordStateView, this.rightRecordStateView, true);
    }

    public void processElement2(StreamRecord<BaseRow> element) throws Exception {
        this.processElement((BaseRow)element.getValue(), this.rightRecordStateView, this.leftRecordStateView, false);
    }

    private void processElement(BaseRow input, JoinRecordStateView inputSideStateView, JoinRecordStateView otherSideStateView, boolean inputIsLeft) throws Exception {
        block16: {
            AbstractStreamingJoinOperator.AssociatedRecords associatedRecords;
            boolean otherIsOuter;
            block17: {
                boolean inputIsOuter;
                block14: {
                    block15: {
                        inputIsOuter = inputIsLeft ? this.leftIsOuter : this.rightIsOuter;
                        otherIsOuter = inputIsLeft ? this.rightIsOuter : this.leftIsOuter;
                        associatedRecords = AbstractStreamingJoinOperator.AssociatedRecords.of(input, inputIsLeft, otherSideStateView, this.joinCondition);
                        if (!BaseRowUtil.isAccumulateMsg(input)) break block14;
                        if (!inputIsOuter) break block15;
                        OuterJoinRecordStateView inputSideOuterStateView = (OuterJoinRecordStateView)inputSideStateView;
                        if (associatedRecords.isEmpty()) {
                            this.outRow.setHeader((byte)0);
                            this.outputNullPadding(input, inputIsLeft);
                            inputSideOuterStateView.addRecord(input, 0);
                        } else {
                            if (otherIsOuter) {
                                OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                                    BaseRow other = outerRecord.record;
                                    if (outerRecord.numOfAssociations == 0) {
                                        this.outRow.setHeader((byte)1);
                                        this.outputNullPadding(other, !inputIsLeft);
                                    }
                                    otherSideOuterStateView.updateNumOfAssociations(other, outerRecord.numOfAssociations + 1);
                                }
                            }
                            this.outRow.setHeader((byte)0);
                            for (BaseRow other : associatedRecords.getRecords()) {
                                this.output(input, other, inputIsLeft);
                            }
                            inputSideOuterStateView.addRecord(input, associatedRecords.size());
                        }
                        break block16;
                    }
                    inputSideStateView.addRecord(input);
                    if (associatedRecords.isEmpty()) break block16;
                    if (otherIsOuter) {
                        OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                        for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                            if (outerRecord.numOfAssociations == 0) {
                                this.outRow.setHeader((byte)1);
                                this.outputNullPadding(outerRecord.record, !inputIsLeft);
                            }
                            otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations + 1);
                        }
                    }
                    this.outRow.setHeader((byte)0);
                    for (BaseRow other : associatedRecords.getRecords()) {
                        this.output(input, other, inputIsLeft);
                    }
                    break block16;
                }
                input.setHeader((byte)0);
                inputSideStateView.retractRecord(input);
                if (!associatedRecords.isEmpty()) break block17;
                if (!inputIsOuter) break block16;
                this.outRow.setHeader((byte)1);
                this.outputNullPadding(input, inputIsLeft);
                break block16;
            }
            this.outRow.setHeader((byte)1);
            for (BaseRow other : associatedRecords.getRecords()) {
                this.output(input, other, inputIsLeft);
            }
            if (otherIsOuter) {
                OuterJoinRecordStateView otherSideOuterStateView = (OuterJoinRecordStateView)otherSideStateView;
                for (AbstractStreamingJoinOperator.OuterRecord outerRecord : associatedRecords.getOuterRecords()) {
                    if (outerRecord.numOfAssociations == 1) {
                        this.outRow.setHeader((byte)0);
                        this.outputNullPadding(outerRecord.record, !inputIsLeft);
                    }
                    otherSideOuterStateView.updateNumOfAssociations(outerRecord.record, outerRecord.numOfAssociations - 1);
                }
            }
        }
    }

    private void output(BaseRow inputRow, BaseRow otherRow, boolean inputIsLeft) {
        if (inputIsLeft) {
            this.outRow.replace(inputRow, otherRow);
        } else {
            this.outRow.replace(otherRow, inputRow);
        }
        this.collector.collect((Object)this.outRow);
    }

    private void outputNullPadding(BaseRow row, boolean isLeft) {
        if (isLeft) {
            this.outRow.replace(row, this.rightNullRow);
        } else {
            this.outRow.replace(this.leftNullRow, row);
        }
        this.collector.collect((Object)this.outRow);
    }
}

