/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.apache.flink.table.dataformat.BaseRow;

class TopNBuffer
implements Serializable {
    private static final long serialVersionUID = 6824488508991990228L;
    private final Supplier<Collection<BaseRow>> valueSupplier;
    private final Comparator<BaseRow> sortKeyComparator;
    private int currentTopNum = 0;
    private TreeMap<BaseRow, Collection<BaseRow>> treeMap;

    TopNBuffer(Comparator<BaseRow> sortKeyComparator, Supplier<Collection<BaseRow>> valueSupplier) {
        this.valueSupplier = valueSupplier;
        this.sortKeyComparator = sortKeyComparator;
        this.treeMap = new TreeMap(sortKeyComparator);
    }

    public int put(BaseRow sortKey, BaseRow value) {
        ++this.currentTopNum;
        Collection<BaseRow> collection = this.treeMap.get(sortKey);
        if (collection == null) {
            collection = this.valueSupplier.get();
            this.treeMap.put(sortKey, collection);
        }
        collection.add(value);
        return collection.size();
    }

    void putAll(BaseRow sortKey, Collection<BaseRow> values) {
        Collection<BaseRow> oldValues = this.treeMap.get(sortKey);
        if (oldValues != null) {
            this.currentTopNum -= oldValues.size();
        }
        this.treeMap.put(sortKey, values);
        this.currentTopNum += values.size();
    }

    public Collection<BaseRow> get(BaseRow sortKey) {
        return this.treeMap.get(sortKey);
    }

    public void remove(BaseRow sortKey, BaseRow value) {
        Collection<BaseRow> list = this.treeMap.get(sortKey);
        if (list != null) {
            if (list.remove(value)) {
                --this.currentTopNum;
            }
            if (list.size() == 0) {
                this.treeMap.remove(sortKey);
            }
        }
    }

    void removeAll(BaseRow sortKey) {
        Collection<BaseRow> list = this.treeMap.get(sortKey);
        if (list != null) {
            this.currentTopNum -= list.size();
            this.treeMap.remove(sortKey);
        }
    }

    BaseRow removeLast() {
        Collection<BaseRow> list;
        Map.Entry<BaseRow, Collection<BaseRow>> last = this.treeMap.lastEntry();
        BaseRow lastElement = null;
        if (last != null && (lastElement = this.getLastElement(list = last.getValue())) != null) {
            if (list.remove(lastElement)) {
                --this.currentTopNum;
            }
            if (list.size() == 0) {
                this.treeMap.remove(last.getKey());
            }
        }
        return lastElement;
    }

    BaseRow getElement(int rank) {
        int curRank = 0;
        for (Map.Entry<BaseRow, Collection<BaseRow>> entry : this.treeMap.entrySet()) {
            Collection<BaseRow> list = entry.getValue();
            if (curRank + list.size() >= rank) {
                for (BaseRow elem : list) {
                    if (++curRank != rank) continue;
                    return elem;
                }
                continue;
            }
            curRank += list.size();
        }
        return null;
    }

    private BaseRow getLastElement(Collection<BaseRow> list) {
        BaseRow element2 = null;
        if (list != null && !list.isEmpty()) {
            for (BaseRow element2 : list) {
            }
        }
        return element2;
    }

    Set<Map.Entry<BaseRow, Collection<BaseRow>>> entrySet() {
        return this.treeMap.entrySet();
    }

    Map.Entry<BaseRow, Collection<BaseRow>> lastEntry() {
        return this.treeMap.lastEntry();
    }

    boolean containsKey(BaseRow key) {
        return this.treeMap.containsKey(key);
    }

    int getCurrentTopNum() {
        return this.currentTopNum;
    }

    Comparator<BaseRow> getSortKeyComparator() {
        return this.sortKeyComparator;
    }
}

