/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.grouping;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.operators.window.grouping.WindowsGrouping;
import org.apache.flink.table.runtime.util.RowIterator;

public class HeapWindowsGrouping
extends WindowsGrouping {
    private LinkedList<BinaryRow> buffer;
    private final int maxSizeLimit;
    private int evictLimitIndex;
    private Iterator<BinaryRow> iterator;

    public HeapWindowsGrouping(int maxSizeLimit, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        this(maxSizeLimit, 0L, windowSize, slideSize, timeIndex, isDate);
    }

    public HeapWindowsGrouping(int maxSizeLimit, long offset, long windowSize, long slideSize, int timeIndex, boolean isDate) {
        super(offset, windowSize, slideSize, timeIndex, isDate);
        this.maxSizeLimit = maxSizeLimit;
        this.evictLimitIndex = 0;
        this.buffer = new LinkedList();
    }

    @Override
    protected void resetBuffer() {
        this.buffer.clear();
        this.evictLimitIndex = 0;
        this.iterator = null;
    }

    @Override
    protected void onBufferEvict(int limitIndex) {
        while (this.evictLimitIndex < limitIndex) {
            this.buffer.removeFirst();
            ++this.evictLimitIndex;
        }
    }

    @Override
    protected void addIntoBuffer(BinaryRow input) throws IOException {
        if (this.buffer.size() >= this.maxSizeLimit) {
            throw new IOException("HeapWindowsGrouping out of memory, element size limit " + this.maxSizeLimit);
        }
        this.buffer.add(input);
    }

    @Override
    protected RowIterator<BinaryRow> newBufferIterator(int startIndex) {
        this.iterator = this.buffer.subList(startIndex - this.evictLimitIndex, this.buffer.size()).iterator();
        return new BufferIterator(this.iterator);
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    private final class BufferIterator
    implements RowIterator<BinaryRow> {
        private final Iterator<BinaryRow> iterator;
        private BinaryRow next;

        BufferIterator(Iterator<BinaryRow> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean advanceNext() {
            if (this.iterator.hasNext()) {
                this.next = this.iterator.next();
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public BinaryRow getRow() {
            return this.next;
        }
    }
}

