/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.CollectionDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.FieldsDataType;
import org.apache.flink.table.types.KeyValueDataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

public final class DataTypePrecisionFixer
implements DataTypeVisitor<DataType> {
    private final LogicalType logicalType;

    public DataTypePrecisionFixer(LogicalType logicalType) {
        this.logicalType = logicalType;
    }

    public DataType visit(AtomicDataType dataType) {
        switch (this.logicalType.getTypeRoot()) {
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)this.logicalType;
                return DataTypes.DECIMAL((int)decimalType.getPrecision(), (int)decimalType.getScale()).bridgedTo(dataType.getConversionClass());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType timestampType = (TimestampType)this.logicalType;
                if (timestampType.getKind() == TimestampKind.REGULAR) {
                    return DataTypes.TIMESTAMP((int)timestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
                }
                return dataType;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)this.logicalType;
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)localZonedTimestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                ZonedTimestampType zonedTimestampType = (ZonedTimestampType)this.logicalType;
                return DataTypes.TIMESTAMP_WITH_TIME_ZONE((int)zonedTimestampType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
            case TIME_WITHOUT_TIME_ZONE: {
                TimeType timeType = (TimeType)this.logicalType;
                return DataTypes.TIME((int)timeType.getPrecision()).bridgedTo(dataType.getConversionClass());
            }
        }
        return dataType;
    }

    public DataType visit(CollectionDataType collectionDataType) {
        DataType elementType = collectionDataType.getElementDataType();
        switch (this.logicalType.getTypeRoot()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)this.logicalType;
                DataType newArrayElementType = (DataType)elementType.accept((DataTypeVisitor)new DataTypePrecisionFixer(arrayType.getElementType()));
                return DataTypes.ARRAY((DataType)newArrayElementType).bridgedTo(collectionDataType.getConversionClass());
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)this.logicalType;
                DataType newMultisetElementType = (DataType)elementType.accept((DataTypeVisitor)new DataTypePrecisionFixer(multisetType.getElementType()));
                return DataTypes.MULTISET((DataType)newMultisetElementType).bridgedTo(collectionDataType.getConversionClass());
            }
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }

    public DataType visit(FieldsDataType fieldsDataType) {
        Map fieldDataTypes = fieldsDataType.getFieldDataTypes();
        if (this.logicalType.getTypeRoot() == LogicalTypeRoot.ROW) {
            RowType rowType = (RowType)this.logicalType;
            DataTypes.Field[] fields = (DataTypes.Field[])rowType.getFields().stream().map(f -> {
                DataType fieldType = (DataType)fieldDataTypes.get(f.getName());
                DataType newFieldType = null;
                try {
                    newFieldType = (DataType)fieldType.accept((DataTypeVisitor)new DataTypePrecisionFixer(f.getType()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return DataTypes.FIELD((String)f.getName(), newFieldType);
            }).toArray(DataTypes.Field[]::new);
            return DataTypes.ROW((DataTypes.Field[])fields).bridgedTo(fieldsDataType.getConversionClass());
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }

    public DataType visit(KeyValueDataType keyValueDataType) {
        DataType keyType = keyValueDataType.getKeyDataType();
        DataType valueType = keyValueDataType.getValueDataType();
        if (this.logicalType.getTypeRoot() == LogicalTypeRoot.MAP) {
            MapType mapType = (MapType)this.logicalType;
            DataType newKeyType = (DataType)keyType.accept((DataTypeVisitor)new DataTypePrecisionFixer(mapType.getKeyType()));
            DataType newValueType = (DataType)valueType.accept((DataTypeVisitor)new DataTypePrecisionFixer(mapType.getValueType()));
            return DataTypes.MAP((DataType)newKeyType, (DataType)newValueType).bridgedTo(keyValueDataType.getConversionClass());
        }
        throw new UnsupportedOperationException("Unsupported logical type : " + this.logicalType);
    }
}

