/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.runtime.util.SegmentsUtil;

@Internal
public final class BinaryGenericSerializer<T>
extends TypeSerializer<BinaryGeneric<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    public BinaryGenericSerializer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public BinaryGeneric<T> createInstance() {
        return new BinaryGeneric<Object>(this.serializer.createInstance());
    }

    public BinaryGeneric<T> copy(BinaryGeneric<T> from) {
        from.ensureMaterialized(this.serializer);
        byte[] bytes = SegmentsUtil.copyToBytes(from.getSegments(), from.getOffset(), from.getSizeInBytes());
        Object newJavaObject = from.getJavaObject() == null ? null : this.serializer.copy(from.getJavaObject());
        return new BinaryGeneric<Object>(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length, newJavaObject);
    }

    public BinaryGeneric<T> copy(BinaryGeneric<T> from, BinaryGeneric<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryGeneric<T> record, DataOutputView target) throws IOException {
        record.ensureMaterialized(this.serializer);
        target.writeInt(record.getSizeInBytes());
        SegmentsUtil.copyToView(record.getSegments(), record.getOffset(), record.getSizeInBytes(), target);
    }

    public BinaryGeneric<T> deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return new BinaryGeneric(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
    }

    public BinaryGeneric<T> deserialize(BinaryGeneric<T> record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public BinaryGenericSerializer<T> duplicate() {
        return new BinaryGenericSerializer<T>(this.serializer.duplicate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BinaryGenericSerializer that = (BinaryGenericSerializer)((Object)o);
        return this.serializer.equals(that.serializer);
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    public TypeSerializerSnapshot<BinaryGeneric<T>> snapshotConfiguration() {
        return new BinaryGenericSerializerSnapshot(this);
    }

    public TypeSerializer<T> getInnerSerializer() {
        return this.serializer;
    }

    public static final class BinaryGenericSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<BinaryGeneric<T>, BinaryGenericSerializer<T>> {
        public BinaryGenericSerializerSnapshot() {
            super(BinaryGenericSerializer.class);
        }

        public BinaryGenericSerializerSnapshot(BinaryGenericSerializer<T> serializerInstance) {
            super(serializerInstance);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 0;
        }

        protected TypeSerializer<?>[] getNestedSerializers(BinaryGenericSerializer<T> outerSerializer) {
            return new TypeSerializer[]{((BinaryGenericSerializer)outerSerializer).serializer};
        }

        protected BinaryGenericSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new BinaryGenericSerializer(nestedSerializers[0]);
        }
    }
}

