/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.runtime.util.SegmentsUtil;

@Internal
public final class BinaryStringSerializer
extends TypeSerializerSingleton<BinaryString> {
    private static final long serialVersionUID = 1L;
    public static final BinaryStringSerializer INSTANCE = new BinaryStringSerializer();

    private BinaryStringSerializer() {
    }

    public boolean isImmutableType() {
        return true;
    }

    public BinaryString createInstance() {
        return BinaryString.fromString("");
    }

    public BinaryString copy(BinaryString from) {
        return from.copy();
    }

    public BinaryString copy(BinaryString from, BinaryString reuse) {
        return from.copy();
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BinaryString record, DataOutputView target) throws IOException {
        record.ensureMaterialized();
        target.writeInt(record.getSizeInBytes());
        SegmentsUtil.copyToView(record.getSegments(), record.getOffset(), record.getSizeInBytes(), target);
    }

    public BinaryString deserialize(DataInputView source) throws IOException {
        return BinaryStringSerializer.deserializeInternal(source);
    }

    public static BinaryString deserializeInternal(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return BinaryString.fromBytes(bytes);
    }

    public BinaryString deserialize(BinaryString record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public TypeSerializerSnapshot<BinaryString> snapshotConfiguration() {
        return new BinaryStringSerializerSnapshot();
    }

    public static final class BinaryStringSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<BinaryString> {
        public BinaryStringSerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

