/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketState;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedPartFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.SimpleVersionedStringSerializer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class FileWriterBucketStateSerializer
implements SimpleVersionedSerializer<FileWriterBucketState> {
    private static final int MAGIC_NUMBER = 511069049;
    private final SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileRecoverableSerializer;
    private final SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileRecoverableSerializer;

    public FileWriterBucketStateSerializer(SimpleVersionedSerializer<InProgressFileWriter.InProgressFileRecoverable> inProgressFileRecoverableSerializer, SimpleVersionedSerializer<InProgressFileWriter.PendingFileRecoverable> pendingFileRecoverableSerializer) {
        this.inProgressFileRecoverableSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(inProgressFileRecoverableSerializer);
        this.pendingFileRecoverableSerializer = (SimpleVersionedSerializer)Preconditions.checkNotNull(pendingFileRecoverableSerializer);
    }

    public int getVersion() {
        return 3;
    }

    public byte[] serialize(FileWriterBucketState state) throws IOException {
        DataOutputSerializer out = new DataOutputSerializer(256);
        out.writeInt(511069049);
        this.serializeV3(state, (DataOutputView)out);
        return out.getCopyOfBuffer();
    }

    public FileWriterBucketState deserialize(int version, byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        switch (version) {
            case 1: {
                this.validateMagicNumber((DataInputView)in);
                return this.deserializeV1((DataInputView)in);
            }
            case 2: {
                this.validateMagicNumber((DataInputView)in);
                return this.deserializeV2((DataInputView)in);
            }
            case 3: {
                this.validateMagicNumber((DataInputView)in);
                return this.deserializeV3((DataInputView)in);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private void serializeV3(FileWriterBucketState state, DataOutputView dataOutputView) throws IOException {
        SimpleVersionedSerialization.writeVersionAndSerialize((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE, (Object)state.getBucketId(), (DataOutputView)dataOutputView);
        dataOutputView.writeUTF(state.getBucketPath().toString());
        dataOutputView.writeLong(state.getInProgressFileCreationTime());
        if (state.hasInProgressFileRecoverable()) {
            InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable = state.getInProgressFileRecoverable();
            dataOutputView.writeBoolean(true);
            SimpleVersionedSerialization.writeVersionAndSerialize(this.inProgressFileRecoverableSerializer, (Object)inProgressFileRecoverable, (DataOutputView)dataOutputView);
        } else {
            dataOutputView.writeBoolean(false);
        }
    }

    private FileWriterBucketState deserializeV1(DataInputView in) throws IOException {
        SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> commitableSerializer = this.getCommitableSerializer();
        SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> resumableSerializer = this.getResumableSerializer();
        return this.internalDeserialize(in, (FunctionWithException<DataInputView, InProgressFileWriter.InProgressFileRecoverable, IOException>)((FunctionWithException)dataInputView -> new OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverable((RecoverableWriter.ResumeRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)resumableSerializer, (DataInputView)dataInputView))), (BiFunctionWithException<Integer, byte[], InProgressFileWriter.PendingFileRecoverable, IOException>)((BiFunctionWithException)(version, bytes) -> new OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverable((RecoverableWriter.CommitRecoverable)commitableSerializer.deserialize(version.intValue(), bytes))));
    }

    private FileWriterBucketState deserializeV2(DataInputView in) throws IOException {
        return this.internalDeserialize(in, (FunctionWithException<DataInputView, InProgressFileWriter.InProgressFileRecoverable, IOException>)((FunctionWithException)dataInputView -> (InProgressFileWriter.InProgressFileRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.inProgressFileRecoverableSerializer, (DataInputView)dataInputView)), (BiFunctionWithException<Integer, byte[], InProgressFileWriter.PendingFileRecoverable, IOException>)((BiFunctionWithException)(arg_0, arg_1) -> this.pendingFileRecoverableSerializer.deserialize(arg_0, arg_1)));
    }

    private FileWriterBucketState deserializeV3(DataInputView in) throws IOException {
        return this.internalDeserialize(in, (FunctionWithException<DataInputView, InProgressFileWriter.InProgressFileRecoverable, IOException>)((FunctionWithException)dataInputView -> (InProgressFileWriter.InProgressFileRecoverable)SimpleVersionedSerialization.readVersionAndDeSerialize(this.inProgressFileRecoverableSerializer, (DataInputView)dataInputView)), null);
    }

    private FileWriterBucketState internalDeserialize(DataInputView dataInputView, FunctionWithException<DataInputView, InProgressFileWriter.InProgressFileRecoverable, IOException> inProgressFileParser, @Nullable BiFunctionWithException<Integer, byte[], InProgressFileWriter.PendingFileRecoverable, IOException> pendingFileParser) throws IOException {
        String bucketId = (String)SimpleVersionedSerialization.readVersionAndDeSerialize((SimpleVersionedSerializer)SimpleVersionedStringSerializer.INSTANCE, (DataInputView)dataInputView);
        String bucketPathStr = dataInputView.readUTF();
        long creationTime = dataInputView.readLong();
        InProgressFileWriter.InProgressFileRecoverable current = null;
        if (dataInputView.readBoolean()) {
            current = (InProgressFileWriter.InProgressFileRecoverable)inProgressFileParser.apply((Object)dataInputView);
        }
        HashMap<Long, List<InProgressFileWriter.PendingFileRecoverable>> pendingFileRecoverablesPerCheckpoint = new HashMap<Long, List<InProgressFileWriter.PendingFileRecoverable>>();
        if (pendingFileParser != null) {
            int pendingFileRecoverableSerializerVersion = dataInputView.readInt();
            int numCheckpoints = dataInputView.readInt();
            for (int i = 0; i < numCheckpoints; ++i) {
                long checkpointId = dataInputView.readLong();
                int numOfPendingFileRecoverables = dataInputView.readInt();
                ArrayList<Object> pendingFileRecoverables = new ArrayList<Object>(numOfPendingFileRecoverables);
                for (int j2 = 0; j2 < numOfPendingFileRecoverables; ++j2) {
                    byte[] bytes = new byte[dataInputView.readInt()];
                    dataInputView.readFully(bytes);
                    pendingFileRecoverables.add(pendingFileParser.apply((Object)pendingFileRecoverableSerializerVersion, (Object)bytes));
                }
                pendingFileRecoverablesPerCheckpoint.put(checkpointId, pendingFileRecoverables);
            }
        }
        return new FileWriterBucketState(bucketId, new Path(bucketPathStr), creationTime, current, pendingFileRecoverablesPerCheckpoint);
    }

    private void validateMagicNumber(DataInputView in) throws IOException {
        int magicNumber = in.readInt();
        if (magicNumber != 511069049) {
            throw new IOException(String.format("Corrupt data: Unexpected magic number %08X", magicNumber));
        }
    }

    private SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumableSerializer() {
        OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer outputStreamBasedInProgressFileRecoverableSerializer = (OutputStreamBasedPartFileWriter.OutputStreamBasedInProgressFileRecoverableSerializer)this.inProgressFileRecoverableSerializer;
        return outputStreamBasedInProgressFileRecoverableSerializer.getResumeSerializer();
    }

    private SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitableSerializer() {
        OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer outputStreamBasedPendingFileRecoverableSerializer = (OutputStreamBasedPartFileWriter.OutputStreamBasedPendingFileRecoverableSerializer)this.pendingFileRecoverableSerializer;
        return outputStreamBasedPendingFileRecoverableSerializer.getCommitSerializer();
    }
}

