/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.src;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FileSourceSplitSerializer
implements SimpleVersionedSerializer<FileSourceSplit> {
    public static final FileSourceSplitSerializer INSTANCE = new FileSourceSplitSerializer();
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private static final int VERSION = 1;

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(FileSourceSplit split2) throws IOException {
        Preconditions.checkArgument((split2.getClass() == FileSourceSplit.class ? 1 : 0) != 0, (Object)"Cannot serialize subclasses of FileSourceSplit");
        if (split2.serializedFormCache != null) {
            return split2.serializedFormCache;
        }
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeUTF(split2.splitId());
        split2.path().write((DataOutputView)out);
        out.writeLong(split2.offset());
        out.writeLong(split2.length());
        FileSourceSplitSerializer.writeStringArray((DataOutputView)out, split2.hostnames());
        Optional<CheckpointedPosition> readerPosition = split2.getReaderPosition();
        out.writeBoolean(readerPosition.isPresent());
        if (readerPosition.isPresent()) {
            out.writeLong(readerPosition.get().getOffset());
            out.writeLong(readerPosition.get().getRecordsAfterOffset());
        }
        byte[] result = out.getCopyOfBuffer();
        out.clear();
        split2.serializedFormCache = result;
        return result;
    }

    public FileSourceSplit deserialize(int version, byte[] serialized) throws IOException {
        if (version == 1) {
            return FileSourceSplitSerializer.deserializeV1(serialized);
        }
        throw new IOException("Unknown version: " + version);
    }

    private static FileSourceSplit deserializeV1(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        String id = in.readUTF();
        Path path = new Path();
        path.read((DataInputView)in);
        long offset = in.readLong();
        long len = in.readLong();
        String[] hosts = FileSourceSplitSerializer.readStringArray((DataInputView)in);
        CheckpointedPosition readerPosition = in.readBoolean() ? new CheckpointedPosition(in.readLong(), in.readLong()) : null;
        return new FileSourceSplit(id, path, offset, len, hosts, readerPosition, serialized);
    }

    private static void writeStringArray(DataOutputView out, String[] strings) throws IOException {
        out.writeInt(strings.length);
        for (String string : strings) {
            out.writeUTF(string);
        }
    }

    private static String[] readStringArray(DataInputView in) throws IOException {
        int len = in.readInt();
        String[] strings = new String[len];
        for (int i = 0; i < len; ++i) {
            strings[i] = in.readUTF();
        }
        return strings;
    }
}

