/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.PlannerTypeInferenceUtil;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionIdentifier;

@Internal
public interface FunctionLookup {
    public Optional<Result> lookupFunction(String var1);

    public Optional<Result> lookupFunction(UnresolvedIdentifier var1);

    default public Result lookupBuiltInFunction(BuiltInFunctionDefinition definition) {
        return this.lookupFunction(UnresolvedIdentifier.of(definition.getName())).orElseThrow(() -> new TableException(String.format("Required built-in function [%s] could not be found in any catalog.", definition.getName())));
    }

    public PlannerTypeInferenceUtil getPlannerTypeInferenceUtil();

    public static final class Result {
        private final FunctionIdentifier functionIdentifier;
        private final FunctionDefinition functionDefinition;

        public Result(FunctionIdentifier functionIdentifier, FunctionDefinition functionDefinition) {
            this.functionIdentifier = functionIdentifier;
            this.functionDefinition = functionDefinition;
        }

        public FunctionIdentifier getFunctionIdentifier() {
            return this.functionIdentifier;
        }

        public FunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.functionIdentifier.equals(result.functionIdentifier) && this.functionDefinition.equals(result.functionDefinition);
        }

        public int hashCode() {
            return Objects.hash(this.functionIdentifier, this.functionDefinition);
        }
    }
}

