/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.types.logical.DecimalType;

public final class DecimalDataUtils {
    private static final MathContext MC_DIVIDE = new MathContext(38, RoundingMode.HALF_UP);
    public static final DecimalType DECIMAL_SYSTEM_DEFAULT = new DecimalType(38, 18);

    public static double doubleValue(DecimalData decimal) {
        if (decimal.isCompact()) {
            return (double)decimal.longVal / (double)DecimalData.POW10[decimal.scale];
        }
        return decimal.decimalVal.doubleValue();
    }

    public static int signum(DecimalData decimal) {
        if (decimal.isCompact()) {
            return Long.signum(decimal.toUnscaledLong());
        }
        return decimal.toBigDecimal().signum();
    }

    public static DecimalData negate(DecimalData decimal) {
        if (decimal.isCompact()) {
            return new DecimalData(decimal.precision, decimal.scale, -decimal.longVal, null);
        }
        return new DecimalData(decimal.precision, decimal.scale, -1L, decimal.decimalVal.negate());
    }

    public static DecimalData abs(DecimalData decimal) {
        if (decimal.isCompact()) {
            if (decimal.longVal >= 0L) {
                return decimal;
            }
            return new DecimalData(decimal.precision, decimal.scale, -decimal.longVal, null);
        }
        if (decimal.decimalVal.signum() >= 0) {
            return decimal;
        }
        return new DecimalData(decimal.precision, decimal.scale, -1L, decimal.decimalVal.negate());
    }

    public static DecimalData floor(DecimalData decimal) {
        BigDecimal bd = decimal.toBigDecimal().setScale(0, RoundingMode.FLOOR);
        return DecimalData.fromBigDecimal(bd, bd.precision(), 0);
    }

    public static DecimalData ceil(DecimalData decimal) {
        BigDecimal bd = decimal.toBigDecimal().setScale(0, RoundingMode.CEILING);
        return DecimalData.fromBigDecimal(bd, bd.precision(), 0);
    }

    public static DecimalData add(DecimalData v1, DecimalData v2, int precision, int scale) {
        if (v1.isCompact() && v2.isCompact() && v1.scale == v2.scale) {
            assert (scale == v1.scale);
            try {
                long ls = Math.addExact(v1.longVal, v2.longVal);
                return new DecimalData(precision, scale, ls, null);
            }
            catch (ArithmeticException ls) {
                // empty catch block
            }
        }
        BigDecimal bd = v1.toBigDecimal().add(v2.toBigDecimal());
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static DecimalData subtract(DecimalData v1, DecimalData v2, int precision, int scale) {
        if (v1.isCompact() && v2.isCompact() && v1.scale == v2.scale) {
            assert (scale == v1.scale);
            try {
                long ls = Math.subtractExact(v1.longVal, v2.longVal);
                return new DecimalData(precision, scale, ls, null);
            }
            catch (ArithmeticException ls) {
                // empty catch block
            }
        }
        BigDecimal bd = v1.toBigDecimal().subtract(v2.toBigDecimal());
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static DecimalData multiply(DecimalData v1, DecimalData v2, int precision, int scale) {
        BigDecimal bd = v1.toBigDecimal().multiply(v2.toBigDecimal());
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static DecimalData divide(DecimalData v1, DecimalData v2, int precision, int scale) {
        BigDecimal bd = v1.toBigDecimal().divide(v2.toBigDecimal(), MC_DIVIDE);
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static DecimalData mod(DecimalData v1, DecimalData v2, int precision, int scale) {
        BigDecimal bd = v1.toBigDecimal().remainder(v2.toBigDecimal(), MC_DIVIDE);
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static DecimalData divideToIntegralValue(DecimalData value, DecimalData divisor, int precision, int scale) {
        BigDecimal bd = value.toBigDecimal().divideToIntegralValue(divisor.toBigDecimal());
        return DecimalData.fromBigDecimal(bd, precision, scale);
    }

    public static long castToIntegral(DecimalData dec) {
        BigDecimal bd = dec.toBigDecimal();
        bd = bd.setScale(0, RoundingMode.DOWN);
        return bd.longValue();
    }

    public static long castToLong(DecimalData dec) {
        return DecimalDataUtils.castToIntegral(dec);
    }

    public static int castToInt(DecimalData dec) {
        return (int)DecimalDataUtils.castToIntegral(dec);
    }

    public static short castToShort(DecimalData dec) {
        return (short)DecimalDataUtils.castToIntegral(dec);
    }

    public static byte castToByte(DecimalData dec) {
        return (byte)DecimalDataUtils.castToIntegral(dec);
    }

    public static float castToFloat(DecimalData dec) {
        return (float)DecimalDataUtils.doubleValue(dec);
    }

    public static double castToDouble(DecimalData dec) {
        return DecimalDataUtils.doubleValue(dec);
    }

    public static DecimalData castToDecimal(DecimalData dec, int precision, int scale) {
        return DecimalData.fromBigDecimal(dec.toBigDecimal(), precision, scale);
    }

    public static boolean castToBoolean(DecimalData dec) {
        return dec.toBigDecimal().compareTo(BigDecimal.ZERO) != 0;
    }

    public static long castToTimestamp(DecimalData dec) {
        return (long)(DecimalDataUtils.doubleValue(dec) * 1000.0);
    }

    public static DecimalData castFrom(DecimalData dec, int precision, int scale) {
        return DecimalData.fromBigDecimal(dec.toBigDecimal(), precision, scale);
    }

    public static DecimalData castFrom(String string, int precision, int scale) {
        return DecimalData.fromBigDecimal(new BigDecimal(string), precision, scale);
    }

    public static DecimalData castFrom(double val, int p, int s) {
        return DecimalData.fromBigDecimal(BigDecimal.valueOf(val), p, s);
    }

    public static DecimalData castFrom(long val, int p, int s) {
        return DecimalData.fromBigDecimal(BigDecimal.valueOf(val), p, s);
    }

    public static DecimalData castFrom(boolean val, int p, int s) {
        return DecimalData.fromBigDecimal(BigDecimal.valueOf(val ? 1 : 0), p, s);
    }

    public static DecimalData sign(DecimalData b0) {
        if (b0.isCompact()) {
            return new DecimalData(b0.precision, b0.scale, (long)DecimalDataUtils.signum(b0) * DecimalData.POW10[b0.scale], null);
        }
        return DecimalData.fromBigDecimal(BigDecimal.valueOf(DecimalDataUtils.signum(b0)), b0.precision, b0.scale);
    }

    public static int compare(DecimalData b1, DecimalData b2) {
        return b1.compareTo(b2);
    }

    public static int compare(DecimalData b1, long n2) {
        if (!b1.isCompact()) {
            return b1.decimalVal.compareTo(BigDecimal.valueOf(n2));
        }
        if (b1.scale == 0) {
            return Long.compare(b1.longVal, n2);
        }
        long i1 = b1.longVal / DecimalData.POW10[b1.scale];
        if (i1 == n2) {
            long l2 = n2 * DecimalData.POW10[b1.scale];
            return Long.compare(b1.longVal, l2);
        }
        return i1 > n2 ? 1 : -1;
    }

    public static int compare(DecimalData b1, double n2) {
        return Double.compare(DecimalDataUtils.doubleValue(b1), n2);
    }

    public static int compare(long n1, DecimalData b2) {
        return -DecimalDataUtils.compare(b2, n1);
    }

    public static int compare(double n1, DecimalData b2) {
        return -DecimalDataUtils.compare(b2, n1);
    }

    public static DecimalData sround(DecimalData b0, int r) {
        if (r >= b0.scale) {
            return b0;
        }
        BigDecimal b2 = b0.toBigDecimal().movePointRight(r).setScale(0, RoundingMode.HALF_UP).movePointLeft(r);
        int p = b0.precision;
        int s = b0.scale;
        if (r < 0) {
            return DecimalData.fromBigDecimal(b2, Math.min(38, 1 + p - s), 0);
        }
        return DecimalData.fromBigDecimal(b2, 1 + p - s + r, r);
    }

    public static long power10(int n) {
        return DecimalData.POW10[n];
    }

    public static boolean is32BitDecimal(int precision) {
        return precision <= 9;
    }

    public static boolean is64BitDecimal(int precision) {
        return precision <= 18 && precision > 9;
    }

    public static boolean isByteArrayDecimal(int precision) {
        return precision > 18;
    }
}

