/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.conversion;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.TypeInformationRawType;

@Internal
public class RawByteArrayConverter<T>
implements DataStructureConverter<RawValueData<T>, byte[]> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    private RawByteArrayConverter(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    @Override
    public RawValueData<T> toInternal(byte[] external) {
        return RawValueData.fromBytes(external);
    }

    @Override
    public byte[] toExternal(RawValueData<T> internal) {
        return internal.toBytes(this.serializer);
    }

    public static RawByteArrayConverter<?> create(DataType dataType2) {
        LogicalType logicalType = dataType2.getLogicalType();
        TypeSerializer serializer = logicalType instanceof TypeInformationRawType ? ((TypeInformationRawType)logicalType).getTypeInformation().createSerializer(new ExecutionConfig()) : ((RawType)dataType2.getLogicalType()).getTypeSerializer();
        return new RawByteArrayConverter(serializer);
    }
}

