/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector.heap;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.table.data.vector.heap.HeapIntVector;
import org.apache.flink.table.data.vector.writable.AbstractWritableVector;
import sun.misc.Unsafe;

public abstract class AbstractHeapVector
extends AbstractWritableVector {
    public static final boolean LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    public static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    public static final int BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    public static final int INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
    public static final int LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
    public static final int FLOAT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
    public static final int DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
    protected boolean[] isNull;
    protected HeapIntVector dictionaryIds;

    public AbstractHeapVector(int len) {
        this.isNull = new boolean[len];
    }

    @Override
    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
    }

    @Override
    public void setNullAt(int i) {
        this.isNull[i] = true;
        this.noNulls = false;
    }

    @Override
    public void setNulls(int i, int count) {
        for (int j2 = 0; j2 < count; ++j2) {
            this.isNull[i + j2] = true;
        }
        if (count > 0) {
            this.noNulls = false;
        }
    }

    @Override
    public void fillWithNulls() {
        this.noNulls = false;
        Arrays.fill(this.isNull, true);
    }

    @Override
    public boolean isNullAt(int i) {
        return !this.noNulls && this.isNull[i];
    }

    @Override
    public HeapIntVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = new HeapIntVector(capacity);
        } else if (capacity > this.dictionaryIds.vector.length) {
            int current;
            for (current = this.dictionaryIds.vector.length; current < capacity; current <<= 1) {
            }
            this.dictionaryIds = new HeapIntVector(current);
        } else {
            this.dictionaryIds.reset();
        }
        return this.dictionaryIds;
    }

    @Override
    public HeapIntVector getDictionaryIds() {
        return this.dictionaryIds;
    }
}

