/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryService;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;

public class TableFactoryUtil {
    public static <T> TableSource<T> findAndCreateTableSource(TableSourceFactory.Context context) {
        try {
            return TableFactoryService.find(TableSourceFactory.class, context.getTable().toProperties()).createTableSource(context);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSource failed.", t);
        }
    }

    public static <T> TableSource<T> findAndCreateTableSource(Catalog catalog, ObjectIdentifier objectIdentifier, CatalogTable catalogTable, ReadableConfig configuration, boolean isTemporary) {
        TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(objectIdentifier, catalogTable, configuration, isTemporary);
        Optional<TableFactory> factoryOptional = catalog.getTableFactory();
        if (factoryOptional.isPresent()) {
            TableFactory factory = factoryOptional.get();
            if (factory instanceof TableSourceFactory) {
                return ((TableSourceFactory)factory).createTableSource(context);
            }
            throw new ValidationException("Cannot query a sink-only table. TableFactory provided by catalog must implement TableSourceFactory");
        }
        return TableFactoryUtil.findAndCreateTableSource(context);
    }

    public static <T> TableSink<T> findAndCreateTableSink(TableSinkFactory.Context context) {
        try {
            return TableFactoryService.find(TableSinkFactory.class, context.getTable().toProperties()).createTableSink(context);
        }
        catch (Throwable t) {
            throw new TableException("findAndCreateTableSink failed.", t);
        }
    }

    public static <T> TableSink<T> findAndCreateTableSink(@Nullable Catalog catalog, ObjectIdentifier objectIdentifier, CatalogTable catalogTable, ReadableConfig configuration, boolean isStreamingMode, boolean isTemporary) {
        TableSinkFactoryContextImpl context = new TableSinkFactoryContextImpl(objectIdentifier, catalogTable, configuration, !isStreamingMode, isTemporary);
        if (catalog == null) {
            return TableFactoryUtil.findAndCreateTableSink(context);
        }
        return TableFactoryUtil.createTableSinkForCatalogTable(catalog, context).orElseGet(() -> TableFactoryUtil.findAndCreateTableSink(context));
    }

    public static Optional<TableSink> createTableSinkForCatalogTable(Catalog catalog, TableSinkFactory.Context context) {
        TableFactory tableFactory = catalog.getTableFactory().orElse(null);
        if (tableFactory instanceof TableSinkFactory) {
            return Optional.ofNullable(((TableSinkFactory)tableFactory).createTableSink(context));
        }
        return Optional.empty();
    }
}

