/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories.datagen;

import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.functions.source.datagen.DataGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.RandomGenerator;
import org.apache.flink.streaming.api.functions.source.datagen.SequenceGenerator;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.factories.datagen.DataGenVisitorBase;
import org.apache.flink.table.factories.datagen.DataGeneratorContainer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarCharType;

@Internal
public class SequenceGeneratorVisitor
extends DataGenVisitorBase {
    private final ReadableConfig config;
    private final String startKeyStr;
    private final String endKeyStr;
    private final ConfigOption<Integer> intStart;
    private final ConfigOption<Integer> intEnd;
    private final ConfigOption<Long> longStart;
    private final ConfigOption<Long> longEnd;

    public SequenceGeneratorVisitor(String name, ReadableConfig config) {
        super(name, config);
        this.config = config;
        this.startKeyStr = "fields." + name + "." + "start";
        this.endKeyStr = "fields." + name + "." + "end";
        ConfigOptions.OptionBuilder startKey = ConfigOptions.key((String)this.startKeyStr);
        ConfigOptions.OptionBuilder endKey = ConfigOptions.key((String)this.endKeyStr);
        config.getOptional(startKey.stringType().noDefaultValue()).orElseThrow(() -> new ValidationException("Could not find required property '" + this.startKeyStr + "' for sequence generator."));
        config.getOptional(endKey.stringType().noDefaultValue()).orElseThrow(() -> new ValidationException("Could not find required property '" + this.endKeyStr + "' for sequence generator."));
        this.intStart = startKey.intType().noDefaultValue();
        this.intEnd = endKey.intType().noDefaultValue();
        this.longStart = startKey.longType().noDefaultValue();
        this.longEnd = endKey.longType().noDefaultValue();
    }

    @Override
    public DataGeneratorContainer visit(BooleanType booleanType) {
        return DataGeneratorContainer.of((DataGenerator)RandomGenerator.booleanGenerator(), new ConfigOption[0]);
    }

    @Override
    public DataGeneratorContainer visit(CharType booleanType) {
        return DataGeneratorContainer.of(SequenceGeneratorVisitor.getSequenceStringGenerator((Long)this.config.get(this.longStart), (Long)this.config.get(this.longEnd)), new ConfigOption[]{this.longStart, this.longEnd});
    }

    @Override
    public DataGeneratorContainer visit(VarCharType booleanType) {
        return DataGeneratorContainer.of(SequenceGeneratorVisitor.getSequenceStringGenerator((Long)this.config.get(this.longStart), (Long)this.config.get(this.longEnd)), new ConfigOption[]{this.longStart, this.longEnd});
    }

    @Override
    public DataGeneratorContainer visit(TinyIntType booleanType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.byteGenerator((byte)((Integer)this.config.get(this.intStart)).byteValue(), (byte)((Integer)this.config.get(this.intEnd)).byteValue()), this.intStart, this.intEnd);
    }

    @Override
    public DataGeneratorContainer visit(SmallIntType booleanType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.shortGenerator((short)((Integer)this.config.get(this.intStart)).shortValue(), (short)((Integer)this.config.get(this.intEnd)).shortValue()), this.intStart, this.intEnd);
    }

    @Override
    public DataGeneratorContainer visit(IntType integerType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.intGenerator((int)((Integer)this.config.get(this.intStart)), (int)((Integer)this.config.get(this.intEnd))), this.intStart, this.intEnd);
    }

    @Override
    public DataGeneratorContainer visit(BigIntType bigIntType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.longGenerator((long)((Long)this.config.get(this.longStart)), (long)((Long)this.config.get(this.longEnd))), this.longStart, this.longEnd);
    }

    @Override
    public DataGeneratorContainer visit(FloatType floatType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.floatGenerator((short)((Integer)this.config.get(this.intStart)).shortValue(), (short)((Integer)this.config.get(this.intEnd)).shortValue()), this.intStart, this.intEnd);
    }

    @Override
    public DataGeneratorContainer visit(DoubleType doubleType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.doubleGenerator((int)((Integer)this.config.get(this.intStart)), (int)((Integer)this.config.get(this.intEnd))), this.intStart, this.intEnd);
    }

    @Override
    public DataGeneratorContainer visit(DecimalType decimalType) {
        return DataGeneratorContainer.of((DataGenerator)SequenceGenerator.bigDecimalGenerator((int)((Integer)this.config.get(this.intStart)), (int)((Integer)this.config.get(this.intEnd)), (int)decimalType.getPrecision(), (int)decimalType.getScale()), this.intStart, this.intEnd);
    }

    private static SequenceGenerator<StringData> getSequenceStringGenerator(long start, long end) {
        return new SequenceGenerator<StringData>(start, end){

            public StringData next() {
                return StringData.fromString(((Long)this.valuesToEmit.poll()).toString());
            }
        };
    }
}

