/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.table.filesystem.PartitionTempFileManager;
import org.apache.flink.table.filesystem.PartitionWriter;
import org.apache.flink.table.utils.PartitionPathUtils;

@Internal
public class DynamicPartitionWriter<T>
implements PartitionWriter<T> {
    private final PartitionWriter.Context<T> context;
    private final PartitionTempFileManager manager;
    private final PartitionComputer<T> computer;
    private final Map<String, OutputFormat<T>> formats;

    public DynamicPartitionWriter(PartitionWriter.Context<T> context, PartitionTempFileManager manager, PartitionComputer<T> computer) {
        this.context = context;
        this.manager = manager;
        this.computer = computer;
        this.formats = new HashMap<String, OutputFormat<T>>();
    }

    @Override
    public void write(T in) throws Exception {
        String partition2 = PartitionPathUtils.generatePartitionPath(this.computer.generatePartValues(in));
        OutputFormat<T> format = this.formats.get(partition2);
        if (format == null) {
            format = this.context.createNewOutputFormat(this.manager.createPartitionDir(partition2));
            this.formats.put(partition2, format);
        }
        format.writeRecord(this.computer.projectColumnsToWrite(in));
    }

    @Override
    public void close() throws Exception {
        for (OutputFormat<T> format : this.formats.values()) {
            format.close();
        }
        this.formats.clear();
    }
}

