/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.formats.raw;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.HeapMemorySegment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RawType;

@Internal
public class RawFormatSerializationSchema
implements SerializationSchema<RowData> {
    private static final long serialVersionUID = 1L;
    private final LogicalType serializedType;
    private final SerializationRuntimeConverter converter;
    private final String charsetName;
    private final boolean isBigEndian;

    public RawFormatSerializationSchema(LogicalType serializedType, String charsetName, boolean isBigEndian) {
        this.serializedType = serializedType;
        this.converter = this.createConverter(serializedType, charsetName, isBigEndian);
        this.charsetName = charsetName;
        this.isBigEndian = isBigEndian;
    }

    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.converter.open();
    }

    public byte[] serialize(RowData row) {
        try {
            return this.converter.convert(row);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize row '" + row + "'. ", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawFormatSerializationSchema that = (RawFormatSerializationSchema)o;
        return this.serializedType.equals(that.serializedType) && this.charsetName.equals(that.charsetName) && this.isBigEndian == that.isBigEndian;
    }

    public int hashCode() {
        return Objects.hash(this.serializedType, this.charsetName, this.isBigEndian);
    }

    private SerializationRuntimeConverter createConverter(LogicalType type, String charsetName, boolean isBigEndian) {
        final SerializationRuntimeConverter converter = this.createNotNullConverter(type, charsetName, isBigEndian);
        return new SerializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public void open() {
                converter.open();
            }

            @Override
            public byte[] convert(RowData row) throws IOException {
                if (row.isNullAt(0)) {
                    return null;
                }
                return converter.convert(row);
            }
        };
    }

    /*
     * Exception decompiling
     */
    private SerializationRuntimeConverter createNotNullConverter(LogicalType type, String charsetName, boolean isBigEndian) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SerializationRuntimeConverter createStringConverter(final String charsetName) {
        Charset charset = Charset.forName(charsetName);
        if (charset == StandardCharsets.UTF_8) {
            return row -> row.getString(0).toBytes();
        }
        return new SerializationRuntimeConverter(){
            private static final long serialVersionUID = 1L;
            private transient Charset charset;

            @Override
            public void open() {
                this.charset = Charset.forName(charsetName);
            }

            @Override
            public byte[] convert(RowData row) {
                String str = row.getString(0).toString();
                return str.getBytes(this.charset);
            }
        };
    }

    private static SerializationRuntimeConverter createRawValueConverter(RawType<?> rawType) {
        TypeSerializer<?> serializer = rawType.getTypeSerializer();
        return row -> row.getRawValue(0).toBytes(serializer);
    }

    private static final class DoubleSerializationConverter
    implements SerializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final boolean isBigEndian;

        private DoubleSerializationConverter(boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public byte[] convert(RowData row) {
            HeapMemorySegment segment = HeapMemorySegment.FACTORY.wrap(new byte[8]);
            if (this.isBigEndian) {
                segment.putDoubleBigEndian(0, row.getDouble(0));
            } else {
                segment.putDoubleLittleEndian(0, row.getDouble(0));
            }
            return segment.getArray();
        }
    }

    private static final class FloatSerializationConverter
    implements SerializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final boolean isBigEndian;

        private FloatSerializationConverter(boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public byte[] convert(RowData row) {
            HeapMemorySegment segment = HeapMemorySegment.FACTORY.wrap(new byte[4]);
            if (this.isBigEndian) {
                segment.putFloatBigEndian(0, row.getFloat(0));
            } else {
                segment.putFloatLittleEndian(0, row.getFloat(0));
            }
            return segment.getArray();
        }
    }

    private static final class LongSerializationConverter
    implements SerializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final boolean isBigEndian;

        private LongSerializationConverter(boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public byte[] convert(RowData row) {
            HeapMemorySegment segment = HeapMemorySegment.FACTORY.wrap(new byte[8]);
            if (this.isBigEndian) {
                segment.putLongBigEndian(0, row.getLong(0));
            } else {
                segment.putLongLittleEndian(0, row.getLong(0));
            }
            return segment.getArray();
        }
    }

    private static final class IntegerSerializationConverter
    implements SerializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final boolean isBigEndian;

        private IntegerSerializationConverter(boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public byte[] convert(RowData row) {
            HeapMemorySegment segment = HeapMemorySegment.FACTORY.wrap(new byte[4]);
            if (this.isBigEndian) {
                segment.putIntBigEndian(0, row.getInt(0));
            } else {
                segment.putIntLittleEndian(0, row.getInt(0));
            }
            return segment.getArray();
        }
    }

    private static final class ShortSerializationConverter
    implements SerializationRuntimeConverter {
        private static final long serialVersionUID = 1L;
        private final boolean isBigEndian;

        private ShortSerializationConverter(boolean isBigEndian) {
            this.isBigEndian = isBigEndian;
        }

        @Override
        public byte[] convert(RowData row) {
            HeapMemorySegment segment = HeapMemorySegment.FACTORY.wrap(new byte[2]);
            if (this.isBigEndian) {
                segment.putShortBigEndian(0, row.getShort(0));
            } else {
                segment.putShortLittleEndian(0, row.getShort(0));
            }
            return segment.getArray();
        }
    }

    @FunctionalInterface
    private static interface SerializationRuntimeConverter
    extends Serializable {
        default public void open() {
        }

        public byte[] convert(RowData var1) throws IOException;
    }
}

