/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions.python;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.python.PythonEnv;
import org.apache.flink.table.functions.python.PythonFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.TypeInference;
import org.apache.flink.table.types.inference.TypeStrategies;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class PythonAggregateFunction
extends AggregateFunction
implements PythonFunction {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final byte[] serializedAggregateFunction;
    private final DataType[] inputTypes;
    private final DataType resultType;
    private final DataType accumulatorType;
    private final PythonFunctionKind pythonFunctionKind;
    private final boolean deterministic;
    private final PythonEnv pythonEnv;

    public PythonAggregateFunction(String name, byte[] serializedAggregateFunction, DataType[] inputTypes, DataType resultType2, DataType accumulatorType, PythonFunctionKind pythonFunctionKind, boolean deterministic, PythonEnv pythonEnv) {
        this.name = name;
        this.serializedAggregateFunction = serializedAggregateFunction;
        this.inputTypes = inputTypes;
        this.resultType = resultType2;
        this.accumulatorType = accumulatorType;
        this.pythonFunctionKind = pythonFunctionKind;
        this.deterministic = deterministic;
        this.pythonEnv = pythonEnv;
    }

    public void accumulate(Object accumulator, Object ... args) {
        throw new UnsupportedOperationException("This method is a placeholder and should not be called.");
    }

    public Object getValue(Object accumulator) {
        return null;
    }

    @Override
    public Object createAccumulator() {
        return null;
    }

    @Override
    public byte[] getSerializedPythonFunction() {
        return this.serializedAggregateFunction;
    }

    @Override
    public PythonEnv getPythonEnv() {
        return this.pythonEnv;
    }

    @Override
    public PythonFunctionKind getPythonFunctionKind() {
        return this.pythonFunctionKind;
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public TypeInformation getResultType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.resultType);
    }

    @Override
    public TypeInformation getAccumulatorType() {
        return TypeConversions.fromDataTypeToLegacyInfo(this.accumulatorType);
    }

    @Override
    public TypeInference getTypeInference(DataTypeFactory typeFactory) {
        TypeInference.Builder builder = TypeInference.newBuilder();
        if (this.inputTypes != null) {
            builder.typedArguments(this.inputTypes);
        }
        return builder.outputTypeStrategy(TypeStrategies.explicit(this.resultType)).accumulatorTypeStrategy(TypeStrategies.explicit(this.accumulatorType)).build();
    }

    @Override
    public String toString() {
        return this.name;
    }
}

