/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.util.SourceStringReader;
import org.apache.flink.sql.parser.hive.impl.FlinkHiveSqlParserImpl;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.table.api.SqlParserException;

public class CalciteParser {
    private final SqlParser.Config config;

    public CalciteParser(SqlParser.Config config) {
        this.config = config;
    }

    public SqlNode parse(String sql) {
        try {
            SqlParser parser = SqlParser.create(sql, this.config);
            return parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new SqlParserException("SQL parse failed. " + e.getMessage(), e);
        }
    }

    public SqlNode parseExpression(String sqlExpression) {
        try {
            SqlParser parser = SqlParser.create(sqlExpression, this.config);
            return parser.parseExpression();
        }
        catch (SqlParseException e) {
            throw new SqlParserException("SQL parse failed. " + e.getMessage(), e);
        }
    }

    public SqlIdentifier parseIdentifier(String identifier) {
        try {
            SqlAbstractParserImpl flinkParser = this.createFlinkParser(identifier);
            if (flinkParser instanceof FlinkSqlParserImpl) {
                return ((FlinkSqlParserImpl)flinkParser).TableApiIdentifier();
            }
            if (flinkParser instanceof FlinkHiveSqlParserImpl) {
                return ((FlinkHiveSqlParserImpl)flinkParser).TableApiIdentifier();
            }
            throw new IllegalArgumentException("Unrecognized sql parser type " + flinkParser.getClass().getName());
        }
        catch (Exception e) {
            throw new SqlParserException(String.format("Invalid SQL identifier %s.", identifier), e);
        }
    }

    private SqlAbstractParserImpl createFlinkParser(String expr) {
        SourceStringReader reader = new SourceStringReader(expr);
        SqlAbstractParserImpl parser = this.config.parserFactory().getParser(reader);
        parser.setTabSize(1);
        parser.setQuotedCasing(this.config.quotedCasing());
        parser.setUnquotedCasing(this.config.unquotedCasing());
        parser.setIdentifierMaxLength(this.config.identifierMaxLength());
        parser.setConformance(this.config.conformance());
        switch (this.config.quoting()) {
            case DOUBLE_QUOTE: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.DQID);
                break;
            }
            case BACK_TICK: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.BTID);
                break;
            }
            case BRACKET: {
                parser.switchTo(SqlAbstractParserImpl.LexicalState.DEFAULT);
            }
        }
        return parser;
    }
}

