/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.planner.delegation.ExecutorBase;
import org.apache.flink.table.planner.utils.ExecutorUtils;

@Internal
public class BatchExecutor
extends ExecutorBase {
    @VisibleForTesting
    public BatchExecutor(StreamExecutionEnvironment executionEnvironment) {
        super(executionEnvironment);
    }

    @Override
    public Pipeline createPipeline(List<Transformation<?>> transformations, TableConfig tableConfig, String jobName) {
        StreamExecutionEnvironment execEnv = this.getExecutionEnvironment();
        ExecutorUtils.setBatchProperties(execEnv, tableConfig);
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(execEnv, transformations);
        streamGraph.setJobName(this.getNonEmptyJobName(jobName));
        ExecutorUtils.setBatchProperties(streamGraph, tableConfig);
        return streamGraph;
    }
}

