/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.functions.aggfunctions.InternalAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class FirstValueAggFunction<T>
extends InternalAggregateFunction<T, RowData> {
    private transient DataType valueDataType;

    public FirstValueAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType(valueType);
    }

    @Override
    public DataType[] getInputDataTypes() {
        return new DataType[]{this.valueDataType};
    }

    @Override
    public DataType getAccumulatorDataType() {
        return (DataType)DataTypes.ROW(DataTypes.FIELD("firstValue", (DataType)this.valueDataType.nullable()), DataTypes.FIELD("firstOrder", DataTypes.BIGINT())).bridgedTo(RowData.class);
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public RowData createAccumulator() {
        GenericRowData acc = new GenericRowData(2);
        acc.setField(0, null);
        acc.setField(1, Long.MAX_VALUE);
        return acc;
    }

    public void accumulate(RowData rowData, Object value) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value != null && acc.getLong(1) == Long.MAX_VALUE) {
            acc.setField(0, value);
            acc.setField(1, System.currentTimeMillis());
        }
    }

    public void accumulate(RowData rowData, Object value, Long order) {
        GenericRowData acc = (GenericRowData)rowData;
        if (value != null && acc.getLong(1) > order) {
            acc.setField(0, value);
            acc.setField(1, order);
        }
    }

    public void accumulate(RowData rowData, StringData value) {
        if (value != null) {
            this.accumulate(rowData, (Object)((BinaryStringData)value).copy());
        }
    }

    public void accumulate(RowData rowData, StringData value, Long order) {
        if (value != null) {
            this.accumulate(rowData, (Object)((BinaryStringData)value).copy(), order);
        }
    }

    public void resetAccumulator(RowData rowData) {
        GenericRowData acc = (GenericRowData)rowData;
        acc.setField(0, null);
        acc.setField(1, Long.MAX_VALUE);
    }

    @Override
    public T getValue(RowData acc) {
        GenericRowData genericAcc = (GenericRowData)acc;
        return (T)genericAcc.getField(0);
    }
}

