/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.functions.aggfunctions.InternalAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class LastValueWithRetractAggFunction<T>
extends InternalAggregateFunction<T, LastValueWithRetractAccumulator<T>> {
    private transient DataType valueDataType;

    public LastValueWithRetractAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType(valueType);
    }

    @Override
    public DataType[] getInputDataTypes() {
        return new DataType[]{this.valueDataType};
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(LastValueWithRetractAccumulator.class, DataTypes.FIELD("lastValue", (DataType)this.valueDataType.nullable()), DataTypes.FIELD("lastOrder", DataTypes.BIGINT()), DataTypes.FIELD("valueToOrderMap", MapView.newMapViewDataType((DataType)this.valueDataType.notNull(), (DataType)DataTypes.ARRAY(DataTypes.BIGINT()).bridgedTo(List.class))), DataTypes.FIELD("orderToValueMap", MapView.newMapViewDataType(DataTypes.BIGINT(), (DataType)DataTypes.ARRAY((DataType)this.valueDataType.notNull()).bridgedTo(List.class))));
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    @Override
    public LastValueWithRetractAccumulator<T> createAccumulator() {
        return new LastValueWithRetractAccumulator();
    }

    public void accumulate(LastValueWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            Long order = System.currentTimeMillis();
            List<Long> orderList = acc.valueToOrderMap.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            acc.valueToOrderMap.put(v, orderList);
            this.accumulate(acc, value, order);
        }
    }

    public void accumulate(LastValueWithRetractAccumulator<T> acc, Object value, Long order) throws Exception {
        if (value != null) {
            List valueList;
            Object v = value;
            Long prevOrder = acc.lastOrder;
            if (prevOrder == null || prevOrder <= order) {
                acc.lastValue = v;
                acc.lastOrder = order;
            }
            if ((valueList = acc.orderToValueMap.get(order)) == null) {
                valueList = new ArrayList();
            }
            valueList.add(v);
            acc.orderToValueMap.put(order, valueList);
        }
    }

    public void accumulate(LastValueWithRetractAccumulator<T> acc, StringData value) throws Exception {
        if (value != null) {
            this.accumulate(acc, (Object)((BinaryStringData)value).copy());
        }
    }

    public void accumulate(LastValueWithRetractAccumulator<T> acc, StringData value, Long order) throws Exception {
        if (value != null) {
            this.accumulate(acc, (Object)((BinaryStringData)value).copy(), order);
        }
    }

    public void retract(LastValueWithRetractAccumulator<T> acc, Object value) throws Exception {
        Object v;
        List<Long> orderList;
        if (value != null && (orderList = acc.valueToOrderMap.get(v = value)) != null && orderList.size() > 0) {
            Long order = orderList.get(0);
            orderList.remove(0);
            if (orderList.isEmpty()) {
                acc.valueToOrderMap.remove(v);
            } else {
                acc.valueToOrderMap.put(v, orderList);
            }
            this.retract(acc, value, order);
        }
    }

    public void retract(LastValueWithRetractAccumulator<T> acc, Object value, Long order) throws Exception {
        if (value != null) {
            Object v = value;
            List valueList = acc.orderToValueMap.get(order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    acc.orderToValueMap.remove(order);
                } else {
                    acc.orderToValueMap.put(order, valueList);
                }
            }
            if (v.equals(acc.lastValue)) {
                Long startKey = acc.lastOrder;
                Iterator<Long> iter = acc.orderToValueMap.keys().iterator();
                Long nextKey = Long.MIN_VALUE;
                while (iter.hasNext()) {
                    Long key = iter.next();
                    if (key > startKey || key <= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MIN_VALUE) {
                    List values = acc.orderToValueMap.get(nextKey);
                    acc.lastValue = values.get(values.size() - 1);
                    acc.lastOrder = nextKey;
                } else {
                    acc.lastValue = null;
                    acc.lastOrder = null;
                }
            }
        }
    }

    public void resetAccumulator(LastValueWithRetractAccumulator<T> acc) {
        acc.lastValue = null;
        acc.lastOrder = null;
        acc.valueToOrderMap.clear();
        acc.orderToValueMap.clear();
    }

    @Override
    public T getValue(LastValueWithRetractAccumulator<T> acc) {
        return acc.lastValue;
    }

    public static class LastValueWithRetractAccumulator<T> {
        public T lastValue = null;
        public Long lastOrder = null;
        public MapView<T, List<Long>> valueToOrderMap = new MapView();
        public MapView<Long, List<T>> orderToValueMap = new MapView();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LastValueWithRetractAccumulator)) {
                return false;
            }
            LastValueWithRetractAccumulator that = (LastValueWithRetractAccumulator)o;
            return Objects.equals(this.lastValue, that.lastValue) && Objects.equals(this.lastOrder, that.lastOrder) && this.valueToOrderMap.equals(that.valueToOrderMap) && this.orderToValueMap.equals(that.orderToValueMap);
        }

        public int hashCode() {
            return Objects.hash(this.lastValue, this.lastOrder, this.valueToOrderMap, this.orderToValueMap);
        }
    }
}

