/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.utils;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.table.functions.FunctionIdentifier;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.utils.HiveFunctionUtils;
import org.apache.flink.table.planner.functions.utils.OperandMetadata;
import org.apache.flink.table.planner.functions.utils.TableSqlFunction;
import org.apache.flink.table.planner.functions.utils.UserDefinedFunctionUtils;
import org.apache.flink.table.planner.plan.schema.FlinkTableFunction;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.Tuple3;

@Deprecated
public class HiveTableSqlFunction
extends TableSqlFunction {
    private final TableFunction hiveUdtf;
    private final HiveOperandTypeChecker operandTypeChecker;

    public HiveTableSqlFunction(FunctionIdentifier identifier, TableFunction hiveUdtf, DataType implicitResultType, FlinkTypeFactory typeFactory, FlinkTableFunction functionImpl, HiveOperandTypeChecker operandTypeChecker) {
        super(identifier, identifier.toString(), hiveUdtf, implicitResultType, typeFactory, functionImpl, (Option<SqlOperandMetadata>)Option.apply((Object)operandTypeChecker));
        this.hiveUdtf = hiveUdtf;
        this.operandTypeChecker = operandTypeChecker;
    }

    public TableFunction makeFunction(Object[] constantArguments, LogicalType[] argTypes) {
        TableFunction clone;
        try {
            clone = (TableFunction)InstantiationUtil.clone((Serializable)this.hiveUdtf);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return (TableFunction)HiveFunctionUtils.invokeSetArgs(clone, constantArguments, argTypes);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        Preconditions.checkNotNull((Object)this.operandTypeChecker.previousArgTypes);
        FlinkTypeFactory factory = (FlinkTypeFactory)typeFactory;
        Object[] argumentsArray = HiveTableSqlFunction.convertArguments(Arrays.stream(this.operandTypeChecker.previousArgTypes).map(factory::createFieldTypeFromLogicalType).collect(Collectors.toList()), arguments);
        DataType resultType2 = LogicalTypeDataTypeConverter.fromLogicalTypeToDataType(FlinkTypeFactory.toLogicalType(HiveFunctionUtils.invokeGetResultType(this.hiveUdtf, argumentsArray, this.operandTypeChecker.previousArgTypes, (FlinkTypeFactory)typeFactory)));
        Tuple3<String[], int[], LogicalType[]> fieldInfo = UserDefinedFunctionUtils.getFieldInfo(resultType2);
        return UserDefinedFunctionUtils.buildRelDataType(typeFactory, LogicalTypeDataTypeConverter.fromDataTypeToLogicalType(resultType2), (String[])fieldInfo._1(), (int[])fieldInfo._2());
    }

    private static Object[] convertArguments(List<RelDataType> operandTypes, List<Object> arguments0) {
        ArrayList<Object> arguments = new ArrayList<Object>(arguments0.size());
        for (Pair<RelDataType, Object> pair : Pair.zip(operandTypes, arguments0)) {
            arguments.add(HiveTableSqlFunction.coerce(pair.right, (RelDataType)pair.left));
        }
        return arguments.toArray();
    }

    private static Object coerce(Object value, RelDataType type) {
        if (value == null) {
            return null;
        }
        switch (type.getSqlTypeName()) {
            case CHAR: {
                return ((NlsString)value).getValue();
            }
            case BINARY: {
                return ((BitString)value).getAsByteArray();
            }
            case DECIMAL: {
                return value;
            }
            case BIGINT: {
                return ((BigDecimal)value).longValue();
            }
            case INTEGER: {
                return ((BigDecimal)value).intValue();
            }
            case SMALLINT: {
                return ((BigDecimal)value).shortValue();
            }
            case TINYINT: {
                return ((BigDecimal)value).byteValue();
            }
            case DOUBLE: {
                return ((BigDecimal)value).doubleValue();
            }
            case REAL: {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
            case FLOAT: {
                return Float.valueOf(((BigDecimal)value).floatValue());
            }
            case DATE: {
                return LocalDate.ofEpochDay(((DateString)value).getDaysSinceEpoch());
            }
            case TIME: {
                return LocalTime.ofNanoOfDay(((TimeString)value).getMillisOfDay() * 1000000);
            }
            case TIMESTAMP: {
                return SqlDateTimeUtils.unixTimestampToLocalDateTime(((TimestampString)value).getMillisSinceEpoch());
            }
        }
        throw new RuntimeException("Not support type: " + type);
    }

    public static HiveOperandTypeChecker operandTypeChecker(String name, TableFunction udtf) {
        return new HiveOperandTypeChecker(name, udtf, UserDefinedFunctionUtils.checkAndExtractMethods(udtf, "eval"));
    }

    @Deprecated
    public static class HiveOperandTypeChecker
    extends OperandMetadata {
        private LogicalType[] previousArgTypes;

        private HiveOperandTypeChecker(String name, TableFunction udtf, Method[] methods) {
            super(name, udtf, methods);
        }

        @Override
        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            this.previousArgTypes = UserDefinedFunctionUtils.getOperandTypeArray(callBinding);
            return super.checkOperandTypes(callBinding, throwOnFailure);
        }
    }
}

