/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.stream;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.plan.nodes.physical.stream.DeduplicateOperatorTranslator;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamExecDeduplicate;
import org.apache.flink.table.runtime.operators.bundle.KeyedMapBundleOperator;
import org.apache.flink.table.runtime.operators.bundle.trigger.CountBundleTrigger;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeDeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeMiniBatchDeduplicateKeepFirstRowFunction;
import org.apache.flink.table.runtime.operators.deduplicate.ProcTimeMiniBatchDeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3A!\u0001\u0002\u0001+\t)\u0003K]8d)&lW\rR3ekBd\u0017nY1uK>\u0003XM]1u_J$&/\u00198tY\u0006$xN\u001d\u0006\u0003\u0007\u0011\taa\u001d;sK\u0006l'BA\u0003\u0007\u0003!\u0001\b._:jG\u0006d'BA\u0004\t\u0003\u0015qw\u000eZ3t\u0015\tI!\"\u0001\u0003qY\u0006t'BA\u0006\r\u0003\u001d\u0001H.\u00198oKJT!!\u0004\b\u0002\u000bQ\f'\r\\3\u000b\u0005=\u0001\u0012!\u00024mS:\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u001e\t\u0016$W\u000f\u001d7jG\u0006$Xm\u00149fe\u0006$xN\u001d+sC:\u001cH.\u0019;pe\"A1\u0004\u0001B\u0001B\u0003%A$A\u0006s_^$\u0016\u0010]3J]\u001a|\u0007cA\u000f#I5\taD\u0003\u0002 A\u0005IA/\u001f9fkRLGn\u001d\u0006\u0003C1\tqA];oi&lW-\u0003\u0002$=\t\u0001\u0012J\u001c;fe:\fG\u000eV=qK&sgm\u001c\t\u0003K!j\u0011A\n\u0006\u0003O1\tA\u0001Z1uC&\u0011\u0011F\n\u0002\b%><H)\u0019;b\u0011!Y\u0003A!A!\u0002\u0013a\u0013AC:fe&\fG.\u001b>feB\u0019Qf\r\u0013\u000e\u00039R!aH\u0018\u000b\u0005A\n\u0014AB2p[6|gN\u0003\u00023\u001d\u0005\u0019\u0011\r]5\n\u0005Qr#A\u0004+za\u0016\u001cVM]5bY&TXM\u001d\u0005\tm\u0001\u0011\t\u0011)A\u0005o\u0005YA/\u00192mK\u000e{gNZ5h!\tA$(D\u0001:\u0015\t\u0011D\"\u0003\u0002<s\tYA+\u00192mK\u000e{gNZ5h\u0011!i\u0004A!A!\u0002\u0013q\u0014a\u00033fIV\u0004H.[2bi\u0016\u0004\"aF \n\u0005\u0001\u0013!!F*ue\u0016\fW.\u0012=fG\u0012+G-\u001e9mS\u000e\fG/\u001a\u0005\u0006\u0005\u0002!\taQ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0011+ei\u0012%\u0011\u0005]\u0001\u0001\"B\u000eB\u0001\u0004a\u0002\"B\u0016B\u0001\u0004a\u0003\"\u0002\u001cB\u0001\u00049\u0004\"B\u001fB\u0001\u0004q\u0004\"\u0002&\u0001\t\u0003Z\u0015!G2sK\u0006$X\rR3ekBd\u0017nY1uK>\u0003XM]1u_J$\u0012\u0001\u0014\t\u0005\u001bN#C%D\u0001O\u0015\ty\u0005+A\u0005pa\u0016\u0014\u0018\r^8sg*\u0011!'\u0015\u0006\u0003%:\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\u0005Qs%AF(oK&s\u0007/\u001e;TiJ,\u0017-\\(qKJ\fGo\u001c:")
public class ProcTimeDeduplicateOperatorTranslator
extends DeduplicateOperatorTranslator {
    private final InternalTypeInfo<RowData> rowTypeInfo;
    private final TypeSerializer<RowData> serializer;

    @Override
    public OneInputStreamOperator<RowData, RowData> createDeduplicateOperator() {
        Object object;
        if (this.isMiniBatchEnabled()) {
            CountBundleTrigger trigger = new CountBundleTrigger(this.miniBatchSize());
            if (this.keepLastRow()) {
                ProcTimeMiniBatchDeduplicateKeepLastRowFunction processFunction = new ProcTimeMiniBatchDeduplicateKeepLastRowFunction(this.rowTypeInfo, this.serializer, this.minRetentionTime(), this.generateUpdateBefore(), this.generateInsert(), true);
                object = new KeyedMapBundleOperator<RowData, RowData, RowData, RowData>(processFunction, trigger);
            } else {
                ProcTimeMiniBatchDeduplicateKeepFirstRowFunction processFunction = new ProcTimeMiniBatchDeduplicateKeepFirstRowFunction(this.serializer, this.minRetentionTime());
                object = new KeyedMapBundleOperator<RowData, RowData, RowData, RowData>(processFunction, trigger);
            }
        } else if (this.keepLastRow()) {
            ProcTimeDeduplicateKeepLastRowFunction processFunction = new ProcTimeDeduplicateKeepLastRowFunction(this.rowTypeInfo, this.minRetentionTime(), this.generateUpdateBefore(), this.generateInsert(), true);
            object = new KeyedProcessOperator((KeyedProcessFunction)processFunction);
        } else {
            ProcTimeDeduplicateKeepFirstRowFunction processFunction = new ProcTimeDeduplicateKeepFirstRowFunction(this.minRetentionTime());
            object = new KeyedProcessOperator((KeyedProcessFunction)processFunction);
        }
        return object;
    }

    public ProcTimeDeduplicateOperatorTranslator(InternalTypeInfo<RowData> rowTypeInfo, TypeSerializer<RowData> serializer, TableConfig tableConfig, StreamExecDeduplicate deduplicate) {
        this.rowTypeInfo = rowTypeInfo;
        this.serializer = serializer;
        super(rowTypeInfo, serializer, tableConfig, deduplicate);
    }
}

