/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.connector.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.runtime.connector.source.DataStructureConverterWrapper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class LookupRuntimeProviderContext
implements LookupTableSource.LookupContext {
    private final int[][] lookupKeys;

    public LookupRuntimeProviderContext(int[][] lookupKeys) {
        this.lookupKeys = lookupKeys;
    }

    @Override
    public int[][] getKeys() {
        return this.lookupKeys;
    }

    public TypeInformation<?> createTypeInformation(DataType producedDataType) {
        DataTypeUtils.validateInputDataType(producedDataType);
        return InternalTypeInfo.of(producedDataType.getLogicalType());
    }

    @Override
    public DynamicTableSource.DataStructureConverter createDataStructureConverter(DataType producedDataType) {
        DataTypeUtils.validateInputDataType(producedDataType);
        return new DataStructureConverterWrapper(DataStructureConverters.getConverter(producedDataType));
    }
}

